/*
 * netdb.h
 */


#ifndef netdb_h
#define netdb_h


#include<inttypes.h>
#include<sys/socket.h>


struct hostent{
	char   *h_name;			/* Official name of the host. */
	char  **h_aliases;		/* A pointer to an array of pointers to alternative host names. */
	int     h_addrtype;		/* Address type. */
	int     h_length;		/* The length, in bytes, of the address. */
	char  **h_addr_list;	/* A pointer to an array of pointers to network addresses (in network byte order) for the host. */
#define	h_addr h_addr_list[0]
};

struct netent{
	char     *n_name;		/* Official, fully-qualified (including the domain) name of the host. */
	char    **n_aliases;	/* A pointer to an array of pointers to alternative network names. */
	int       n_addrtype;	/* The address type of the network. */
	uint32_t  n_net;		/* The network number, in host byte order. */
};

struct protoent{
	char   *p_name;		/* Official name of the protocol. */
	char  **p_aliases;	/* A pointer to an array of pointers to alternative protocol names. */
	int     p_proto;	/* The protocol number. */
};

struct servent{
	char   *s_name;		/* Official name of the service. */
	char  **s_aliases;	/* A pointer to an array of pointers to alternative service names. */
	int     s_port;		/* The port number at which the service resides, in network byte order. */
	char   *s_proto;	/* The name of the protocol to use when contacting the service. */
};

struct addrinfo{
	int               ai_flags;		/* Input flags. */
	int               ai_family;	/* Address family of socket. */
	int               ai_socktype;	/* Socket type. */
	int               ai_protocol;	/* Protocol of socket. */
	socklen_t         ai_addrlen;	/* Length of socket address. */
	struct sockaddr  *ai_addr;		/* Socket address of socket. */
	char             *ai_canonname;	/* Canonical name of service location. */
	struct addrinfo  *ai_next;		/* Pointer to next in list. */
};


struct hostent  *gethostbyname(const char *);

/* ̤ */
void             endhostent(void);
void             endnetent(void);
void             endprotoent(void);
void             endservent(void);
void             freeaddrinfo(struct addrinfo *);
const char      *gai_strerror(int);
int              getaddrinfo(const char *, const char *,const struct addrinfo *,struct addrinfo **);
struct hostent  *gethostbyaddr(const void *, socklen_t, int);
struct hostent  *gethostent(void);
int              getnameinfo(const struct sockaddr *, socklen_t,char *, socklen_t, char *,socklen_t, unsigned);
struct netent   *getnetbyaddr(uint32_t, int);
struct netent   *getnetbyname(const char *);
struct netent   *getnetent(void);
struct protoent *getprotobyname(const char *);
struct protoent *getprotobynumber(int);
struct protoent *getprotoent(void);
struct servent  *getservbyname(const char *, const char *);
struct servent  *getservbyport(int, const char *);
struct servent  *getservent(void);
void             sethostent(int);
void             setnetent(int);
void             setprotoent(int);
void             setservent(int);


#endif
