/*
 * net.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ͥåȥ̥إå
 */


#ifndef net_h
#define net_h


#include<types.h>
#include<proc.h>
#include<share/ip.h>
#include<share/socket.h>
#include<share/in.h>


#ifndef ASM_FILE


typedef struct{
	char  *data[3];		/* ե졼ॢɥ쥹 */
	int    size[3];		/* ǡե졼ॵ */
	ushort type;		/* ե졼ॿס */
	uchar  ipType;		/* IPץȥ륿ס */
}TRANS_BUF_INFO;

typedef struct SOCKET{
	uchar               form;		/* եμࡣ */
	uchar               refCount;	/* ȥȡ */
	uchar               sockType;	/* åȥס */
	uchar volatile      update;		/* Update flag. */
	void               *sinf;		/* SOCKET_INFO. */
	in_port_t           srcport;	/* Source port number. */
	in_port_t           dstport;	/* Connection port number. */
	in_addr_t           dstip;		/* Connection IP address. */
	in_addr_t           srcip;		/* Local host IP address. */
	IP_HEADER volatile *buf;		/* Receive buffer address. */
	WAIT_INTR           wait;		/* Interrupt wait queue. */
	uint32_t            seqnum;		/* Sequence number. */
	uint32_t            acknum;		/* Ack number. */
	struct SOCKET      *next;		/* ͥ󥯡 */
	struct SOCKET      *prev;		/*  */
	struct SOCKET      *waitNext;	/* ͥǽԤ󥯡 */
	uint                waitTime;	/* ǽԤϻms */
	uint16_t            mss;		/* ͥΥ祵 */
	uint16_t            window;		/* ͥ襦ɥ */
	uchar               stat;		/* ͥ֡ */
	uchar volatile      waitCnt;	/* Ԥȡ */
}SOCKET;

typedef struct{
	int (*send)(SOCKET*,const void *msg,size_t len,int flags,struct sockaddr *to);
	int (*recv)(SOCKET*,void*,size_t,int,uint32_t*);
	int (*connect)(SOCKET*);
	int (*shutdown)(SOCKET*,int);
	int (*listen)(SOCKET*);
	int (*accept)(SOCKET*,SOCKET*,uint32_t*);
}SOCKET_INFO;


extern inline uint16_t swapWord(ushort value)
{
	return (value>>8)+(value<<8);
}

extern inline uint32_t swapInt32(uint32_t value)
{
	return (value>>24)+((value>>8)&0xff00)+((value<<8)&0xff0000)+(value<<24);
}

extern ushort calcSum(uint*,int);
extern ushort calcSumM(uint*,uint*,int,int);
extern void closeSocket(SOCKET*);
extern int sys_socket();
extern int sys_send();
extern int sys_recv();
extern int sys_connect();
extern int sys_shutdown();
extern int sys_bind();
extern int sys_listen();
extern int sys_accept();
extern int registSocket(SOCKET_INFO*,int);
extern int initNet();


#endif


#endif
