/*
 * stropts.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<stropts.h>


int ioctl(int fildes,int request,...)
{
	int rest;
	int *arg;


	arg=(int*)&request+1;
	switch(request)
	{
		case IOCTL_COM_TCDRAIN:
			rest=syscall4(SYS_IOCTL,fildes,0,request);
			break;
		case IOCTL_COM_TCGETTCATTR:
		case IOCTL_COM_TCSENDBREAK:
		case IOCTL_COM_TCFLASH:
		case IOCTL_COM_TCFLOW:
			rest=syscall5(SYS_IOCTL,fildes,1,request,*arg);
			break;
		case IOCTL_COM_TCSETTCATTR:
			rest=syscall6(SYS_IOCTL,fildes,2,request,*arg,*(arg+1));
			break;
		default:
			rest=-EINVAL;
	}

	if(rest<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}
