/*
 * stat.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<unistd.h>
#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<fcntl.h>
#include<sys/stat.h>


int openMask=0;


int mkdir(const char *path, mode_t mode)
{
	int rest;


	if((rest=syscall3(SYS_MKDIR,(int)path,(int)mode))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int fstat(int fildes,struct stat *buf)
{
	int rest;


	if((rest=syscall4(SYS_STAT,fildes,(int)NULL,(int)buf))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int stat(const char *path,struct stat *buf)
{
	int rest;


	if((rest=syscall4(SYS_STAT,0,(int)path,(int)buf))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int chmod(const char *path, mode_t mode)
{
	int rest;


	if((rest=syscall4(SYS_CHATTR,(int)path,CHATTR_MODE,(int)mode))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


mode_t umask(mode_t mask)
{
	mode_t old;


	old=openMask;
	openMask=mask&0x1f;

	return old;
}


int mkfifo(const char *pathname, mode_t mode)
{
	int fd;


	if((fd=creat(pathname,mode|O_FIFO))==-1)return -1;
	close(fd);

	return 0;
}
