/*
 * ping.c
 *
 * usage : ping host(IPɥ쥹 or URL)
 */


#include<stdio.h>
#include<stdlib.h>
#include<ctype.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<share/icmp.h>
#include<share/ip.h>
#include<netdb.h>


typedef struct{
	int seqnum;		/* ֹ档 */
}PING_DATA;


/*
 * Print usage.
 */
void usage()
{
	printf("usage: ping host\n");
}


/*
 * parameters : ICMP_HEADER address,ICMP_HEADER structure size
 *
 */
static void mkIcmp(ICMP_HEADER *head,int size)
{
	head->type=ICMP_TYPE_ECHOREQ;
	head->code=0;
	head->chksum=0;
	head->chksum=calcSum((uint*)head,size);
}


int main(int argc,char *argv[])
{
	enum{
		IP_DATA_SIZE=sizeof(IP_HEADER)+sizeof(ICMP_HEADER)+sizeof(PING_DATA),
		ICMP_DATA_SIZE=sizeof(ICMP_HEADER)+sizeof(PING_DATA),
	};

	char buf[IP_DATA_SIZE];
	char addrbuf[sizeof(struct sockaddr)+sizeof(uint32_t)];
	int sd;
	ICMP_HEADER *volatile head;
	PING_DATA *data;
	socklen_t len;
	struct sockaddr_in saddr;
	struct hostent *hostent;
	struct sockaddr *raddr;
	int i;


	/* IPɥ쥹ꡣ */
	if(argc==1)
	{
		printf("Arguments is few!\n");
		usage();
		return 0;
	}

	if((hostent=gethostbyname(argv[1]))==NULL)
	{
		printf("Host name or host address is not correct!\n");
		usage();
		return 0;
	}
	saddr.sin_addr.s_addr=*(uint32_t*)hostent->h_addr_list[0];
	saddr.sin_family=AF_INET;

	/* åȤγΩ */
	if((sd=socket(AF_INET,SOCK_RAW,IPPROTO_ICMP))<0)
	{
		perror("Error socket()");
		return 0;
	}

	/* ǡ */
	for(i=1;;)
	{

		head=(ICMP_HEADER*)buf;
		data=(PING_DATA*)head->data;

		/* Set data. */
		data->seqnum=i;

		/* Make icmp data. */
		mkIcmp(head,ICMP_DATA_SIZE);

		/* Send to network. */
		if(sendto(sd,head,ICMP_DATA_SIZE,0,(struct sockaddr*)&saddr,sizeof(saddr))==-1)
		{
			perror("Error sendto()");
			break;
		}

		/* Receive ICMP data. */
		len=sizeof(addrbuf);
		raddr=(struct sockaddr*)addrbuf;
		if(recvfrom(sd,buf,IP_DATA_SIZE,0,raddr,&len)==-1)
		{
			perror("Error recvfrom()");
			break;
		}
		head=(ICMP_HEADER*)((IP_HEADER*)buf)->data;
		data=(PING_DATA*)head->data;
		printf("Reply from %d.%d.%d.%d sequence number=%d\n",
			(uchar)raddr->sa_data[0],(uchar)raddr->sa_data[1],(uchar)raddr->sa_data[2],(uchar)raddr->sa_data[3],data->seqnum);

		if(++i>5)break;

		sleep(1);
	}

	return 0;
}
