/*
 * netdb.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<unistd.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
#include<errno.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<netdb.h>
#include<share/user_config.h>
#include<arpa/inet.h>
#include<netinet/netport.h>
/****************************
#include<stdio.h>
*****************************/


/********************************************************************************************
 *
 * DNS request
 *
 ********************************************************************************************/


enum{
	/* ե饰 */
	DNS_FLG_QR_M=       1<<15,	/* QRե饰ޥ */
	DNS_FLG_QR_Q=       0,		/*  */
	DNS_FLG_QR_R=       1<<15,	/* Ȳ */
	DNS_FLG_OP_Q=       0,		/* ɸȲ */
	DNS_FLG_TC_M=       1<<9,	/* TCե饰ޥ */
	DNS_FLG_TC=         1<<9,	/* Դ */
	DNS_FLG_RD=         1<<8,	/* ƵȲ׵ᡣ */
	DNS_FLG_RA_M=       1<<7,	/* Ƶǽե饰ޥ */
	DNS_FLG_RA=         1<<7,	/* Ƶǽ */
	DNS_FLG_REC_M=      0xf,	/* recordեɥޥ */
	DNS_FLG_REC_NOERR=  0,		/* NO ERROR. */
	DNS_FLG_REC_NAMEERR=3,		/* NAME ERROR. */

	/* Ȳ񥿥ס */
	DNS_REQTYPE_A=    1,
	DNS_REQTYPE_NS=   2,
	DNS_REQTYPE_CNAME=5,
	DNS_REQTYPE_PTR=  12,
	DNS_REQTYPE_HINFO=13,
	DNS_REQTYPE_MX=   15,

	DNS_SIZE_MAX=512,	/* DNSå祵 */
	DOMAIN_COMP=0xc0,	/* ɥᥤ̥̾ */
	HOSTENT_IP_MAX=3,	/* struct hostent IPɥ쥹Ǽ */
	DNS_REP_SIZE=10,	/* DNS_REP structure size. */
};


typedef struct{
	uint16_t id;
	uint16_t flag;
	uint16_t qstcnt;	/*  */
	uint16_t rplcnt;	/*  */
	uint16_t athcnt;	/* ҿ */
	uint16_t addcnt;	/* ɲÿ */
}DNS_HEADER;

typedef struct{
	uint16_t type;		/* Ȳ񥿥ס */
	uint16_t class;		/* Ȳ񥯥饹 */
}DNS_REQ;

typedef struct{
	uint16_t type;		/* Ȳ񥿥ס */
	uint16_t class;		/* Ȳ񥯥饹 */
	uint32_t ttl;		/* ¸֡ */
	uint16_t rslen;		/* ꥽ǡĹ */
	char     rsc[0];	/* ꥽ */
}DNS_REP;


/*
 * ɥᥤ͡DNSȲѤѴ롣
 * parameters : name,buffer
 * return : next buffer address
 */
static char *nameToRef(const char *name,char *buf)
{
	char *top;
	int cnt;


	for(;;)
	{
		top=buf;
		++buf;
		cnt=0;
		for(;*name!='.';++name)
		{
			if((isspace(*name))||(*name=='\0'))
			{
				*top=cnt;
				*buf=0;
				return buf+1;
			}
			*buf++=*name;
			++cnt;
		}
		*top=cnt;
		++name;
	}
}


/*
 * ɥᥤ͡Ĺפ롣
 * parameters : name
 * return : name length
 */
static inline int domainLen(uchar *s)
{
	int len=0;


	for(;*s!=0;s+=*s+1)
	{
		if((*s&DOMAIN_COMP)==DOMAIN_COMP)
		{
			len+=sizeof(uint16_t);
			break;
		}
		len+=*s;
	}

	return len;
}


/*
 * Request to DNS.
 * parameters : name,IP buffer
 * return : 0 or failed=-1
 */
static int ReqDns(const char *name,uint32_t ip[])
{
	enum{
		DOMAIN_CNT_LEN=2,	/* ɥᥤ̾Ѵȥꥢץ饹Хȿ */
	};

	uchar *buf;
	int sd;
	int trans_size,domain_size;
	int rplcnt;
	struct sockaddr_in sa;
	uchar *p;
	int i,j;


	/* Check transfer size. */
	trans_size=sizeof(DNS_HEADER)+strlen(name)+DOMAIN_CNT_LEN+sizeof(DNS_REQ);
	if(trans_size>DNS_SIZE_MAX)
	{
		errno=ENAMETOOLONG;
		return -1;
	}

	/* DNSȲåκ */
	if((buf=malloc(DNS_SIZE_MAX))==NULL)
	{
		errno=ENOMEM;
		return -1;
	}
	((DNS_HEADER*)buf)->id=0;
	((DNS_HEADER*)buf)->flag=htons(DNS_FLG_QR_Q|DNS_FLG_OP_Q|DNS_FLG_RD);
	((DNS_HEADER*)buf)->qstcnt=htons(1);
	((DNS_HEADER*)buf)->rplcnt=0;
	((DNS_HEADER*)buf)->athcnt=0;
	((DNS_HEADER*)buf)->addcnt=0;
	p=nameToRef(name,buf+sizeof(DNS_HEADER));
	((DNS_REQ*)p)->type=htons(DNS_REQTYPE_A);
	((DNS_REQ*)p)->class=htons(1);				/* Internet address=1 */

	domain_size=p-(buf+sizeof(DNS_HEADER));		/* domain name size. */

	if((sd=socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP))==-1)goto ERR;

	/* ꡣ */
	sa.sin_family=AF_INET;
	sa.sin_port=htons(NETPORT_NAMESERVER);
	sa.sin_addr.s_addr=IP_NAME_SERVER;

	for(;;)
	{
		uint16_t flag;
		int athcnt;

		/*  */
		if(sendto(sd,buf,trans_size,0,(struct sockaddr*)&sa,sizeof(sa))==-1)goto ERR;

		/*  */
		if(recvfrom(sd,buf,DNS_SIZE_MAX,0,NULL,NULL)==-1)goto ERR;
/*******************************************************************
{
	int size;

	if((size=recvfrom(sd,buf,DNS_SIZE_MAX,0,NULL,NULL))==-1)goto ERR;
	{
		int i;

		for(i=0;i<size;++i)
		{
			if(i%16==0)printf("\n");
			else if(i%2==0)printf(" ");
			printf("%02x",buf[i]);
		}
		printf("\n");
	}
}
********************************************************************/
		/* ե饰θ */
		flag=ntohs(((DNS_HEADER*)buf)->flag);
		if((flag&DNS_FLG_QR_M)!=DNS_FLG_QR_R)continue;		/* Ǥʤ */
		if((flag&DNS_FLG_REC_M)!=DNS_FLG_REC_NOERR)			/* 顼ꡣ */
		{
			errno=HOST_NOT_FOUND;
			goto ERR;
		}

		/* ꡣ */
		if((rplcnt=ntohs(((DNS_HEADER*)buf)->rplcnt))!=0)break;

		/* ¾Υ͡ॵСꡣ */
		if((athcnt=ntohs(((DNS_HEADER*)buf)->athcnt))!=0)
			if(((DNS_HEADER*)buf)->addcnt)
			{
				/* ҾФɲþõ */
				p=buf+trans_size;
				while(athcnt-->0)
				{
					p+=domainLen(p);							/* ɥᥤ͡ॵ­ */
					p+=DNS_REP_SIZE+ntohs(((DNS_REP*)p)->rslen);
				}
				p+=domainLen(p);								/* ɥᥤ͡ॵ­ */
				sa.sin_addr.s_addr=*(uint32_t*)((DNS_REP*)p)->rsc;

				continue;
			}
		errno=HOST_NOT_FOUND;
		goto ERR;
	}

	close(sd);

	/* 롣 */
	p=buf+trans_size;
	j=0;
	for(i=0;i<rplcnt;++i)
	{
		/* ɥᥤ͡ॵ­ */
		p+=domainLen(p);

		if(ntohs(((DNS_REP*)p)->type)==DNS_REQTYPE_A)
		{
			ip[j++]=*(uint32_t*)((DNS_REP*)p)->rsc;
			if(j>=HOSTENT_IP_MAX)break;
			ip[j]=0;
		}

		p+=DNS_REP_SIZE+ntohs(((DNS_REP*)p)->rslen);
	}
	if(j==0)goto ERR;

	free(buf);
	return 0;
ERR:
	free(buf);
	return -1;
}


/********************************************************************************************
 *
 * Systemcall
 *
 ********************************************************************************************/


struct hostent *gethostbyname(const char *name)
{
	static struct hostent hostent;
	static char *pip[HOSTENT_IP_MAX+1];	/* hostentcharݥ󥿡ΰ衣 */
	static uint32_t ip[HOSTENT_IP_MAX];	/* hostentIPɥ쥹ΰ衣 */

	int i;


	/* nameIPɥ쥹? */
	if((ip[0]=inet_addr(name))!=-1)
	{
		pip[0]=(char*)&ip[0];
		pip[1]=NULL;
	}
	else
	{
		/* nameۥ̾ʤDNSꥯȡ */
		if(ReqDns(name,ip)==-1)return NULL;
		for(i=0;i<HOSTENT_IP_MAX;++i)
		{
			if(ip[i]==0)break;
			pip[i]=(char*)&ip[i];
		}
		pip[i]=NULL;
	}

	/* struct hostent ꡣ */
	hostent.h_addrtype=AF_INET;
	hostent.h_length=sizeof(uint32_t);
	hostent.h_addr_list=pip;

	return &hostent;
}
