/*
 * stdio.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<unistd.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<callgate.h>
#include<share/syscall.h>
#include<string.h>
#include<stdarg.h>
#include<system.h>
#include<errno.h>
#include<fcntl.h>
#include<stdlib.h>
#include<ctype.h>
#include<time.h>
#include<stdio.h>


/**************** ǥХå ****************************
static int cnv(uint uvalue,char *buf)
{
	enum{TMP_BUF_SIZE=8};
	int i;


	for(i=TMP_BUF_SIZE-1;;--i)
	{
		buf[i]=uvalue%16+'0';
		if(buf[i]>'9')buf[i]+='a'-'9'-1;
		if(!(uvalue/=16))break;
	}
	memcpy(buf,&buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}
********************************************************/


/***************************************************************************
 *
 * ʸѴ
 *
 ***************************************************************************/

enum{
	/* ե饰ʸӥåȡ */
	PFLG_FORM=   1<<0,		/* '#' */
	PFLG_ZERO=   1<<1,		/* '0' */
	PFLG_LEFT=   1<<2,		/* '-' */
	PFLG_SPACE=  1<<3,		/* ' ' */
	PFLG_PLUS=   1<<4,		/* '+' */

	TMP_BUF_SIZE=12,	/* ʸѴѺȥХåե */
};


/*
 * ꡼Ǹ夫饳ԡ
 * parameters : destination buffer,source buffer
 */
static inline void memcpyBack(char *dst,char *src,int n)
{
	while(--n>=0)dst[n]=src[n];
}


/*
 * 0ʸƬ롣
 * parameters : destination buffer,buffer size,fill size
 */
static inline int fillZero(char *buf,int size,int fill)
{
	memcpyBack(buf+fill,buf,size);
	memset(buf,'0',fill);

	return fill;
}


/*
 * ե
 * parameters : buffer,size,width,flag
 * return : field size
 */
static void setField(char *buf,int size,int width,int flag,int sign)
{
	int fill;


	fill=width-size-sign;
	if(flag&PFLG_LEFT)memset(buf+size,' ',fill);
	else
	{
		if(flag&PFLG_ZERO)
		{
			memcpyBack(buf+fill,buf,size);
			memset(buf,'0',fill);
		}
		else
		{
			buf-=sign;
			memcpyBack(buf+fill,buf,size+sign);
			memset(buf,' ',fill);
		}
	}
}


/*
 * 10ʿʸѴХåեθƤ
 * parameters : string,buffer,buffer size,flag
 * return : string length
 */
static inline int uToDecimal(uint value,char *buf)
{
	char tmp_buf[TMP_BUF_SIZE];
	int i;


	for(i=TMP_BUF_SIZE-1;;--i)
	{
		tmp_buf[i]=value%10+'0';
		if(!(value/=10))break;
	}
	memcpy(buf,&tmp_buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}


/*
 * 16ʿʸѴ
 * parameters : string,buffer,buffer size,ʸ'X' or 'x'
 * return : string length
 */
static inline int uToHexa(uint value,char *buf,int c)
{
	char tmp_buf[TMP_BUF_SIZE];
	int i;


	c=c-('x'-'a');
	for(i=TMP_BUF_SIZE-1;;--i)
	{
		tmp_buf[i]=value%16+'0';
		if(tmp_buf[i]>'9')tmp_buf[i]+=c-'9'-1;
		if(!(value/=16))break;
	}
	memcpy(buf,&tmp_buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}


/*
 * 8ʿʸѴХåեθƤ
 * parameters : string,buffer
 * return : string length
 */
static inline int uToOctal(uint value,char *buf)
{
	char tmp_buf[TMP_BUF_SIZE];
	int i;


	for(i=TMP_BUF_SIZE-1;;--i)
	{
		tmp_buf[i]=value%8+'0';
		if(!(value/=8))break;
	}
	memcpy(buf,&tmp_buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}


/*
 * PRIVATE
 * ưfʸѴ롣
 * parameters : ư,̳ǼʸХåե,,ե饰,gե饰
 * return : Ѵʸ
 */
static int dtof(double value,char *buf,int prec,int flag,int gflag)
{
	enum{ALL_DIGIT=16};

	char tmp[ALL_DIGIT+1];
	int exp,small;
	int size;
	unsigned long long lvalue;
	int i,last;


	if(gflag)
	{
		/* 10Ȥؿͤ׻ */
		if(value<1)
		{
			exp=0;
			while((value*=10)<1)--exp;
		}
		else
		{
			exp=1;
			while(value>10)
			{
				value/=10;
				++exp;
			}
		}

		lvalue=value*1000000000*1000000;

		/* ٤Ĵ */
		if(prec==0)prec=1;
		for(i=ALL_DIGIT-1;i>prec;--i)lvalue/=10;
		lvalue+=5;		/* ͼθ */
		lvalue/=10;

		/* Ĵ */
		if(exp>prec)
		{
			for(i=exp-prec;i>0;--i)lvalue*=10;
			small=0;
		}
		else
		{
			small=prec-exp;

			/* ʲ0ڤΤơ */
			if((flag&PFLG_FORM)==0)
				for(i=0,last=small;i<last;++i)
				{
					if(lvalue%10==0)
					{
						lvalue/=10;
						--small;
					}
					else break;
				}
		}
	}
	else
	{
		small=prec;			/* =١ */

		/* ޤѴ */
		for(i=0;i<small;++i)value*=10;
		value+=0.5;					/* ͼθ */
		lvalue=value;
	}

	/*
	 * 10ʸѴ
	 */
	for(i=ALL_DIGIT,last=ALL_DIGIT-small-1;i>last;--i)
	{
		tmp[i]=lvalue%10+'0';
		lvalue/=10;
	}
	for(;lvalue!=0;--i)
	{
		tmp[i]=lvalue%10+'0';
		lvalue/=10;
	}
	++i;

	/* νߡ */
	size=ALL_DIGIT-i-small+1;
	memcpy(buf,&tmp[i],size);

	/* νߡ */
	if(small>0)
	{
		buf[size]='.';
		memcpy(&buf[size+1],&tmp[i+size],small);
		size+=small+1;
	}

	return size;
}


/*
 * PRIVATE
 * ưeʸѴ롣
 * parameters : ư,̳ǼʸХåե,,eʸ,gѴե饰
 * return : Ѵʸ
 */
static int dtoe(double value,char *buf,int prec,int c,int flag,int gflag)
{
	enum{ALL_DIGIT=16};

	int exp,sign;
	int digit;
	unsigned long long lvalue;
	double dtmp;
	int i;


	/* 10Ȥؿͤ׻ */
	if(value<1)
	{
		sign='-';
		exp=1;
		while((value*=10)<1)++exp;
	}
	else
	{
		sign='+';
		exp=0;
		while(value>10)
		{
			value/=10;
			++exp;
		}
	}

	/* ٤Ĵ */
	if(gflag)
	{
		if(prec==0)prec=1;
		dtmp=1;
		for(i=1;i<prec;++i)dtmp*=10;
		value*=dtmp;
		value+=0.5;		/* ͼθ */
		lvalue=value;
		digit=prec;

		/* 0ڤΤơ */
		if((flag&PFLG_FORM)==0)
			while((lvalue%10)==0)
			{
				lvalue/=10;
				--digit;
			}
	}
	else
	{
		dtmp=1;
		for(i=1;i<prec;++i)dtmp*=10;
		dtmp*=10;
		value*=dtmp;
		value+=0.5;		/* ͼθ */
		lvalue=value;
		digit=prec+1;
	}

	/* 10ʸѴ */
	if(digit>1)
	{
		for(i=digit;i>1;--i)
		{
			buf[i]=lvalue%10+'0';
			lvalue/=10;
		}
		buf[1]='.';
		i=digit+1;
	}
	else i=digit;
	*buf=lvalue+'0';
	buf[i++]=c;
	buf[i++]=sign;
	buf[i++]=exp/10+'0';
	buf[i++]=exp%10+'0';

	return i;
}


/*
 * ʸѴƥХåե¸롣
 * return : converted string size
 */
static int formatToString(const char *str,char *buf,uint *org_arg)
{
	enum{
		/* Ĺե饰 */
		LENG_H=1,
		LENG_L,
		LENG_DL,
	};

	int flag,width,prec,leng;
	int ivalue,size,sign;
	uint *arg;
	uint uvalue;
	double dvalue;
	double dprec;
	int i,j;


	arg=org_arg;

	for(i=0;*str!='\0';++str)
	{
		if(*str=='%')
		{
			flag=width=leng=0;
			prec=-1;

			/* ե饰ʸ */
			for(;;)
				switch(*++str)
				{
					case '#':
						flag|=PFLG_FORM;
						break;
					case '0':
						flag|=PFLG_ZERO;
						break;
					case '-':
						flag|=PFLG_LEFT;
						flag&=~PFLG_ZERO;
						break;
					case ' ':
						flag|=PFLG_SPACE;
						break;
					case '+':
						flag|=PFLG_PLUS;
						flag&=~PFLG_SPACE;
						break;
					default:
						goto EXIT_FLAG;
				}
EXIT_FLAG:
			/* ե */
			for(;isdigit(*str);++str)
			{
				width*=10;
				width+=*str-'0';
			}

			/* ١ */
			if(*str=='.')
			{
				if(isdigit(*(str+1)))
				{
					++str;
					prec=0;
					do
					{
						prec*=10;
						prec+=*str-'0';
					}while(isdigit(*++str));
				}
				else if(*(str+1)=='*')
				{
					int l;
					const char *s;

					s=(str+=2);
					if(isdigit(*s))
					{
						l=0;
						do
						{
							l*=10;
							l+=*s-'0';
						}while(isdigit(*++s));
						if(*s=='$')
						{
							prec=*(org_arg+l-1);
							str=s+1;
						}
						else prec=*arg++;
					}
					else prec=*arg++;
				}
			}

			/* Ĺʸ */
			switch(*str)
			{
				case 'h':
					leng=LENG_H;
					++str;
					break;
				case 'l':
				case 'L':
					/* ʤˤ⤷ʤ */
					++str;
			}

			/* Ѵʸ */
			switch(*str)
			{
				case 'd':
				case 'i':
					/* Ĺ */
					if(leng==LENG_H)(short)ivalue=*arg++;
					else ivalue=*arg++;

					/* ν */
					sign=1;
					if(ivalue<0)
					{
						buf[i++]='-';
						ivalue*=-1;
					}
					else if(flag&PFLG_PLUS)buf[i++]='+';
					else if(flag&PFLG_SPACE)buf[i++]=' ';
					else sign=0;
					size=uToDecimal(ivalue,&buf[i]);

					/* ٤ν */
					if(prec>0)
					{
						flag&=~PFLG_ZERO;	/* 0ե饰٤ͥ衣 */
						if(prec>size)
							size+=fillZero(&buf[i],size,prec-size);
					}

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 'x':
				case 'X':
					/* Ĺ */
					if(leng==LENG_H)(ushort)uvalue=*arg++;
					else uvalue=*arg++;

					/*  */
					if(flag&PFLG_FORM)
					{
						buf[i++]='0';
						buf[i++]=*str;
						sign=2;
					}
					else sign=0;
					size=uToHexa(uvalue,&buf[i],*str);

					/* ٤ν */
					if(prec>0)
					{
						flag&=~PFLG_ZERO;
						if(prec>size)
							size+=fillZero(&buf[i],size,prec-size);
					}

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 's':
					if(prec>=0)size=prec;
					else size=strlen((char*)*arg);
					memcpy(&buf[i],(void*)*arg,size);
					++arg;
					if((width>size)&&(flag&PFLG_LEFT))
					{
						memset(&buf[i+size],' ',width-size);
						i+=width;
					}
					i+=size;
					break;
				case 'c':
					buf[i]=*arg++;
					if(width>1)
					{
						flag&=~PFLG_ZERO;
						setField(&buf[i],1,width,flag,0);
						i+=width;
					}
					else i+=1;
					break;
				case 'u':
					/* Ĺ */
					if(leng==LENG_H)(ushort)uvalue=*arg++;

					size=uToDecimal(*arg++,&buf[i]);

					/* ٤ν */
					if(prec>0)
					{
						flag&=~PFLG_ZERO;
						if(prec>size)
							size+=fillZero(&buf[i],size,prec-size);
					}

					/* եν */
					if(width>size)
					{
						setField(&buf[i],size,width,flag,0);
						i+=width;
					}
					else i+=size;
					break;
				case 'o':
					/* Ĺ */
					if(leng==LENG_H)(ushort)uvalue=*arg++;

					/*  */
					if(flag&PFLG_FORM)
					{
						buf[i++]='0';
						sign=1;
					}
					else sign=0;
					size=uToOctal(*arg++,&buf[i]);

					/* ٤ν */
					if(prec>0)
					{
						flag&=~PFLG_ZERO;
						if(prec>size)
							size+=fillZero(&buf[i],size,prec-size);
					}

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 'p':
					uvalue=*arg++;

					/*  */
					buf[i++]='0';
					buf[i++]='x';
					sign=2;

					size=uToHexa(uvalue,&buf[i],'x');

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 'f':
					dvalue=*(double*)arg;
					arg+=2;

					/* ν */
					sign=1;
					if(dvalue<0)
					{
						buf[i++]='-';
						dvalue*=-1;
					}
					else if(flag&PFLG_PLUS)buf[i++]='+';
					else if(flag&PFLG_SPACE)buf[i++]=' ';
					else sign=0;

					/* ٤ν */
					if(prec==-1)prec=6;

					size=dtof(dvalue,&buf[i],prec,flag,0);

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 'e':
				case 'E':
					dvalue=*(double*)arg;
					arg+=2;

					/* ν */
					sign=1;
					if(dvalue<0)
					{
						buf[i++]='-';
						dvalue*=-1;
					}
					else if(flag&PFLG_PLUS)buf[i++]='+';
					else if(flag&PFLG_SPACE)buf[i++]=' ';
					else sign=0;

					/* ٤ν */
					if(prec==-1)prec=6;

					size=dtoe(dvalue,&buf[i],prec,*str,flag,0);

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 'g':
				case 'G':
					dvalue=*(double*)arg;
					arg+=2;

					/* ν */
					sign=1;
					if(dvalue<0)
					{
						buf[i++]='-';
						dvalue*=-1;
					}
					else if(flag&PFLG_PLUS)buf[i++]='+';
					else if(flag&PFLG_SPACE)buf[i++]=' ';
					else sign=0;

					/* ٤ν */
					if(prec==-1)prec=6;
					dprec=1;

					for(j=0;j<prec;++j)dprec*=10;
					if((dvalue>=dprec)||(dvalue<0.0001))
						size=dtoe(dvalue,&buf[i],prec,*str-'G'+'E',flag,1);
					else
						size=dtof(dvalue,&buf[i],prec,flag,1);

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 'n':
					*(int*)*arg++=i;
					break;
				case '%':
					buf[i++]='%';
					break;
				default:
					buf[i++]=*str;
			}
		}
		else buf[i++]=*str;
	}

	buf[i]='\0';

	return i;
}


/***************************************************************************
 *
 * ʸ󤫤Ѵ
 *
 ***************************************************************************/

enum{
	/* Flag. */
	SFLG_DETER=1<<0,
	SFLG_H=    1<<1,
	SFLG_L=    1<<2,
	SFLG_LL=   1<<3,
};


/*
 * 8ʸ
 */
static inline int isoctal(int c)
{
	return (c>='0')&&(c<='7');
}

/*
 * 10ʸ󤫤Ѵ
 * parameters : string,buffer,field width,flag
 * return : ɹߥ 0ʤ饨顼
 */
static inline int aToInt(const char *str,int *value,uint width,int flag)
{
	int sign;
	int rest;
	uint i;


	i=0;

	/* γǧ */
	sign=1;
	if(str[i]=='+')
	{
		if(++i>=width)return 0;
	}
	else if(str[i]=='-')
	{
		sign=-1;
		if(++i>=width)return 0;
	}

	if(isdigit(str[i]))
	{
		rest=0;
		while(isdigit(str[i]))
		{
			rest*=10;
			rest+=str[i]-'0';
			if(++i>=width)break;
		}
		if(flag&SFLG_H)
			(short)*value=rest*sign;
		else *value=rest*sign;
	}
	else return 0;

	return i;
}


/*
 * 16ʸ󤫤Ѵ
 * parameters : string,buffer,field width,flag
 * return : ɹߥ 0ʤ饨顼
 */
static inline int hexToUint(const char *str,uint *value,uint width,int flag)
{
	uint rest;
	int sign;
	uint i;


	i=0;
	sign=1;
	if(str[i]=='+')++i;
	else if(str[i]=='-')
	{
		++i;
		sign=-1;
	}
	else if((str[i]=='0')&&((str[i+1]=='x')||(str[i]=='X')))i+=2;

	if(i>=width)return 0;

	if(isxdigit(str[i]))
	{
		rest=0;
		while(isxdigit(str[i]))
		{
			rest*=16;
			if(str[i]<='9')rest+=str[i]-'0';
			else if(str[i]<='F')rest+=str[i]-'A'+10;
			else rest+=str[i]-'a'+10;

			if(++i>=width)break;
		}
		if(flag&SFLG_H)
			(short)*value=rest*sign;
		else *value=rest*sign;
	}
	else return 0;

	return i;
}


/*
 * 8ʸ󤫤Ѵ
 * parameters : string,buffer,field width,flag
 * return : ɹߥ 0ʤ饨顼
 */
static inline int octToUint(const char *str,uint *value,uint width,int flag)
{
	uint rest;
	uint i;


	i=0;
	if(isoctal(str[i]))
	{
		rest=0;
		while(isoctal(str[i]))
		{
			rest*=8;
			rest+=str[i]-'0';

			if(++i>=width)break;
		}
		if(flag&SFLG_H)
			(short)*value=rest;
		else *value=rest;
	}
	else return 0;

	return i;
}


/*
 * ʸʬ롣
 * parameters : string,buffer,size
 * return : ɹߥ
 */
static inline int charToBuf(const char *str,char *c,int size)
{
	int i;


	for(i=0;i<size;++i)c[i]=str[i];

	return size;
}

/* ɤߡ */
static inline int charToBufDummy(const char *str,int size)
{
	int i;


	for(i=0;i<size;++i);

	return size;
}


/*
 * ưѴ롣
 * parameters : string,buffer,field width,
 * return : ɹߥ 0ʤ饨顼
 */
static int fTofloat(const char *str,float *value,uint width)
{
	int sign;
	float rest,denom,nume;
	uint i;


	i=0;

	/* γǧ */
	sign=1;
	if(str[i]=='+')++i;
	else if(str[i]=='-')
	{
		sign=-1;
		++i;
	}

	if(i>=width)return 0;

	if(isdigit(str[i]))
	{
		rest=0;
		while(isdigit(str[i]))
		{
			rest*=10;
			rest+=str[i]-'0';

			if(++i>=width)
			{
				/* η׻ */
				*value=rest*sign;
				return i;
			}
		}

		/* η׻ */
		if(str[i]=='.')
		{
			denom=1;	/* ʬ */
			nume=0;		/* ʬ */
			for(++i;isdigit(str[i]);++i)
			{
				nume*=10;
				nume+=str[i]-'0';
				denom*=10;
			}
			rest+=nume/denom;
		}

		/* η׻ */
		*value=rest*sign;

		return i;
	}
	else return 0;
}


/*
 * ʸϡ
 * parameters : string,buffer
 * return : ɹߥ 0ʤ饨顼
 */
static inline int stringToBuffer(const char *str,char *buf,uint width)
{
	uint i;


	for(i=0;i<width;++i)
	{
		if(isspace(str[i]))break;
		buf[i]=str[i];
	}
	buf[i]='\0';

	return i;
}

/* ʸɤߡ */
static inline int stringToBufferDummy(const char *str,uint width)
{
	uint i;


	for(i=0;i<width;++i)
		if(isspace(str[i]))break;

	return i;
}


/*
 * ʸ󤫤ѴưΥݥ󥿤롣
 * return : converte count
 */
static int formatFromString(const char *str_org,const char *fmt,uint **arg)
{
	const char *str=str_org;
	int count,flag,width;
	int len,wflg;
	int dummy[2];


	count=0;
	for(;*fmt!='0';++fmt)
	{
		if(*fmt=='%')
		{
			/* ե饰γǧ */
			flag=0;
			width=-1;
			wflg=0;
			for(++fmt;;++fmt)
			{
				if(*fmt=='*')flag|=SFLG_DETER;
				else if(*fmt=='h')flag|=SFLG_H;
				else if(*fmt=='l')flag|=SFLG_L;
				else if(*fmt=='L')flag|=SFLG_LL;
				else if(isdigit(*fmt))
				{
					/* ե */
					if(wflg==0)
					{
						width=0;
						do
						{
							width*=10;
							width+=*fmt-'0';
						}while(isdigit(*++fmt));
						if(width==0)width=-1;
						wflg=1;
					}
					else width=-1;		/* 2ܰʹߤϥǥե͡ */
					--fmt;
				}
				else break;
			}

			/* Ѵʸ */
			switch(*fmt)
			{
				case 'i':
					if(*str=='0')
						switch(*(str+1))
						{
							case 'x':
							case 'X':
								goto HEXA;
							default:
								goto OCTAL;
						}
					/* through. */
				case 'd':
				case 'u':
					if(flag&SFLG_DETER)
					{
						if((len=aToInt(str,dummy,width,flag))==0)return count;
					}
					else
					{
						if((len=aToInt(str,(int*)*arg++,width,flag))==0)return count;
						++count;
					}
					str+=len;
					break;
				case 'x':
				case 'X':
				case 'p':
HEXA:				if(flag&SFLG_DETER)
					{
						if((len=hexToUint(str,dummy,width,flag))==0)return count;
					}
					else
					{
						if((len=hexToUint(str,*arg++,width,flag))==0)return count;
						++count;
					}
					str+=len;
					break;
				case 'o':
OCTAL:				if(flag&SFLG_DETER)
					{
						if((len=octToUint(str,dummy,width,flag))==0)return count;
					}
					else
					{
						if((len=octToUint(str,*arg++,width,flag))==0)return count;
						++count;
					}
					str+=len;
					break;
				case 'f':
				case 'e':
				case 'g':
					if(flag&SFLG_DETER)
					{
						if((len=fTofloat(str,(float*)dummy,width))==0)return count;
					}
					else
					{
						if((len=fTofloat(str,(float*)*arg++,width))==0)return count;
						++count;
					}
					str+=len;
					break;
				case 's':
					if(flag&SFLG_DETER)
					{
						len=stringToBufferDummy(str,width);
					}
					else
					{
						len=stringToBuffer(str,(char*)*arg++,width);
						++count;
					}
					str+=len;
					break;
				case 'c':
					if(flag&SFLG_DETER)
					{
						len=charToBufDummy(str,(width==-1)?1:width);
					}
					else
					{
						len=charToBuf(str,(char*)*arg++,(width==-1)?1:width);
						++count;
					}
					str+=len;
					break;
				case 'n':
					if((flag&SFLG_DETER)==0)
						*(int*)*arg++=str-str_org;
					break;
				case '%':
					if(*str++!='%')return count;
			}
		}
		else if(*fmt!=*str++)break;
	}

	return count;
}


/***************************************************************************
 *
 * ե륹ȥ꡼
 *
 ***************************************************************************/

enum{
	F_FLAG_EOF=1<<0,	/* File sterm EOF flag. */
	F_FLAG_ERR=1<<1,	/* File sterm error flag. */
};


FILE _stdin= {0,0,0,0,NULL};
FILE _stdout={1,0,0,0,NULL};
FILE _stderr={2,0,0,0,NULL};
FILE *stdin	=&_stdin;
FILE *stdout=&_stdout;
FILE *strerr=&_stderr;


/*
 * Get file descriptor flag from mode.
 * parameters : mode,access flag buf,open flag buf
 */
static int getFdFlag(const char* mode,int *aflg,int *oflg)
{
	switch(*mode)
	{
		case 'r':
			*aflg=O_RDONLY;
			*oflg=0;
			break;
		case 'w':
			*aflg=O_WRONLY;
			*oflg=O_CREAT|O_TRUNC;
			break;
		case 'a':
			*aflg=O_WRONLY;
			*oflg=O_CREAT|O_APPEND;
			break;
		default:
			errno = EINVAL;
			return -1;
	}
	if ((*++mode=='+')||((*mode=='b')&&(mode[1]=='+')))*aflg=O_RDWR;

	return 0;
}


FILE *fopen(const char *filename,const char* mode)
{
	int fd;
	int aflg,oflg;
	FILE *fl;


	if(getFdFlag(mode,&aflg,&oflg)==-1)return NULL;
	if((fd=open(filename,aflg|oflg,S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH))<0)
		return NULL;

	/* Set FILE structure. */
	if((fl=malloc(sizeof(FILE)))==NULL)return NULL;
	fl->fd=fd;
	fl->bufMode=_IONBF;
	fl->size=0;
	fl->buf=NULL;

	return fl;
}


FILE *fdopen(int fildes, const char *mode)
{
	int aflg,oflg;
	FILE *fl;


	if(getFdFlag(mode,&aflg,&oflg)==-1)return NULL;
	if(fcntl(fildes,F_SETFL,aflg)==-1)return NULL;

	/* Set FILE structure. */
	if((fl=malloc(sizeof(FILE)))==NULL)return NULL;
	fl->fd=fildes;
	fl->bufMode=_IONBF;
	fl->size=0;
	fl->buf=NULL;

	return fl;
}


int fclose(FILE *stream)
{
	int rest;


	if(stream==NULL)
	{
		errno=EBADF;
		return -1;
	}
	rest=close(stream->fd);
	free(stream->buf);
	free(stream);

	if(rest<0)return EOF;
	else return 0;
}


FILE *freopen(const char *path, const char *mode, FILE *stream)
{
	int aflg,oflg;


	/* Close stream. */
	if(stream==NULL)
	{
		errno=EBADF;
		return NULL;
	}
	close(stream->fd);

	/* File open. */
	if(getFdFlag(mode,&aflg,&oflg)==-1)return NULL;
	if((stream->fd=open(path,aflg|oflg,S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH))<0)
		return NULL;

	stream->bufMode=_IONBF;
	stream->size=0;
	stream->buf=NULL;

	return stream;
}


void clearerr(FILE *stream)
{
	stream->flag&=~(F_FLAG_EOF|F_FLAG_ERR);
}


int feof(FILE *stream)
{
	if(stream->flag&F_FLAG_EOF)return 1;
	return 0;
}


int ferror(FILE *stream)
{
	if(stream->flag&F_FLAG_ERR)return 1;
	return 0;
}


int fseek(FILE *stream, long offset, int whence)
{
	if(lseek(stream->fd,offset,whence)<0)return -1;
	stream->flag&=~F_FLAG_EOF;

	return 0;
}


long ftell(FILE *stream)
{
	struct stat stat;


	if(fstat(stream->fd,&stat)==-1)return -1;
	return stat.st_crtpos;
}


void rewind(FILE *stream)
{
	(void)fseek(stream,0,SEEK_SET);
}


int fgetpos(FILE *stream, fpos_t *pos)
{
	fpos_t fp;


	if((fp=ftell(stream))==-1)return -1;
	*pos=fp;

	return 0;
}


int fsetpos(FILE *stream, fpos_t *pos)
{
	if(fseek(stream,*pos,SEEK_SET)==-1)return -1;
	return 0;
}


size_t fread(void* ptr,size_t size,size_t nobj,FILE* stream)
{
	size_t all_size;
	int rest;


	all_size=size*nobj;
	if((rest=read(stream->fd,ptr,all_size))<0)return 0;

	return ROUNDUP(rest,size)/size;
}


size_t fwrite(const void* ptr,size_t size,size_t nobj,FILE* stream)
{
	size_t all_size;
	int rest;


	all_size=size*nobj;
	if((rest=write(stream->fd,ptr,all_size))<0)return 0;

	return nobj;
}


int setvbuf(FILE *stream, char* buf, int mode, size_t size)
{
	switch(mode)
	{
		case _IONBF:
			stream->bufMode=_IONBF;
			stream->size=0;
			stream->buf=NULL;
			break;
		case _IOFBF:
		case _IOLBF:
			stream->bufMode=mode;
			stream->size=size;
			if(buf!=NULL)stream->buf=NULL;
			else if((buf=malloc(size))==NULL)return -1;
			break;
		default:
			errno=EINVAL;
			return -1;
	}

	return 0;
}


void setbuf(FILE* stream, char* buf)
{
	if(buf==NULL)setvbuf(stream,NULL,_IONBF,0);
	else setvbuf(stream,buf,_IOFBF,BUFSIZ);
}


int fgetc(FILE *stream)
{
	uchar c;


	switch(read(stream->fd,&c,1))
	{
		case 1:return c;
		case 0:
			stream->flag|=F_FLAG_EOF;
			return EOF;
		default:
			stream->flag|=F_FLAG_ERR;
			return EOF;
	}

}


int getc(FILE *stream)
{
	return fgetc(stream);
}


int getchar(void)
{
	return fgetc(stdin);
}


char *fgets(char *s, int size, FILE *stream)
{
	int rest;
	int i;


	if(size<=0)return s;

	if((rest=read(stream->fd,s,size-1))<0)
	{
		stream->flag|=F_FLAG_ERR;
		return NULL;
	}
	s[rest]='\0';
	for(i=0;s[i]!='\n';++i)
		if(s[i]=='\0')
		{
			if(rest<size-1)
			{
				stream->flag|=F_FLAG_EOF;
				return NULL;
			}
			else return s;
		}
	s[i+1]='\0';

	/* ե륪եåȤԤμޤᤷƤ */
	lseek(stream->fd,rest-size+1,SEEK_CUR);

	return s;
}


char *gets(char *s)
{
	enum{READ_SIZE=512};

	char *p;
	int rest;
	int i;


	for(p=s;(rest=read(stdin->fd,p,READ_SIZE))==READ_SIZE;p+=READ_SIZE)
	{
		/* Ԥõ */
		for(i=0;i<READ_SIZE;++i)
			if(p[i]=='\n')
			{
				p[i]='\0';
				lseek(stdin->fd,i-READ_SIZE+1,SEEK_CUR);
				return s;
			}
	}


	if(rest<0)		/* ɹߥ顼 */
	{
		stdin->flag|=F_FLAG_ERR;
		return NULL;
	}
	else			/* EOF. */
	{
		p[rest]='\0';
		stdin->flag|=F_FLAG_EOF;
				return NULL;
	}
}


int fputc(int c, FILE *stream)
{
	uchar wc;


	wc=c;
	if(write(stream->fd,&wc,1)!=1)
	{
		stream->flag|=F_FLAG_EOF;
		return EOF;
	}
	else return (int)wc;
}


int putc(int c, FILE *stream)
{
	return fputc(c,stream);
}


int putchar(int c)
{
	return fputc(c,stdout);
}


int ungetc(int c, FILE *stream)
{
	return fputc(c,stream);
}


int fputs(const char *s, FILE *stream)
{
	int size;


	size=strlen(s);
	if(write(stream->fd,s,size)!=size)
	{
		stream->flag|=F_FLAG_ERR;
		return EOF;
	}
	return 0;
}


int puts(const char *s)
{
	int size;


	size=strlen(s);
	if(write(stdout->fd,s,size)!=size)
	{
		stdout->flag|=F_FLAG_ERR;
		return EOF;
	}
	if(write(stdout->fd,"\n",1)!=1)
	{
		stdout->flag|=F_FLAG_ERR;
		return EOF;
	}
	return 0;
}


int vfprintf(FILE *stream, const char *format, va_list ap)
{
	char buf[1024];
	int size;


	size=formatToString(format,buf,(uint*)ap);
	if(write(stream->fd,buf,size)!=size)
	{
		stream->flag|=F_FLAG_ERR;
		return EOF;
	}
	return size;
}


int vprintf(const char *format, va_list ap)
{
	return vfprintf(stdout,format,ap);
}


int fprintf(FILE *stream, const char *format, ...)
{
	va_list ap;


	va_start(ap,format);
	return vfprintf(stream,format,ap);
}


int printf(const char *format, ...)
{
	va_list ap;


	va_start(ap,format);
	return vfprintf(stdout,format,ap);
}


int vsprintf(char *str, const char *format, va_list ap)
{
	return formatToString(format,str,(uint*)ap);
}


int sprintf(char *str, const char *format, ...)
{
	va_list ap;


	va_start(ap,format);
	return formatToString(format,str,(uint*)ap);
}


int fscanf(FILE* stream, const char* format, ...)
{
	char buf[1024];
	va_list ap;


	if(read(stream->fd,buf,1024)<0)
	{
		stream->flag|=F_FLAG_ERR;
		return EOF;
	}
	va_start(ap,format);
	return formatFromString(buf,format,(uint**)ap);
}


int scanf(const char* format, ...)
{
	char buf[1024];
	va_list ap;


	if(read(stdin->fd,buf,1024)<0)
	{
		stdin->flag|=F_FLAG_ERR;
		return EOF;
	}
	va_start(ap,format);
	return formatFromString(buf,format,(uint**)ap);
}


int sscanf(const char* s, const char* format, ...)
{
	va_list ap;


	va_start(ap,format);
	return formatFromString(s,format,(uint**)ap);
}


int fflush(FILE *stream)
{
	sync();
	return 0;
}


/***************************************************************************
 *
 * ¾
 *
 ***************************************************************************/

int rename(const char *old, const char *new)
{
	int rest;


	if((rest=syscall3(SYS_RENAME,(int)old,(int)new))<0)
	{
		errno=-rest;
		return -1;
	}

	return 0;
}


void perror(const char *s)
{
	char *error;


	if((error=strerror(errno))==NULL)return;
	fprintf(stdout,"%s : %s\n",s,error);
}


int remove(const char *pathname)
{
	struct stat state;


	if(stat(pathname,&state)<0)return -1;

	if(S_ISREG(state.st_mode))
		return unlink(pathname);
	if(S_ISDIR(state.st_mode))
		return rmdir(pathname);

	errno=ENOENT;
	return -1;
}


char *ctermid(char *s)
{
	char *buf;


	if((buf=ttyname(STDIN_FILENO))==NULL)return s;
	if(s!=NULL)
	{
		memcpy(s,buf,strlen(buf));
		return s;
	}
	else return buf;
}


char *tmpnam(char s[L_tmpnam])
{
	/* ƥץեѥե̾κ */
	sprintf(s,"%x%x",getuid(),clock());
	return s;
}


FILE *tmpfile (void)
{
	char path[L_tmpnam];
	char *name;
	int fd;
	FILE *fl;


	name=tmpnam(path);

	if((fd=open(name,O_CREAT|O_EXCL|O_RDWR|O_DEL,S_IRUSR|S_IWUSR))<0)
		return NULL;

	/* Set FILE structure. */
	if((fl=malloc(sizeof(FILE)))==NULL)return NULL;
	fl->fd=fd;
	fl->bufMode=_IONBF;
	fl->size=0;
	fl->buf=NULL;

	return fl;
}
