/*
 * share/signal.h
 */


#ifndef share_signal_h
#define share_signal_h


#ifndef ASM_FILE


typedef void(*SIG_ACTION)(int);


/* signal actions. */
#define SIG_DFL (SIG_ACTION)1	/* default action. */
#define SIG_IGN (SIG_ACTION)2	/* ignore. */
#define	SIG_ERR (SIG_ACTION)-1	/* Return value from signal() in case of error. */


enum{
	/*
	 * signals.
	 * default actions.
	 *  A=abnormal termination,T=termination,C=continue process,S=stop process,I=ignore the signal
	 */
	SIGABRT=1,	/* A	ܡȡ */
	SIGALRM,	/* T	顼ࡦå */
	SIGBUS,		/* A	Х顼ʥɥ쥹顼ˡ */
	SIGCHLD,	/* I	ҥץξѲ */
	SIGCONT,	/* C	ߥץμ¹Է³ʥץ򵯤) */
	SIGFPE,		/* A	㳰 */
	SIGHUP,		/* T	ϥ󥰥åס */
	SIGILL,		/* A	̿ᡣ */
	SIGINT,		/* T	󥿥ץȡctl+cˡ */
	SIGKILL,	/* T	ץζλ(̵Բ) */
	SIGPIPE,	/* T	ɤ߼Τʤѥפؤν񤭹ߡ */
	SIGPOLL,	/* T	ݡ󥰲ǽ٥Ȥȯ */
	SIGPROF,	/* T	ץե󥰡ޡλĶᡣ */
	SIGQUIT,	/* A	λ */
	SIGSEGV,	/* A	ơȿɥ쥹ȡ */
	SIGSTOP,	/* S	ץߡª̵Բǽˡ */
	SIGSYS,		/* A	ƥࡦ롣 */
	SIGTERM,	/* T	ץνλ */
	SIGTRAP,	/* A	ȥ졼⤷ϥ֥졼ݥȤ˴Ťȥåס */
	SIGTSTP,	/* S	ץߡCtrl-zʤɤΥˡ */
	SIGTTIN,	/* S	ϻΥץߡ */
	SIGTTOU,	/* S	ϻΥץߡ */
	SIGURG,		/* I	åȶ۵޾֡ */
	SIGUSR1,	/* T	桼ʥ뭡 */
	SIGUSR2,	/* T	桼ʥ뭢 */
	SIGVTALRM,	/* T	ۥޡλĶᡣ */
	SIGXCPU,	/* A	CPU¤Ķᡣ */
	SIGXFSZ,	/* A	ե롦¤Ķᡣ */

	/* ʥ륢 */
	SIG_ACTIONS=SIGXFSZ+1,

	SA_ONSTACK=1,	/* Causes signal delivery to occur on an alternate stack. */
	SA_RESTART=2,	/* Restart system on signal return. */
	SA_DISABLE=4,	/* Disable taking signals on alternate stack. */	

	SIG_BLOCK=1,	/* The resulting set is the union of the current set and the signal set pointed to by the argument set. */
	SIG_UNBLOCK,	/* The resulting set is the intersection of the current set and the complement of the signal set pointed to by the argument set. */
	SIG_SETMASK,	/* The resulting set is the signal set pointed to by the argument set. */

	/* sig_pending()ѥե饰 */
	SIG_PENDING_SOTORE=0,
	SIG_PENDING_SET,
};


typedef unsigned int sigset_t;


struct sigaction{
	void (*sa_handler)(int);	/* What to do on receipt of signal. */
	sigset_t sa_mask;			/* Set of signals to be blocked during execution of the signal handling function. */
	int      sa_flags;			/* Special flags. */
};


#endif


#endif
