/*
 * in.h
 */


#ifndef share_in_h
#define share_in_h


#include<share/stdint.h>
#include<share/socket.h>


#ifndef ASM_FILE


enum{
	IPPROTO_IP,			/* Internet protocol. */
	IPPROTO_IPV6,		/* Internet Protocol Version 6. */
	IPPROTO_ICMP=1,		/* Control message protocol. */
	IPPROTO_IGMP=2,
	IPPROTO_RAW,		/* Raw IP Packets Protocol. */
	IPPROTO_TCP=6,		/* Transmission control protocol. */
	IPPROTO_UDP=17,		/* User datagram protocol. */

	INADDR_ANY=      0,				/* IPv4 local host address. */
	INADDR_BROADCAST=0xffffffff,	/* IPv4 broadcast address. */
};


typedef uint16_t in_port_t;
typedef uint32_t in_addr_t;

struct in_addr{
	in_addr_t s_addr;
};

struct sockaddr_in{
	sa_family_t    sin_family;	/* AF_INET. */
	in_port_t      sin_port;	/* Port number. */
	struct in_addr sin_addr;	/* IP address. */
};


#endif


#endif
