/*
 * interrupt.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * interrupt.S interrupt.c ѥإåե
 */


#ifndef interrupt_h
#define interrupt_h


#include<types.h>
#include<proc.h>
#include<share/syscall.h>


/* IRQȥ꡼ơ֥ */
#define IRQ0			0
#define IRQ1			1
#define IRQ3			3
#define IRQ4			4
#define IRQ5			5
#define IRQ6			6
#define IRQ7			7
#define IRQ8			8
#define IRQ9			9
#define IRQ10			10
#define IRQ11			11
#define IRQ12			12
#define IRQ13			13
#define IRQ14			14
#define IRQ15			15
#define FLASH_PAGEDIR	16
#define APIC_TIMER		17


#define FPU_SAVE_SIZE 108	/* FPU֥Хȥ */


#ifndef ASM_FILE


enum{
	IRQ_ENTRY=APIC_TIMER+1,	/* IRQϥɥ饨ȥ꡼ */

	/* IDT flag */
	IDT_INTR=0xe00,		/* Intrrupt gate */
	IDT_TRAP=0xf00,		/* Trap gate */
};


typedef int (*SYSCALL)();


/*
 * Interrupt stack frame
 */
typedef struct{
/*	uint gs;
	uint fs;*/
	char fpu[FPU_SAVE_SIZE];
	uint ds;
	uint es;
	uint edi;
	uint esi;
	uint ebp;
	uint esp;
	uint ebx;
	uint edx;
	uint ecx;
	uint eax;
	uint eip;
	uint cs;
	uint eflags;
	uint user_esp;
	uint user_ss;
}TRAP_FRAME;


/*
 * Exception stack frame
 */
typedef struct{
/*	uint gs;
	uint fs;*/
	char fpu[FPU_SAVE_SIZE];
	uint ds;
	uint es;
	uint edi;
	uint esi;
	uint ebp;
	uint esp;
	uint ebx;
	uint edx;
	uint ecx;
	uint eax;
	uint error;
	uint eip;
	uint cs;
	uint eflags;
	uint user_esp;
	uint user_ss;
}EXCEPT_FRAME;

/*
 * temp except frame.
 */
typedef struct{
	int except;
	char fpu[FPU_SAVE_SIZE];
	uint error;
	uint eip;
	uint cs;
	uint eflags;
	uint user_esp;
	uint user_ss;
}TMP_EXCEPT_FRAME;

/*
 * debug frame.
 */
typedef struct{
	char fpu[FPU_SAVE_SIZE];
	uint eip;
	uint cs;
	uint eflags;
	uint user_esp;
	uint user_ss;
}DEBUG_FRAME;


/*
 * System call frame.
 */
typedef struct{
	uint es;
	uint ds;
	uint eip;
	uint cs;
	uint para1;
	uint esp;
	uint ss;
}SYSCALL1_FRAME;

typedef struct{
	uint es;
	uint ds;
	uint eip;
	uint cs;
	uint para1;
	uint para2;
	uint esp;
	uint ss;
}SYSCALL2_FRAME;

typedef struct{
	uint es;
	uint ds;
	uint eip;
	uint cs;
	uint para1;
	uint para2;
	uint para3;
	uint esp;
	uint ss;
}SYSCALL3_FRAME;

typedef struct{
	uint es;
	uint ds;
	uint eip;
	uint cs;
	uint para1;
	uint para2;
	uint para3;
	uint para4;
	uint esp;
	uint ss;
}SYSCALL4_FRAME;


extern void except0();
extern void except1();
extern void except2();
extern void except3();
extern void except4();
extern void except5();
extern void except6();
extern void except7();
extern void except8();
extern void except9();
extern void except10();
extern void except11();
extern void except12();
extern void except13();
extern void except14();
extern void except15();
extern void except16();
extern void except17();
extern void except18();
extern void apictimer();
extern void irq0();
extern void irq1();
extern void irq2();
extern void irq3();
extern void irq4();
extern void irq5();
extern void irq6();
extern void irq7();
extern void irq8();
extern void irq9();
extern void irq10();
extern void irq11();
extern void irq12();
extern void irq13();
extern void irq14();
extern void irq15();
extern void flash_pagedir();
extern int syscall1();
extern int syscall2();
extern int syscall3();
extern int syscall4();
extern int syscall5();
extern int syscall6();
extern int syscall7();
extern int sys_sleep();
extern void wait_task();
extern void returnExit(void*);
extern uint setContext(uint);

extern int (*irq_entry[])();
extern void (*irq_eoi)(uchar);
extern void (*release_irq_mask)(uchar);
extern void (*set_irq_mask)(uchar);

extern int init_syscall();

extern void set_idt(int,void*,int);
extern void set_gate(int,void*,uchar);
extern void doUserHandler(int,void(*)(int),uint,uint*,uint*);
extern void returnUserHandler();


#endif


#endif
