<?php
/**
 * 最近のトラックバック
 * # CExt:Trackbackがインストールされていること
 */
require_once 'Platy/Widget.php';

define(MAX_ENTRY, 5);   // 表示件数

class Platy_Widget_RecentTrackback extends Platy_Widget
{
    public function install() { return true; }
    public function uninstall() { return true; }

    public function getSummary()
    {
        return '最近のトラックバックを表示する';
    }
    
    public function view()
    {
        global $db;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        $a['title'] = '最近のトラックバック';
        
        ob_start();
        $sql = "SELECT id, title, url, blog_name, created FROM Platy_CExt_Trackback ORDER BY created DESC";
        $rows = $db->fetchAll($sql);
        $n = MAX_ENTRY;
        if (count($rows) < MAX_ENTRY) { $n = count($rows); }
        
        echo '<ul>';
        for ($i = 0; $i < $n; $i++) {
            $row = $rows[$i];
            $NodeId = $row['id'];
            $content = getContentFromNodeId($NodeId);
            echo '<li>';
            echo '<a href="' . BASE_URL . $content['url'] . '#trackback">';
            echo $content['title'];
            echo '</a>';
            
            echo '&nbsp;from&nbsp;';
            echo '<a href="' . $row['url'] . '">';
            echo $row['blog_name'] . '-' . $row['title'];
            echo '</a>';
            
            echo '&nbsp;(';
            echo substr($row['created'], 5, 2);
            echo '/';
            echo substr($row['created'], 8, 2);
            echo ')';
            
            echo '</li>' . "\n";
            //var_dump($content);
        }
        echo '</ul>';
        $a['main'] = ob_get_contents();
        ob_end_clean();
        
        return $a;
    }
}
?>