<?php
/**
 * 最近ニュース
 */
require_once 'Platy/Widget.php';

define(MAX_ENTRY, 5);   // 表示件数

class Platy_Widget_RecentNews extends Platy_Widget
{
    public function install() { return true; }
    public function uninstall() { return true; }
    
    public function getSummary()
    {
        return '最新ニュースを表示する';
    }
    
    public function view()
    {
        global $db;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        $a['title'] = '最新ニュース';
        
        ob_start();
        echo '<a href="' . BASE_URL . 'Syndication/RecentNews/">';
        echo '<img src="' . BASE_URL . 'media/system/feed.png" alt="feed" />';
        echo '</a>';
        $a['icons'] = ob_get_contents();
        ob_end_clean();
        
        ob_start();
        $sql = "SELECT id FROM Platy_Content_Base WHERE type = 'News' ORDER BY modified DESC";
        $rows = $db->fetchAll($sql);
        $n = MAX_ENTRY;
        if (count($rows) < MAX_ENTRY) { $n = count($rows); }
        for ($i = 0; $i < $n; $i++) {
            $row = $rows[$i];
            $NodeId = $row['id'];
            $content = getContentFromNodeId($NodeId);
            echo '<a href="' . BASE_URL . $content['url'] . '">';
            echo $content['title'];
            echo '&nbsp;(' . $content['modified'] . ')';
            echo '</a>' . "\n";
            //var_dump($content);
        }
        $a['main'] = ob_get_contents();
        ob_end_clean();
        
        return $a;
    }
}
?>