<?php
/**
 * 最新コメント
 * # CExt:Commentがインストールされていること
 */
require_once 'Platy/Widget.php';

define(MAX_ENTRY, 5);   // 表示件数

class Platy_Widget_RecentComment extends Platy_Widget
{
    public function install() { return true; }
    public function uninstall() { return true; }

    public function getSummary()
    {
        return '最近のコメントを表示する';
    }
    
    public function view()
    {
        global $db;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        $a['title'] = '最近のコメント';
        
        ob_start();
        $sql = "SELECT id, cid, memberId, name, created FROM Platy_CExt_Comment ORDER BY created DESC";
        $rows = $db->fetchAll($sql);
        
        $n = MAX_ENTRY;
        if (count($rows) < MAX_ENTRY) { $n = count($rows); }
        
        echo '<ul>';
        for ($i = 0; $i < $n; $i++) {
            $row = $rows[$i];
            $NodeId = $row['cid'];
            $content = getContentFromNodeId($NodeId);
            echo '<li>';
            echo '<a href="' . BASE_URL . $content['url'] . '#comment">';
            echo $content['title'];
            echo '</a>';
            echo '&nbsp;by&nbsp;';
            if ($row['memberId'] > 0) { echo Platy_Util::getUsername($row['memberId']); }
            else { echo $row['name']; }
            echo '&nbsp;(';
            echo substr($row['created'], 5, 2);
            echo '/';
            echo substr($row['created'], 8, 2);
            echo ')';
            
            echo '</li>' . "\n";
            //var_dump($content);
        }
        echo '</ul>';
        $a['main'] = ob_get_contents();
        ob_end_clean();
        
        return $a;
    }
}
?>