<?php
/**
 * ノード ナビゲージョン(フォルダタイプ)
 * フォルダ階層を表示する
 * Movable Type 4 のカテゴリを参考
 */
require_once 'Platy/Widget.php';

class Platy_Widget_NodeNavFolder extends Platy_Widget
{
    private $show_n;    // フォルダ内のコンテンツ数を表示するか？
    
    function __construct() {
        $this->show_n = true;
    }
    
    public function install() { return true; }
    public function uninstall() { return true; }
    
    public function getSummary()
    {
        return 'フォルダタイプのノードナビゲーション';
    }
    
    public function view()
    {
        global $db;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        $a['title'] = 'NodeNaviFolder';
        
        ob_start();
        
        $parentId = 0;
        $id = parentId;
        
        echo '<a href="' . BASE_URL . '">';
        echo 'HOME';
        if ($this->show_n == true) {
            $sql = "SELECT COUNT(*) FROM Platy_Content_Node n, Platy_Content_Base b WHERE n.id=b.id AND parentId={$id} AND b.type!='Folder'";
            $row = $db->fetchRow($sql);
            echo '(' . $row['COUNT(*)'] . ')';
        }
        echo '</a>';
        echo "<br />\n";

        $path_array = array();
        $id = $parentId;
        $depth = 1;
        $this->getChildFolder($path_array, $id, $depth);
        
        $a['main'] = ob_get_contents();
        ob_end_clean();
        
        return $a;
    }
    
    /**
     * 
     */
    private function getChildFolder(&$path_array, $id, &$depth)
    {
        global $db;
        
        //echo "getChildNode";
        //var_dump($path_array);
        //echo "id=" . $id . ',';
        //echo "depth=" . $depth;
        //echo "<br />\n";
        
        $sql = "SELECT n.id, b.type, b.name, b.title, b.modified, b.status FROM Platy_Content_Node n, Platy_Content_Base b WHERE n.id=b.id AND parentId={$id} AND b.type='Folder' ORDER BY ordering";
        $rows = $db->fetchAll($sql);
        
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            $id = $row['id'];
            $type = $row['type'];
            $name = $row['name'];
            $title = $row['title'];
            $modified = $row['modified'];
            $status = $row['status'];
            
            for ($k = 0; $k < $depth; $k++) { echo '&nbsp;&nbsp;'; }
            
            $path = '';
            foreach ($path_array as $p) { $path .= $p . '/'; }
            echo '<a href="' . BASE_URL . $path . $name . '/">';
            echo $title;
            if ($this->show_n == true) {
                $sql = "SELECT COUNT(*) FROM Platy_Content_Node n, Platy_Content_Base b WHERE n.id=b.id AND parentId={$id} AND b.type!='Folder'";
                $row = $db->fetchRow($sql);
                echo '(' . $row['COUNT(*)'] . ')';
            }
            echo '</a>';
            echo "<br />\n";
            
            $parentId = $id;
            $depth++;
            
            //echo "push<br />\n";
            array_push($path_array, $name);
            $this->getChildFolder($path_array, $parentId, $depth);
        }
        //echo "pop<br />\n";
        $depth--;
        array_pop($path_array);
    }
}
?>