<?php
/**
 * Shop モジュール
 */
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';
require_once 'Platy/Module.php';
require_once 'Platy/SystemDB.php';
require_once 'Platy/Form.php';

class Platy_Module_Shop extends Platy_Module
{
    public function install()
    {
        global $db;
        
        $sql[] = "CREATE TABLE Platy_Shop_Order ("
               . "id                  integer PRIMARY KEY,"
               . "memberId            int DEFAULT 0,"
               . "total               int DEFAULT 0,"
               . "payment             int DEFAULT 0,"
               . "shipping            int DEFAULT 0,"
               . "fullname            varchar(64),"
               . "postcode            char(20),"
               . "country             integer DEFAULT NULL,"
               . "state               varchar(64),"
               . "city                varchar(128),"
               . "street              varchar(128),"
               . "email               varchar(128),"
               . "phone               varchar(20),"
               . "delivery            tinyint(1) DEFAULT 0,"
               . "delivery_fullname   varchar(64) DEFAULT NULL,"
               . "delivery_postcode   char(20) DEFAULT NULL,"
               . "delivery_country    integer DEFAULT NULL,"
               . "delivery_state      varchar(64),"
               . "delivery_city       varchar(128),"
               . "delivery_street     varchar(128),"
               . "delivery_phone      varchar(20) DEFAULT NULL,"
               . "remark              text DEFAULT NULL,"
               . "created             datetime,"
               . "modified            datetime,"
               . "status              int DEFAULT 0,"
               . "payment_status      int DEFAULT 0,"
               . "shipping_status     int DEFAULT 0);";

        $sql[] = "CREATE TABLE Platy_Shop_Order_Product ("
               . "id          integer PRIMARY KEY,"
               . "orderId     int NOT NULL,"
               . "productId   int NOT NULL,"
               . "qty         int NOT NULL,"
               . "price       int DEFAULT 0,"
               . "subtotal    int DEFAULT 0);";
        
        $sql[] = "CREATE TABLE Platy_Shop_Product_Option ("
               . "id          integer PRIMARY KEY,"
               . "name        varchar(64),"
               . "title       varchar(64));";
        
        $sql[] = "CREATE TABLE Platy_Shop_Product_Option_Value ("
               . "id          integer PRIMARY KEY,"
               . "optionId    int NOT NULL,"
               . "title       varchar(64),"
               . "ordering    int,"
               . "prefix      char(1),"
               . "price       int DEFAULT 0);";
        
        $sql[] = "CREATE TABLE Platy_Shop_Product_to_Option ("
               . "id          integer PRIMARY KEY,"
               . "productId   int NOT NULL,"
               . "optionId    int NOT NULL);";
        
        $sql[] = "CREATE TABLE Platy_Shop_Order_Product_Option ("
               . "id                  integer PRIMARY KEY,"
               . "orderId             int NOT NULL,"
               . "itemId              int NOT NULL,"
               . "optionId            int NOT NULL,"
               . "optionValue         int NOT NULL,"
               . "optionTitle         varchar(64),"
               . "optionValueTitle    varchar(64),"
               . "prefix              char(2),"
               . "price               int);";
        
        $sql[] = "CREATE TABLE Platy_Shop_Payment ("
               . "id          integer PRIMARY KEY,"
               . "name        varchar(64),"
               . "title       varchar(64),"
               . "description text,"
               . "ordering    int,"
               . "class       varchar(64),"
               . "status      int DEFAULT 0);";
        
        $sql[] = "CREATE TABLE Platy_Shop_Shipping ("
               . "id              integer PRIMARY KEY,"
               . "name            varchar(64),"
               . "title           varchar(64),"
               . "description     text,"
               . "ordering        int,"
               . "class           varchar(64),"
               . "status          int DEFAULT 0);";
        $sql[] = "CREATE TABLE Platy_Shop_Config ("
               . "name        varchar(255),"
               . "value       text);";
        //$sql[] = "CREATE TABLE Platy_Shop_Address ("
        //       . ""
        //       . "";
        $sql[] = "INSERT INTO Platy_Shop_Payment(id, name, title, ordering) VALUES(1,'cod','代金引替',1)";
        $sql[] = "INSERT INTO Platy_Shop_Payment(id, name, title, ordering) VALUES(2,'bank','銀行振込',2)";
        $sql[] = "INSERT INTO Platy_Shop_Payment(id, name, title, ordering) VALUES(3,'post','郵便振替',3)";
        $sql[] = "INSERT INTO Platy_Shop_Payment(id, name, title, ordering) VALUES(4,'card','クレジットカード',4)";
        $sql[] = "INSERT INTO Platy_Shop_Shipping(id, name, title, ordering) VALUES(1,'flat','送料一律',1)";
        
        $sql[] = "INSERT INTO Platy_Shop_Shipping(id, name, title, ordering) VALUES(2,'sagawa','佐川急便',2)";
        $sql[] = "INSERT INTO Platy_Shop_Shipping(id, name, title, ordering) VALUES(3,'yamato','ヤマト運輸 宅急便',3)";
        $sql[] = "INSERT INTO Platy_Shop_Shipping(id, name, title, ordering) VALUES(4,'nittsu','日本通運 ペリカン便',4)";
        
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_SHOPNAME','店舗名')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_COMPANY','販売業者')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_DAIHYOU','運営責任者')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_ADDRESS','住所')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_PHONE','電話番号')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_FAX','FAX番号')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_EMAIL','メールアドレス')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_URL','URL')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_PAYMENT','支払方法')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_HIKIWATASHI','引渡時期')";
        $sql[] = "INSERT INTO Platy_Shop_Config(name, value) VALUES('M_SHOP_HENPIN','返品・交換について')";
        
        $db->beginTransaction();
        
        try {
            for ($i = 0; $i < count($sql); $i++) {
                $db->query($sql[$i]);
            }
        }
        catch (Exception $e) {
            $db->rollBack();
            //echo $e->getMessage();
            return false;
        }
        
        $db->commit();
        
        // メニューアイテム追加
        $item = array('bar'=>'global', 'type'=>'module', 'title'=>'ショップ', 'module_name'=>'Shop', 'module_param' => '');
        addToMenu($item);
        
        return true;
    }
    
    public function uninstall()
    {
        global $db;
        
        $sql[] = "DROP TABLE Platy_Shop_Order";
        $sql[] = "DROP TABLE Platy_Shop_Order_Product";
        $sql[] = "DROP TABLE Platy_Shop_Product_Option";
        $sql[] = "DROP TABLE Platy_Shop_Product_Option_Value";
        $sql[] = "DROP TABLE Platy_Shop_Product_to_Option";
        $sql[] = "DROP TABLE Platy_Shop_Order_Product_Option";
        $sql[] = "DROP TABLE Platy_Shop_Payment";
        $sql[] = "DROP TABLE Platy_Shop_Shipping";
        $sql[] = "DROP TABLE Platy_Shop_Config";
        
        $db->beginTransaction();
        
        try {
            for ($i = 0; $i < count($sql); $i++) {
                $db->query($sql[$i]);
            }
        }
        catch (Exception $e) {
            $db->rollBack();
            //echo $e->getMessage();
            return false;
        }
        
        $db->commit();
        
        return true;
    }
    
    public function getName()
    {
        return 'Shop';
    }
    
    public function getTitle()
    {
        return 'オンラインショップ';
    }
    
    public function getSummary()
    {
        return 'オンラインショップ';
    }
    
    public function getAuthor()
    {
        return 'altkraft';
    }
}
?>