<?php
/**
 * Bbs(電子掲示板) モジュール
 */
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';
require_once 'Platy/Module.php';
require_once 'Platy/SystemDB.php';
require_once 'Platy/Form.php';

class Platy_Module_Bbs extends Platy_Module
{
    public function install()
    {
        global $db;
        
        $sql = "CREATE TABLE Platy_Bbs ("
               . "id            integer PRIMARY KEY,"
               . "title         varchar(255),"
               . "description   text,"
               . "memberId      int DEFAULT 0,"
               . "parentId      int DEFAULT 0,"
               . "created       datetime,"
               . "modified      datetime,"
               . "ipaddr        varchar(32),"
               . "name          varchar(64),"
               . "email         varchar(128),"
               . "delkey        varchar(32));";
        $db->query($sql);
        
        // メニューアイテム追加
        $item = array('bar'=>'global', 'type'=>'module', 'title'=>'掲示板', 'module_name'=>'Bbs', 'module_param' => '');
        addToMenu($item);
        
        return true;
    }
    
    public function uninstall()
    {
        global $db;
        $sql[] = "DROP TABLE Platy_Bbs";
        $db->query($sql);
        return true;
    }
    
    public function getName()
    {
        return 'Bbs';
    }
    
    public function getTitle()
    {
        return '電子掲示板';
    }
    
    public function getSummary()
    {
        return 'シンプルな電子掲示板';
    }
    
    public function getAuthor()
    {
        return 'altkraft';
    }
    
    public function getVersion()
    {
        return '0.0.0';
    }
}
?>