<?php
/**
 * Feed 変数
 */
require_once 'Zend/Feed.php';
require_once 'Platy/CVar.php';

class Platy_CVar_Feed extends Platy_CVar
{
    function install() { return true; }
    function uninstall() { return true; }
    
    public function getSummary()
    {
        return 'Feedを表示する';
    }
    
    public function doCVar($param)
    {
        $url = $param[0];
        if ($url == '') { return; }
        
        try {
            $Rss = Zend_Feed::import($url);
        } catch (Zend_Feed_Exception $e) {
            // フィードの読み込みに失敗しました
            echo "フィードの読み込み中に例外が発生: { $e->getMessage() }\n";
            return false;
        }
        
        // チャネルデータの配列を初期化します
        $channel = array(
            'title'       => $Rss->title(),
            'link'        => $Rss->link(),
            'description' => $Rss->description(),
            'items'       => array()
            );
        //var_dump($Rss);
        
        // チャネルの各項目をループし、関連するデータを保存します
        foreach ($Rss as $item) {
            //echo '|' . $item->title() . '|' . $item->link() . "<br />\n";
            $channel['items'][] = array(
                'title'       => $item->title(),
                'link'        => $item->link(),
                'description' => $item->description()
                );
        }
        
        echo '<a href="' . $channel['link'] . '">';
        echo $channel['title'];
        echo '</a>' . "<br />\n";
        
        //var_dump($channel['items']);
        
        $j = 0;
        foreach ($channel['items'] as $item) {
            echo '<a href="' . $item['link'] . '">';
            echo $item['title'];
            echo '</a>' . "<br />\n";
            if (++$j > 5) { break; }
        }
        
        return true;
    }
    
    public function getVersion()
    {
        return '0.0.0';
    }
    
    public function getAuthor()
    {
        return 'altkraft';
    }
}
?>
