<?php
/**
 * Shop モジュール
 */
require_once 'Zend/Controller/Action.php';
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';
require_once 'Platy/Util.php';

class DbShopOrder extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Shop_Order';
    }
}
class DbShopOrderProduct extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Shop_Order_Product';
    }
}

class ShopController extends Zend_Controller_Action
{
    private $contents;
    private $sidebarSetId;
    private $menuSetId;
    
    public function preDispatch()
    {
        global $manager, $breadcrumb, $db;
        
        $manager->module = 'Shop';
        $breadcrumb->add('ホーム', BASE_URL);
        $breadcrumb->add('ショップ', BASE_URL . 'Shop/');
        
        // actionがcompleteでなければ$_SESSION['complete']を削除する
        $action = $this->getRequest()->getActionName();
        if ($action != 'complete') {
            unset($_SESSION['complete']);
        }
        
        // sidebarSetId, menuSetIdの取得
        $sql = "SELECT sidebarSetId, menuSetId FROM Platy_Module WHERE name='Shop'";
        $row = $db->fetchRow($sql);
        $this->sidebarSetId = $row['sidebarSetId'];
        $this->menuSetId = $row['menuSetId'];
    }
    
    public function indexAction()
    {
        global $db, $config, $breadcrumb;
        
        ob_start();
        
        echo '<h2>ショップ</h2>' . "\n";
        
        $contents = ob_get_contents();
        
        $sql = "SELECT id, name, title, summary, description FROM Platy_Content_Base WHERE type='Product'";
        $rows = $db->fetchAll($sql);
        
        foreach ($rows as $row) {
            
            $id = $row['id'];
            $sql2 = "SELECT image, selling_price, special_price FROM Platy_Content_Product WHERE id={$id}";
            $row2 = $db->fetchRow($sql2);
            
            echo '<div class="content">' . "\n";
            echo '<div class="title">';
            echo '<a href="' . BASE_URL . 'Shop/detailproduct/id/' . $row['id'] . '">';
            echo $row['title'];
            echo '</a>';
            echo '</div>' . "\n";
            
            echo '<div class="main">' . "\n";
            echo '<table><tr><td>';            
            echo '<image src="' . BASE_URL . 'media/Product/' . $row2['image'] . '">';
            echo '</td><td>';
            
            echo $row['summary'] . "<br />\n";
            echo '<strong>' . Platy_Util::cnv_currency($row2['selling_price']) . "</strong><br />\n";
            echo '<strong>' . Platy_Util::cnv_currency($row2['special_price']) . "</strong><br />\n";
            
            $id = $row['id'];
            echo '<form method="post" action="' . BASE_URL . 'Shop/addtocart/' . '">';
            echo '<input type="hidden" name="id" value="' . $id . '" />';
            echo '<input type="submit" value="カートに入れる">';
            echo '</form>';
            
            echo '</td></tr></table>' . "\n";
            echo '</div>' . "\n";
            
            echo '<div class="footer">' . '</div>' . "\n";
            echo '</div>', "\n";
        
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * 商品一覧
     */
    public function listproductAction()
    {
    }
    
    /**
     * 商品の詳細
     */
    public function detailproductAction()
    {
        global $db, $config;
        
        ob_start();
        
        // id/[id]
        $request = $this->getRequest();
        $id = $request->getParam('id');
        
        $sql = "SELECT id, name, title, summary, description FROM Platy_Content_Base WHERE type='Product' AND id={$id}";
        $row = $db->fetchRow($sql);
        
        $sql2 = "SELECT image, selling_price, special_price FROM Platy_Content_Product WHERE id={$id}";
        $row2 = $db->fetchRow($sql2);


        echo '<div class="content">' . "\n";
        echo '<div class="title">';
        echo '<a href="' . BASE_URL . 'Shop/detailproduct/id/' . $row['id'] . '">';
        echo $row['title'];
        echo '</a>';
        echo '</div>' . "\n";
        
        echo '<div class="main">' . "\n";
        echo '<table><tr><td>';            
        echo '<image src="' . BASE_URL . 'media/Product/' . $row2['image'] . '">';
        echo '</td><td>';
        
        if ($row['description'] == '') {
            echo $row['summary'] . "<br />\n";
        }
        else {
            echo $row['description'] . "<br />\n";
        }
        
        echo '<strong>' . Platy_Util::cnv_currency($row2['selling_price']) . "</strong><br />\n";
        echo '<strong>' . Platy_Util::cnv_currency($row2['special_price']) . "</strong><br />\n";
        
        $id = $row['id'];
        echo '<form method="post" action="' . BASE_URL . 'Shop/addtocart/' . '">';
        echo '<input type="hidden" name="id" value="' . $id . '" />';
        echo '<input type="submit" value="カートに入れる">';
        echo '</form>';
        
        echo '</td></tr></table>' . "\n";
        echo '</div>' . "\n";
        
        echo '<div class="footer">' . '</div>' . "\n";
        echo '</div>', "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * カートに追加する
     */
    public function addtocartAction()
    {
        global $MyCart;
        
        $id = intval($_POST['id']);
        if (isset($_POST['qty'])) {
            $qty = intval($_POST['qty']);
        }
        else {
            $qty = 1;
        }
        $MyCart->add($id, $qty);
        
        $this->_redirect('Shop/cart/');
    }
    
    /**
     * カートから削除する
     */
    public function deletefromcartAction()
    {
        global $MyCart;
        
        // index/[index]
        $request = $this->getRequest();
        $index = $request->getParam('index');
        
        $MyCart->delete($index);
        $this->_redirect('Shop/cart/');
    }
    
    /**
     * カートの中身を表示する
     */
    public function cartAction()
    {
        global $db, $config, $MyCart;
        
        ob_start();
        
        echo '<h3>ショッピングカート</h3>' . "\n";
        
        $items = $MyCart->items();
        //var_dump($items);
        
        $total = 0;
        echo '<form method="post" action="' . BASE_URL . 'Shop/updatecart/">' . "\n";
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th colspan="2">商品</th><th>単価</th><th>数量</th><th>小計</th>' . "\n";
        for ($i = 0; $i < count($items); $i++) {
            $val = $items[$i];
            echo '<tr>' . "\n";
            echo '<td>';
            echo $val['productId'];
            echo '</td>';
            echo '<td>';
            echo '<img src="' . BASE_URL . 'media/Product/Thumbnail/' . $val['image'] . '">';
            echo '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Shop/detailproduct/id/' . $val['itemId'] . '">';
            echo '<strong>' . $val['title'] . '</strong>' . "<br />\n";
            //echo $val['option_string'];
            echo '</a>';
            echo '</td>';
            echo '<td class="right">' . Platy_Util::cnv_currency($val['price']) . '</td>';
            echo '<td>';
            echo '<input type="text" name="qty[]" value="' . $val['qty'] . '" size="2">' . "<br />\n";
            echo '<a href="' . BASE_URL . 'Shop/deletefromcart/index/' . $val['index'] . '">' . '削除' . '</a>';
            echo '<input type="hidden" name="id[]" value="' . $val['index'] . '" />' . "\n";
            echo '</td>';
            $subtotal = $val['price'] * $val['qty'];
            $total += $subtotal;
            echo '<td class="right">' . Platy_Util::cnv_currency($subtotal) . '</td>';
            echo '</tr>' . "\n";
        }
        echo '<tr><td colspan="5">合計</td><td><strong>' . Platy_Util::cnv_currency($total) . '</strong></td></tr>' . "\n";
        echo '</table>' . "\n";
        echo '<input type="submit" name="update" value="カートを更新する" />' . "\n";
        echo '</form>';
        
        echo '<a href="' . BASE_URL . 'Shop/login/">注文する</a><br />' . "\n";
        echo '<a href="' . BASE_URL . 'Shop/">買い物を続ける</a><br />' . "\n";

        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * カートの更新
     */
    public function updatecartAction()
    {
        global $MyCart;
        for ($i = 0; $i < count($_POST['id']); $i++) {
            $id = intval($_POST['id'][$i]);
            $qty = intval($_POST['qty'][$i]);
            //echo $id . "|" . $qty . "<br />\n";
            if ($qty <= 0) {
                $MyCart->delete($id);
            }
            else {
                $MyCart->update($id, $qty);
            }
        }
        $this->_redirect('Shop/cart/');
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * ログイン
     */
    public function loginAction()
    {
        global $db, $Me;
        
        if ($Me->isLoggedIn() == true) {
            $this->_redirect('/Shop/address/');
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            // 
            $email = h($_POST['email']);
            $password = h($_POST['password']);
            
            
        }
        
        ob_start();

        echo '<h2>ログイン</h2>';
        echo '<form method="post" action="' . BASE_URL . 'Member/login/' . '">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>Eメールアドレス *</th>';
        echo '<td><input type="text" name="email" value="' . $email . '" size="32" />' . "</td></tr>\n";
        echo '<tr><th>パスワード *</th>';
        echo '<td><input type="password" name="password" value="' . $password . '" size="32" />' . "\n";
        echo '<input type="hidden" name="redirect_url" value="' . 'Shop/address/' . '">' . "\n";
        echo "</td></tr>\n";
        echo '<tr><td></td><td>';
        echo '<input type="submit" value="login" />' . "\n";
        echo '</td></tr>';
        echo '</table>' . "\n";
        
        echo '<h2>ユーザ登録</h2>';
        
        echo '<h2>ユーザ登録をしない</h2>';
        echo '<a href="' . BASE_URL . 'Shop/address/' . '">登録せずに購入する</a>';
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
        
    }
    
    /**
     * 個人情報の入力チェック
     */
    private function validateOrder()
    {
    }
    
    /**
     * 住所入力のチェック
     */
    public function addressValidation(&$error)
    {
        global $db, $config;
        
        if (h($_POST['fullname']) == '') {
            $error[] = "お名前が未入力です";
        }
        if (h($_POST['email']) == '') {
            $error[] = "Eメールアドレスが未入力です";
        }
        if (count($error)) {
            return false;
        }
        return true;
    }
    
    /**
     * 個人情報入力 (1/4)
     */
    public function addressAction()
    {
        global $db, $config, $MyCart, $Me;
        $error = array();
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            
            $p['fullname'] = h($_POST['fullname']);
            $p['email'] = h($_POST['email']);
            $p['postcode'] = h($_POST['postcode']);
            $p['state'] = h($_POST['state']);
            $p['city'] = h($_POST['city']);
            $p['street'] = h($_POST['street']);
            $p['phone'] = h($_POST['phone']);
            $p['delivery'] = h($_POST['delivery']);
            $p['delivery_fullname'] = h($_POST['delivery_fullname']);
            $p['delivery_email'] = h($_POST['delivery_email']);
            $p['delivery_postcode'] = h($_POST['delivery_postcode']);
            $p['delivery_state'] = h($_POST['delivery_state']);
            $p['delivery_city'] = h($_POST['delivery_city']);
            $p['delivery_street'] = h($_POST['delivery_street']);
            $p['delivery_phone'] = h($_POST['delivery_phone']);
            
            if ($this->addressValidation($error) == true) {
                $_SESSION[SESS_KEY]['shop_address'] = $p;
                $this->_redirect('/Shop/payment/');
            }
        }
        else if (isset($_SESSION[SESS_KEY]['shop_address'])) {
            $p = $_SESSION[SESS_KEY]['shop_address'];
        }
        else {
            if ($Me->isLoggedIn() == true) {
                
            }
            else {
                $p['fullname'] = '';
                $p['email'] = '';
                $p['postcode'] = '';
                $p['state'] = '';
                $p['city'] = '';
                $p['street'] = '';
                $p['phone'] = '';
                $p['delivery'] = 0;
                $p['delivery_fullname'] = "";
                $p['delivery_email'] = "";
                $p['delivery_postcode'] = "";
                $p['delivery_state'] = "";
                $p['delivery_city'] = "";
                $p['delivery_street'] = "";
                $p['delivery_phone'] = "";
            }
        }
        
        ob_start();
        
        echo '<h3>お客様情報の入力</h3>' . "\n";
        
        $items = $MyCart->items();
        //var_dump($MyCart);
        
        if (count($error)) {
            $msg  = '入力内容にエラーがあります。以下の項目を修正してください。' . "\n";
            $msg .= '<ul><li>' . implode('</li><li>', $error) . '</li></ul>' . "\n";
            MsgBox($msg, "", "WARNING");
        }
        
        echo '<form method="post" action="">' . "\n";
        
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>お名前 *</th>';
        echo '<td><input type="text" name="fullname" value="' . $p['fullname'] . '" size="32" />' . "</td></tr>\n";
        echo '<tr><th>Eメールアドレス *</th>';
        echo '<td><input type="text" name="email" value="' . $p['email'] . '" size="64" />' . "</td></tr>\n";
        echo '<tr><th>郵便番号 *</th>';
        echo '<td><input type="text" name="postcode" value="' . $p['postcode'] . '" size="8" />' . "</td></tr>\n";
        echo '<tr><th>都道府県 *</th>';
        echo '<td><input type="text" name="state" value="' . $p['state'] . '" size="64" />' . "</td></tr>\n";
        echo '<tr><th>市区町村 *</th>';
        echo '<td><input type="text" name="city" value="' . $p['city'] . '" size="64" />' . "</td></tr>\n";
        echo '<tr><th>番地 *</th>';
        echo '<td><input type="text" name="street" value="' . $p['street'] . '" size="64" />' . "</td></tr>\n";
        echo '<tr><th>電話番号 *</th>';
        echo '<td><input type="text" name="phone" value="' . $p['phone'] . '" size="16" />' . "</td></tr>\n";
        
        // 配送先の指定
        echo '<tr><th>配送先</th>';
        echo '<td><input type="checkbox" name="delivery" />';
        echo '配送先を指定する' . "</td></tr>\n";
        
        echo '<tr><th>配送先のお名前</th>';
        echo '<td><input type="text" name="delivery_name" value="' . $p['delivery_name'] . '" size="32" />' . "</td></tr>\n";
        echo '<tr><th>配送先の郵便番号</th>';
        echo '<td><input type="text" name="delivery_postcode" value="' . $p['delivery_postcode'] . '" size="8" />' . "</td></tr>\n";
        echo '<tr><th>配送先の都道府県</th>';
        echo '<td><input type="text" name="delivery_state" value="' . $p['delivery_address'] . '" size="64" />' . "</td></tr>\n";
        echo '<tr><th>配送先の市区町村</th>';
        echo '<td><input type="text" name="delivery_city" value="' . $p['delivery_city'] . '" size="64" />' . "</td></tr>\n";
        echo '<tr><th>配送先の番地</th>';
        echo '<td><input type="text" name="delivery_street" value="' . $p['delivery_street'] . '" size="64" />' . "</td></tr>\n";
        echo '<tr><th>配送先の電話番号:</th>';
        echo '<td><input type="text" name="delivery_phone" value="' . $p['delivery_phone'] . '" size="16" />' . "</td></tr>\n";
        
        echo '<tr><th></th>';
        echo '<td><input type="submit" value="次へ" />' . "</td></tr>\n";
        
        echo '</table>' . "\n";
        
        echo '</form>' . "\n";
        
        $this->OrderStep(0);
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * お支払い,配送方法のチェック
     */
    public function paymentValidation(&$error)
    {
        global $db, $config;
        
        if (!isset($_POST['payment'])) {
            $error[] = "お支払い方法が選択されていません";
        }
        if (!isset($_POST['shipping'])) {
            $error[] = "配送方法が選択されていません";
        }
        if (count($error)) {
            return false;
        }
        return true;
    }
    
    /**
     * 支払い,配送方法の選択 (2/4)
     */
    public function paymentAction()
    {
        global $db, $config, $MyCart;
        $error = array();
        
        if (!isset($_SESSION[SESS_KEY]['shop_address'])) {
            $this->_redirect('Shop/address/');
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $p['payment'] = intval($_POST['payment']);
            $p['shipping'] = intval($_POST['shipping']);
            
            if ($this->paymentValidation($error) == true) {
                $_SESSION[SESS_KEY]['shop_payment'] = $p;
                $this->_redirect('/Shop/confirm/');
            }
        }
        else if (isset($_SESSION[SESS_KEY]['shop_payment'])) {
            $p = $_SESSION[SESS_KEY]['shop_payment'];
        }
        else {
            $p['payment'] = -1;
            $p['shipping'] = -1;
        }
        
        ob_start();
        
        echo '<h3>お支払い、配送方法の選択</h3>' . "\n";
        
        if (count($error)) {
            $msg  = '入力内容にエラーがあります。以下の項目を修正してください。' . "\n";
            $msg .= '<ul><li>' . implode('</li><li>', $error) . '</li></ul>' . "\n";
            MsgBox($msg, "", "WARNING");
        }
        
        echo '<form method="post" action="">' . "\n";
        echo '<h3>お支払い方法</h3>' . "\n";
        $sql = "SELECT id, name, title FROM Platy_Shop_Payment WHERE status=1";
        $rows = $db->fetchAll($sql);
        $n = count($rows);
        
        echo '<table class="list_table">';
        echo '<th>title</th>' . "\n";
        for ($i = 0; $i < $n; $i++) {
            $row = $rows[$i];
            echo '<tr>';
            echo '<td>';
            echo '<input type="radio" name="payment" value="' . $row['id'] . '"';
            if ($n == 1 || $p['payment'] == $row['id']) {
                echo ' checked="true"';
            }
            echo ' />';
            echo $row['title'];
            echo '</td>';
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        echo '<h3>配送方法</h3>' . "\n";
        
        $sql = "SELECT id, name, title FROM Platy_Shop_Shipping WHERE status=1";
        $rows = $db->fetchAll($sql);
        $n = count($rows);
        
        echo '<table class="list_table">';
        echo '<th>title</th>' . "\n";
        for ($i = 0; $i < $n; $i++) {
            $row = $rows[$i];
            echo '<tr>';
            echo '<td>';
            echo '<input type="radio" name="shipping" value="' . $row['id'] . '"';
            if ($n == 1 || $p['shipping'] == $row['id']) {
                echo ' checked="true"';
            }
            echo ' />';
            echo $row['title'];
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>' . "\n";
        
        echo '<input type="submit" value="次へ" />' . "\n";
        echo '<a href="' . BASE_URL . 'Shop/address">戻る</a>';
        echo '<br />' . "\n";
        
        $this->OrderStep(1);
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * 内容確認 (3/4)
     */
    public function confirmAction()
    {
        global $db;
        
        if (!isset($_SESSION[SESS_KEY]['shop_address'])) {
            $this->_redirect('Shop/address/');
        }
        if (!isset($_SESSION[SESS_KEY]['shop_payment'])) {
            $this->_redirect('Shop/payment/');
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $this->_redirect('Shop/complete/');
        }
        
        ob_start();
        
        echo '<h3>内容の確認</h3>';
        
        $this->CartSummary();
        
        $p1 = $_SESSION[SESS_KEY]['shop_address'];
        $p2 = $_SESSION[SESS_KEY]['shop_payment'];
        
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>お名前</th><td>';
        echo $p1['fullname'];
        echo '</td></tr>' . "\n";
        echo '<tr><th>Eメールアドレス</th><td>';
        echo $p1['email'];
        echo '</td></tr>' . "\n";
        echo '<tr><th>郵便番号</th><td>';
        echo $p1['postcode'];
        echo '</td></tr>' . "\n";
        echo '<tr><th>都道府県</th><td>';
        echo $p1['state'];
        echo '</td></tr>' . "\n";
        echo '<tr><th>市区町村</th><td>';
        echo $p1['city'];
        echo '</td></tr>' . "\n";
        echo '<tr><th>番地</th><td>';
        echo $p1['street'];
        echo '</td></tr>' . "\n";
        echo '<tr><th>電話番号</th><td>';
        echo $p1['phone'];
        echo '</td></tr>' . "\n";
        
        if ($p1['delivery'] == 1) {
            
            
            
            
        }
        else {
            //echo '<tr><th>配送先</th><td>';
            //echo '';
            //echo '</td></tr>' . "\n";
        }
        
        echo '<tr><th>お支払い方法</th><td>';
        $sql = "SELECT title FROM Platy_Shop_Payment WHERE id=" . $p2['payment'];
        $row = $db->fetchRow($sql);
        echo $row['title'];
        echo '</td></tr>' . "\n";
        
        echo '<tr><th>配送方法</th><td>';
        $sql = "SELECT title FROM Platy_Shop_Shipping WHERE id=" . $p2['shipping'];
        $row = $db->fetchRow($sql);
        echo $row['title'];
        echo '</td></tr>' . "\n";
        
        echo '</table>' . "\n";
        
        echo '<form method="post" action="">' . "\n";
        echo '<input type="submit" value="登録する" />' . "\n";
        echo '</form>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Shop/payment">戻る</a>';
        
        echo '<br />' . "\n";
        $this->OrderStep(2);
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * 注文完了 (4/4)
     */
    public function completeAction()
    {
        global $db, $config, $MyCart, $Me;
        
        if (!isset($_SESSION[SESS_KEY]['shop_address'])
            && !isset($_SESSION[SESS_KEY]['shop_payment'])
            && !isset($_SESSION[SESS_KEY]['shop_complete']))
        {
            die('page access error!');
        }
        
        if (isset($_SESSION[SESS_KEY]['shop_address']) 
            && isset($_SESSION[SESS_KEY]['shop_payment']))
        {
            $p1 = $_SESSION[SESS_KEY]['shop_address'];
            $p2 = $_SESSION[SESS_KEY]['shop_payment'];
            $fullname = $p1['fullname'];
            $email = $p1['email'];
            $postcode = $p1['postcode'];
            $state = $p1['state'];
            $city = $p1['city'];
            $street = $p1['street'];
            $phone = $p1['phone'];
            $delivery = $p1['delivery'];
            $delivery_fullname = $p1['delivery_fullname'];
            $delivery_postcode = $p1['delivery_postcode'];
            $delivery_state = $p1['delivery_state'];
            $delivery_city = $p1['delivery_city'];
            $delivery_street = $p1['delivery_street'];
            $delivery_phone = $p1['delivery_phone'];
            $payment = $p2['payment'];
            $shipping = $p2['shipping'];
            
            $ShopOrder = new DbShopOrder();
            $order = $ShopOrder->createRow();
            $order->fullname = $fullname;
            $order->email = $email;
            $order->postcode = $postcode;
            $order->state = $state;
            $order->city = $city;
            $order->street = $street;
            $order->phone = $phone;
            $order->delivery = $delivery;
            if ($delivery == 1) {
                $order->delivery_fullname = $delivery_fullname;
                $order->delivery_postcode = $delivery_postcode;
                $order->delivery_state = $delivery_state;
                $order->delivery_city = $delivery_city;
                $order->delivery_street = $delivery_street;
                $order->delivery_phone = $delivery_phone;
            }
            $order->created = date('Y-m-d H:i:s');
            $order->modified = date('Y-m-d H:i:s');
            $order->save();
            $orderId = $order->id;
            
            $total = 0;
            $items = $MyCart->items();
            foreach ($items as $key => $val) {
                $subtotal = $val['price'] * $val['qty'];
                $total += $subtotal;
                $ShopOrderProduct = new DbShopOrderProduct();
                $item = $ShopOrderProduct->createRow();
                $item->orderId = $orderId;
                $item->productId = $val['productId'];
                $item->price = $val['price'];
                $item->qty = $val['qty'];
                $item->subtotal = $subtotal;
                $item->save();
                $itemId = $item->id; // get id
            }
            $order->total = $total;
            $order->save();
            
            // メール送信
            // TODO
            
            // お客様情報を保存する
            if ($Me->isLoggedIn() == true) {
            
            }
            
            // $_SESSION['shop_complete']は、
            // complete画面がリロードされたときにも表示するため
            
            $_SESSION[SESS_KEY]['shop_complete'] = array('flag' => 1);
            
            unset($_SESSION[SESS_KEY]['shop_address']);
            unset($_SESSION[SESS_KEY]['shop_payment']);
            $MyCart->clear();
        }
        
        ob_start();
        
        if (isset($_SESSION[SESS_KEY]['shop_complete'])) {
            echo '<h3>注文完了</h3>' . "\n";
            echo '当店をご利用いただきまして誠にありがとうございました。<br />' . "\n";
            echo 'ただいまお客様のメールアドレスに、ご注文内容を送信しました。<br />' . "\n";
            echo '今後ともよろしくお願い申し上げます。<br />' . "\n";
            
            echo '<a href="' . BASE_URL . 'Shop/">商品一覧に戻る</a>';
            
            $this->OrderStep(3);
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * カートの中身を表示する
     */
    public function CartSummary() {
        global $db, $config, $MyCart;

        $items = $MyCart->items();
        //var_dump($MyCart);
        
        $total = 0;
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th colspan="2">商品</th><th>単価</th><th>数量</th><th>小計</th>' . "\n";
        for ($i = 0; $i < count($items); $i++) {
            $val = $items[$i];
            echo '<tr>' . "\n";
            echo '<td>';
            echo $val['itemId'];
            echo '</td>';
            echo '<td>';
            echo '<img src="' . BASE_URL . 'media/Shop/' . $val['image'] . '" width="48" height="48">';
            echo '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Shop/detailproduct/id/' . $val['itemId'] . '">';
            echo '<strong>' . $val['title'] . '</strong>' . "<br />\n";
            //echo $val['option_string'];
            echo '</a>';
            echo '</td>';
            echo '<td class="right">' . Platy_Util::cnv_currency($val['price']) . '</td>';
            echo '<td>';
            echo $val['qty'];
            echo '</td>';
            
            $subtotal = $val['price'] * $val['qty'];
            $total += $subtotal;
            echo '<td class="right">' . Platy_Util::cnv_currency($subtotal) . '</td>';
            echo '</tr>' . "\n";
        }
        echo '<tr><td colspan="5">合計</td><td><strong>' . Platy_Util::cnv_currency($total) . '</strong></td></tr>' . "\n";
        echo '</table>' . "\n";
    }
    
    /**
     * 表示
     */
    private function view()
    {
        global $breadcrumb, $config;
        global $db, $menuSetId, $js_helper, $css_helper;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->config = $config;
        $view->contents = $this->contents;
        $view->breadcrumb = $breadcrumb->getContents();
        $view->sidebar = buildSidebar($this->sidebarSetId);
        $view->menu_header = buildMenu('header', $this->menuSetId);
        $view->menu_global = buildMenu('global', $this->menuSetId);
        $view->menu_footer = buildMenu('footer', $this->menuSetId);
        $view->js_files = $js_helper->listFiles();
        $view->css_files = $css_helper->listFiles();
        echo $view->render('page.php');
    }
    
    /**
     * 注文ステップの表示
     */
    private function OrderStep($n)
    {
        $step[0] = "1 お客様情報の入力";
        $step[1] = "2 支払い,配送方法の選択";
        $step[2] = "3 内容の確認";
        $step[3] = "4 完了";
        for ($i = 0; $i < count($step); $i++) {
            if ($i > 0) {
                echo "->";
            }
            if ($i == $n) {
                echo '[' . $step[$i] . ']';
            }
            else {
                echo $step[$i];
            }
        }
    }
}
?>