<?php
/**
 * Search モジュール
 * 
 */
require_once 'Zend/Controller/Action.php';

class SearchController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $manager, $breadcrumb;
        
        $manager->module = 'Search';
        $breadcrumb->add('ホーム', BASE_URL);
        $breadcrumb->add('検索', BASE_URL . 'Search/');
    }
    
    public function indexAction()
    {
        global $db, $config, $manager, $currentContent, $breadcrumb;
        
        ob_start();
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            // 検索結果
            
            $match_count = 0;
            
            $q = h(e($_POST['q']));
            
            echo "<h2>'" . $q . "'の検索結果</h2>" . "\n";
            
            $sql = "SELECT id, type FROM Platy_Content_Base "
                 . "WHERE title LIKE '%{$q}%' OR summary LIKE '%{$q}%' OR description LIKE '%{$q}%'";
            //echo $sql . "<br />\n";
            $rows = $db->fetchAll($sql);
            foreach ($rows as $row) {
                $content = getContentFromId($row['id']);
                //var_dump($content);
                $id = $row['id'];
                $type = $row['type'];
                
                require_once(APP_PATH . 'models/ContentType/' . $type . '.php');
                $classname = 'Platy_ContentType_' . $type;
                $obj = new $classname($id);
                
                // status,期間のチェック
                $startDate = $obj->startDate;
                $endDate = $obj->endDate;
                $status = $obj->status;
                if ($status == 'public' && checkPeriod($startDate, $endDate) == true) {
                    $link = $serverRoot . $content['url'];
                    //echo $link . "<br />\n";
                    
                    $currentContent['id'] = $id;
                    $currentContent['type'] = $type;
                    $manager->raiseEvent('PreViewContent');
                    
                    $obj->viewSummary();
                    $match_count++;
                }
                else {
                    echo $startDate . "<br />\n";
                    echo $endDate . "<br />\n";
                    echo $status . "<br />\n";
                }
            }
            echo '<strong>' . $match_count . '</strong>件該当しました。' . "<br />\n";
        }
        else {
            // 検索フォーム
            echo '<h2>検索</h2>' . "\n";
            echo '<form method="post" action="">' . "\n";
            echo '<input type="text" name="q" size="60" />' . "\n";
            echo '<input type="submit" value="検索する" />' . "\n";
            echo '</form>' . "\n";
        }
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->contents = $contents;
        $view->config = $config;
        $view->breadcrumb = $breadcrumb->getContents();
        echo $view->render('page.php');
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
}
?>