<?php
/**
 * Poll モジュール
 * 
 */
require_once 'Platy/Form.php';
require_once 'Zend/Controller/Action.php';

class PollController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $manager, $breadcrumb;
        
        $manager->module = 'Poll';
        $breadcrumb->add('ホーム', BASE_URL);
        $breadcrumb->add('投票', BASE_URL . 'Poll/');
    }
    
    public function indexAction()
    {
        global $db, $breadcrumb, $config;
        
        ob_start();
        
        echo '<h2>投票</h2>' . "\n";
        
        $sql = "SELECT id, title FROM Platy_Poll ORDER BY modified";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            $pollId = $row['id'];
            $title = $row['title'];
            echo '<form method="post" action="' . BASE_URL . 'Poll/vote/id/' . $pollId . '">' . "\n";
            echo '<div class="content">' . "\n";
            echo '<div class="title">' . "\n";
            echo $title;
            echo '</div>' . "\n";
            echo '<div class="main">' . "\n";
            $sql2 = "SELECT id, title, ordering FROM Platy_PollItem WHERE pollId={$pollId} ORDER BY ordering";
            $rows2 = $db->fetchAll($sql2);
            foreach ($rows2 as $row2) {
                echo '<label>';
                echo '<input type="radio" name="ordering" value="' . $row2['ordering'] . '">';
                //echo $row2['ordering'] . ":";
                echo $row2['title'] . "<br />\n";
                echo '</label>' . "\n";
            }
            echo '<input type="submit" value="投票する">' . "\n";
            echo '<a href="' . BASE_URL . 'Poll/detail/id/' . $pollId . '">' . '結果をみる' . '</a>' . "\n";
            echo '</div>' . "\n";
            echo '<div class="footer"></div>' . "\n";
            echo '</div>' . "\n";
            echo '</form>' . "\n";
            break;
        }
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH .'views');
        $view->contents = $contents;
        $view->config = $config;
        $view->breadcrumb = $breadcrumb->getContents();
        echo $view->render('page.php');
    }
    
    /**
     * 投票実行
     */
    public function voteAction()
    {
        global $db, $config;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $request = $this->getRequest();
            $pollId = intval($request->getParam('id'));
            //$pollId = intval($_POST['id']);
            $ordering = intval($_POST['ordering']);
            $sql = "UPDATE Platy_PollItem SET votes = votes + 1 WHERE pollId={$pollId} AND ordering={$ordering}";
            $db->query($sql);
            $this->_redirect('Poll/detail/id/' . $pollId . '/');
        }
        die();
    }
    
    /**
     * 投票の詳細
     */
    public function detailAction()
    {
        global $db, $breadcrumb, $config;
        
        $request = $this->getRequest();
        $pollId = intval($request->getParam('id'));
        
        ob_start();
        
        echo '<h2>投票の詳細</h2>' . "\n";
        
        $sql = "SELECT id, title FROM Platy_Poll WHERE id={$pollId}";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            $pollId = $row['id'];
            $title = $row['title'];
            echo '<div class="content">' . "\n";
            echo '<div class="title">' . "\n";
            echo $title . "\n";
            echo '</div>' . "\n";
            echo '<div class="main">' . "\n";
            $sql2 = "SELECT id, title, ordering, votes FROM Platy_PollItem WHERE pollId={$pollId} ORDER BY ordering";
            $rows2 = $db->fetchAll($sql2);
            foreach ($rows2 as $row2) {
                //echo $row2['ordering'] . ":";
                echo $row2['title'] . ":";
                echo $row2['votes'];
                echo "<br />\n";
            }
            echo '</div>' . "\n";
            echo '<div class="footer"></div>' . "\n";
            echo '</div>' . "\n";
        }
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH .'views');
        $view->contents = $contents;
        $view->config = $config;
        $view->breadcrumb = $breadcrumb->getContents();
        echo $view->render('page.php');
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
}
?>