<?php
/**
 * Map モジュール
 * 
 */
require_once 'Platy/Form.php';
require_once 'Zend/Controller/Action.php';

class MapController extends Zend_Controller_Action
{
    private $sidebarSetId;
    private $menuSetId;
    
    public function preDispatch()
    {
        global $manager, $breadcrumb, $db;
        
        $manager->module = 'Map';
        $breadcrumb->add('ホーム', BASE_URL);
        $breadcrumb->add('マップ', BASE_URL . 'Map/');
        
        $sql = "SELECT sidebarSetId, menuSetId FROM Platy_Module WHERE name='Map'";
        $row = $db->fetchRow($sql);
        $this->sidebarSetId = $row['sidebarSetId'];
        $this->menuSetId = $row['menuSetId'];
    }
    
    public function indexAction()
    {
        global $db, $config, $breadcrumb;
        
        $errors = array();
        
        $lat = 37.4419;
        $lng = -122.1419;
        $zoom = 13;
        $html = '';

        ob_start();
        
        echo '<h2>コンテンツ地図</h2>' . "\n";
?>

<script type="text/javascript" src="http://www.google.com/jsapi?key=<?php echo $config['S_GOOGLEMAPS_KEY'] ?>"></script>
<script type="text/javascript">
  google.load("maps", "2.x");
  function geo_initialize() {
    var map = new google.maps.Map2(document.getElementById("map_canvas"));
    map.addControl(new GSmallMapControl());
    map.addControl(new GMapTypeControl());
    map.setCenter(new google.maps.LatLng(<?php echo $lat ?>, <?php echo $lng ?>), <?php echo $zoom ?>);
    var point = new GLatLng(<?php echo $lat ?>, <?php echo $lng ?>);
    var marker = new GMarker(point);
    map.addOverlay(marker);
  }
  google.setOnLoadCallback(geo_initialize);
</script>
<div id="map_canvas" style="width: 100%; height: 300px"></div>

<?php
        $sql = "SELECT id, lat, lng, zoom, html FROM Platy_CExt_Geo";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            var_dump($row);
        }
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH .'views');
        $view->contents = $contents;
        $view->config = $config;
        $view->breadcrumb = $breadcrumb->getContents();
        $view->sidebar = buildSidebar($this->sidebarSetId);
        echo $view->render('page.php');
    }
    
    public function requestAction()
    {
        global $db;
        
        header("Content-type: application/xml");
        echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
        echo '<markers>' . "\n";
        $sql = "SELECT id, lat, lng,  html FROM Platy_CExt_Geo";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            //var_dump($row);
            echo '  <marker '
                . 'id="' . $row['id'] . '" '
                . 'lat="' . $row['lat'] . '" '
                . 'lng="' . $row['lng'] . '" '
                . '/>' . "\n";
        }
        echo '</markers>' . "\n";
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
}
?>