<?php
/**
 * サイドバー
 */
require_once 'Zend/Controller/Action.php';

class Manage_SidebarController extends Zend_Controller_Action
{
    private $contents;
    
    public function preDispatch()
    {
        global $Me, $currentManage, $breadcrumb;
        
        if ($Me->isAllowed('Manage_Site') == false) {
            $this->_redirect('/Manage/Login/');
        }
        $currentManage = 'Sidebar';
        $breadcrumb->add('管理', BASE_URL . 'Manage/');
        $breadcrumb->add('サイドバー', BASE_URL . 'Manage/Sidebar/');
    }
    
    public function indexAction()
    {
        $this->setlistAction();
    }
    
    /**
     * モジュール選択
     */
    public function selectModuleAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>サイトバー設定</h2>' . "\n";
        echo "サイドバーを設定するモジュールを選択してください<br />\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<tr><td>';
        echo '<a href="' . BASE_URL . 'Manage/Sidebar/list/mod/' . 'Global' . '">';
        echo 'Global';
        echo '</a>';
        echo '</td><td>';
        
        $sql = "SELECT id, widget FROM Platy_Sidebar WHERE module='Global'";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo $row['widget'] . "<br />\n";
        }
        
        echo '</td></tr>' . "\n";
        
        echo '<tr><td>';
        echo '<a href="' . BASE_URL . 'Manage/Sidebar/list/mod/' . 'Node' . '">';
        echo 'Node';
        echo '</a>';
        echo '</td><td>';
        $sql = "SELECT id, widget FROM Platy_Sidebar WHERE module='Node'";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo $row['widget'] . "<br />\n";
        }
        echo '</td></tr>' . "\n";
        
        $sql = "SELECT name FROM Platy_Module";
        $rows = $db->fetchAll($sql);
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            
            echo '<tr><td>';
            echo '<a href="' . BASE_URL . 'Manage/Sidebar/list/mod/' . $row['name'] . '">';
            echo $row['name'];
            echo '</a>';
            echo '</td><td>';
            $sql2 = "SELECT id, widget FROM Platy_Sidebar WHERE module='{$row['name']}'";
            $rows2 = $db->fetchAll($sql2);
            foreach ($rows2 as $row2) {
                echo $row2['widget'] . "<br />\n";
            }
            echo '</td></tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * サイドバーセット一覧
     */
    public function setlistAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>サイドバーセット一覧</h2>' . "\n";
        
        $sql = "SELECT id, name, summary FROM Platy_SidebarSet";
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>name</th><th>summary</th><th>widgets</th><th>action</th>' . "\n";
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            //var_dump($row);
            
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['name'] . '</td>';
            echo '<td>' . $row['summary'] . '</td>';
            echo '<td>' . '</td>';
            
            echo '<td>';
            
            echo '<a href="' . BASE_URL . 'Manage/Sidebar/setedit/setid/' . $row['id'] . '">';
            echo '編集';
            echo '</a>';
            echo '&nbsp;|&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Sidebar/setdelete/setid/' . $row['id'] . '">';
            echo '削除';
            echo '</a>';
            
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Sidebar/setadd/' . '">';
        echo 'サイドバーセットの追加';
        echo '</a>';
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * サイドバーセット編集
     */
    public function seteditAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $setid = $request->getParam('setid');
        
        ob_start();
        
        $sql = "SELECT id, name, summary FROM Platy_SidebarSet WHERE id={$setid}";
        $row = $db->fetchRow($sql);
        echo '<h2>' . $row['name'] . '</h2>' . "\n";
        
        $sql = "SELECT id, ordering, widget, code, lr FROM Platy_Sidebar WHERE sidebarSetId={$setid} ORDER BY ordering";
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>widget</th><th>code</th><th>ordering</th><th>lr</th><th>action</th>' . "\n";
        foreach ($rows as $row) {
            //var_dump($row);
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['widget'] . '</td>';
            echo '<td>' . $row['code'] . '</td>';
            echo '<td>' . $row['ordering'] . '</td>';
            echo '<td>' . $row['lr'] . '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Sidebar/delete/id/' . $row['id'] . '/setid/' . $setid . '">';
            echo '削除';
            echo '</a>';
            echo '&nbsp;|&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Sidebar/ordering/id/' . $row['id'] . '/setid/' . $setid . '">';
            echo '並び順変更';
            echo '</a>';
            echo '&nbsp;|&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Sidebar/property/id/' . $row['id'] . '/setid/' . $setid . '">';
            echo 'プロパティ';
            echo '</a>';
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Sidebar/addwidget/setid/' . $setid . '">';
        echo 'ウィジェットの追加';
        echo '</a>';
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * サイドバーセットの登録
     */
    public function setaddAction()
    {
        global $db, $config;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $name = h($_POST['name']);
            $summary = h($_POST['summary']);
            $sql = "INSERT INTO Platy_SidebarSet(name, summary) VALUES("
                   . $db->quote($name) . ","
                   . $db->quote($summary) . ")";
            //echo $sql;
            $db->query($sql);
            $this->_redirect('/Manage/Sidebar/setlist/');
        }
        else {
            $name = "";
            $summary = "";
        }
        
        ob_start();
        
        echo '<h2>サイドバーセットの追加</h2>' . "\n";
        
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><td>name</td>';
        echo '<td>';
        echo '<input type="text" name="name" value="' . $name . '">';
        echo '</td></tr>' . "\n";
        echo '<tr><td>summary</td>';
        echo '<td>';
        echo '<textarea name="summary">';
        echo $summary;
        echo '</textarea>';
        echo '</td></tr>';
        echo '<tr><td></td><td>';
        echo '<input type="submit" />' . "\n";
        echo '</td></tr>';
        echo '</table>';
        echo '</form>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * ウィジェットの追加
     */
    public function addwidgetAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $setid = $request->getParam('setid');
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $widget = h($_POST['widget']);
            $code = h($_POST['code']);
            $ordering = intval($_POST['ordering']);
            $sql = "INSERT INTO Platy_Sidebar(sidebarSetId, widget,code,ordering) VALUES({$setid},'{$widget}','{$code}',{$ordering})";
            //echo $sql;
            $db->query($sql);
        }
        
        ob_start();
        
        $sql = "SELECT id, name, summary FROM Platy_SidebarSet WHERE id={$setid}";
        $row = $db->fetchRow($sql);
        echo '<h2>' . $row['name'] . "のサイドバーにウィジェットを追加する" . "</h2>\n";
        
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><td>widget</td>';
        echo '<td>';
        echo '<select name="widget">' . "\n";
        $sql = "SELECT id, name FROM Platy_Widget";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            $widget_name = $row['name'];
            
            require_once(APP_PATH . 'models/Widget/'. $widget_name . '.php');
            $widget_class_name = 'Platy_Widget_' . $widget_name;
            $obj = new $widget_class_name;

            echo '<option value="' . $row['name'] . '">';
            echo $row['name'];
            if ($obj->isMulti() == true) { echo ' [M]'; }
            echo '</option>' . "\n";
            //echo $row['name'];
        }
        echo '</select>' . "<br />\n";
        echo '</td></tr>';
        echo '<tr><td>code</td><td>';
        echo '<input type="text" name="code" />' . "</td></tr>\n";
        echo '<tr><td>ordering</td><td>';
        echo '<input type="text" name="ordering" size="4" />' . "<br />\n";
        echo '</td></tr>';
        echo '<tr><td></td><td>';
        echo '<input type="submit" />' . "\n";
        echo '</td></tr>';
        echo '</table>';
        echo '</form>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * 一覧
     */
    public function listAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $module = $request->getParam('mod');
        
        ob_start();
        
        echo $module . "<br />\n";
        
        $sql = "SELECT id, ordering, widget, code, lr FROM Platy_Sidebar WHERE module='{$module}' ORDER BY ordering";
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>widget</th><th>code</th><th>ordering</th><th>action</th>' . "\n";
        foreach ($rows as $row) {
            //var_dump($row);
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['widget'] . '</td>';
            echo '<td>' . $row['code'] . '</td>';
            echo '<td>' . $row['ordering'] . '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Sidebar/delete/id/' . $row['id'] . '/mod/' . $module . '">';
            echo '削除';
            echo '</a>';
            echo '&nbsp;|&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Sidebar/ordering/id/' . $row['id'] . '/mod/' . $module . '">';
            echo '並び順変更';
            echo '</a>';
            echo '&nbsp;|&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Sidebar/property/id/' . $row['id'] . '/mod/' . $module . '">';
            echo 'プロパティ';
            echo '</a>';

            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Sidebar/add/mod/' . $module . '">';
        echo 'ウィジェットの追加';
        echo '</a>';

        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * ウィジェット追加
     */
    public function addAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $module = $request->getParam('mod');
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $widget = h($_POST['widget']);
            $code = h($_POST['code']);
            $ordering = intval($_POST['ordering']);
            $sql = "INSERT INTO Platy_Sidebar(module, widget,code,ordering) VALUES('{$module}','{$widget}','{$code}',{$ordering})";
            //echo $sql;
            $db->query($sql);
            
        }
        
        ob_start();
        
        echo '<h2>' . $module . "のサイドバーにウィジェットを追加する" . "</h2>\n";
        
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><td>widget</td>';
        echo '<td>';
        echo '<select name="widget">' . "\n";
        $sql = "SELECT id, name FROM Platy_Widget";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            $widget_name = $row['name'];
            
            require_once(APP_PATH . 'models/Widget/'. $widget_name . '.php');
            $widget_class_name = 'Platy_Widget_' . $widget_name;
            $obj = new $widget_class_name;

            echo '<option value="' . $row['name'] . '">';
            echo $row['name'];
            if ($obj->isMulti() == true) { echo ' [M]'; }
            echo '</option>' . "\n";
            //echo $row['name'];
        }
        echo '</select>' . "<br />\n";
        echo '</td></tr>';
        echo '<tr><td>code</td><td>';
        echo '<input type="text" name="code" />' . "</td></tr>\n";
        echo '<tr><td>ordering</td><td>';
        echo '<input type="text" name="ordering" size="4" />' . "<br />\n";
        echo '</td></tr>';
        echo '<tr><td></td><td>';
        echo '<input type="submit" />' . "\n";
        echo '</td></tr>';
        echo '</table>';
        echo '</form>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * ウィジェット編集
     */
    public function editAction()
    {
    }
    
    /**
     * ウィジェット削除
     */
    public function deleteAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $module = $request->getParam('mod');
        $id = $request->getParam('id');
        
        $sql = "DELETE FROM Platy_Sidebar WHERE id={$id}";
        $db->query($sql);
        
        
    }
    
    /**
     * 並び順の変更
     */
    public function orderingAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $module = $request->getParam('mod');
        $id = $request->getParam('id');
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $ordering = intval($_POST['ordering']);
            $sql = "UPDATE Platy_Sidebar SET ordering={$ordering} WHERE id={$id}";
            //echo $sql;
            $db->query($sql);
            
            // 一覧に戻る
            $this->_redirect('/Manage/Sidebar/list/mod/' . $module);
        }
        else {
            $sql = "SELECT ordering FROM Platy_Sidebar WHERE id={$id}";
            $row = $db->fetchRow($sql);
            $ordering = $row['ordering'];
        }
        
        ob_start();
        
        echo '<h2>並び順の変更</h2>' . "\n";
        echo '<form method="post" action="">' . "\n";
        echo '<input type="text" name="ordering" size="4" value="' . $ordering . '" />' . "<br />\n";
        echo '<input type="submit" />' . "\n";
        echo '</form>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * プロパティ
     */
    public function propertyAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $module = $request->getParam('mod');
        $id = $request->getParam('id');
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        }
        else {
        }
        
        ob_start();
        
        echo '<h2>プロパティ</h2>' . "\n";
        
        $sql = "SELECT widget, code FROM Platy_Sidebar WHERE id={$id}";
        $row = $db->fetchRow($sql);
        var_dump($row);
        $widget_name = $row['widget'];
        $code = $row['code'];
        
        require(APP_PATH . 'models/Widget/' . $widget_name . '.php');
        $widget_class_name = 'Platy_Widget_' . $widget_name;
        $obj = new $widget_class_name();
        if ($obj->isMulti() == false) {
            echo "not multi<br />\n";
        }
        $terval = $obj->property($code);
        if ($retval == true) {
            $this->_redirect('/Manage/Sidebar/list/mod/' . $module);
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * 表示
     */
    private function view()
    {
        global $breadcrumb;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $this->contents;
        $view->breadcrumb = $breadcrumb->getContents();
        //$view->sidebar = $this->buildSidebar();
        echo $view->render('page.php');
    }
}
?>