<?php
/**
 * Pollモジュールの管理
 */
require_once 'Zend/Controller/Action.php';

class Manage_PollController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $Me;
        if ($Me->isAdmin() == false) {
            $this->_redirect('/Manage/Login/');
        }
    }
    
    public function indexAction()
    {
        $this->_redirect('/Manage/Poll/list/');
        $this->configAction();
    }
    
    public function configAction()
    {
        global $db, $config;
        
        ob_start();
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $intro = h($_POST['intro']);
            $admin_email = h($_POST['admin_email']);
            
        }
        else {
            $intro = $config['M_CONTACT_INTRO'];
            $admin_email = $config['M_CONTACT_ADMIN_EMAIL'];
        }
        
        echo '<h2>お問い合わせの設定</h2>' . "\n";
        echo '<form method="post" action="">' . "<br />\n";
        echo "Eメールアドレス:<br />\n";
        echo '<input type="text" name="admin_email" value="' . $admin_email . '" size="60" />';
        echo "<br />\n";
        echo "INTRO:<br />\n";
        echo '<textarea name="intro" rows="4" cols="60">';
        echo $intro;
        echo '</textarea>' . "<br />\n";
        echo '<input type="submit" />' . "\n";
        echo '</form>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    public function listAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>投票一覧</h2>' . "\n";
        
        $sql = "SELECT id, title FROM Platy_Poll";
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>title</th><th>操作</th>' . "\n";
        foreach ($rows as $row) {
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['title'] . '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Poll/delete/id/' . $row['id'] . '"><img src="/Platy/media/system/14_layer_deletelayer.png" alt="delete">削除</a>';
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Poll/add/">' . '投票の追加' . '</a>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    /**
     * 投票の詳細
     */
    public function detailAction()
    {
    }
    
    /**
     * 投票の編集
     */
    public function editAction()
    {
    }
    
    /**
     * 投票の追加
     */
    public function addAction()
    {
        global $db, $config;
        
        $errors = array();
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $title = h($_POST['title']);
            $summary = h($_POST['summary']);
            $startDate = h($_POST['startDate']);
            $endDate = h($_POST['endDate']);
            for ($i = 0; $i < 8; $i++) {
                $item[$i] = h($_POST['item'][$i]);
            }
            
            // validation
            // TODO
            
            $created = date('Y-m-d H:i:s');
            $modified = $created;
            $sql = "INSERT INTO Platy_Poll(title, summary, startDate, endDate, created, modified)"
                 . "VALUES("
                 . "'{$title}','{$summary}','{$startDate}','{$endDate}','{$created}','{$modified}')";
            $db->query($sql);
            $pollId = $db->lastInsertId();
            $ordering = 0;
            for ($i = 0; $i < 8; $i++) {
                if ($item[$i] != '') {
                    $sql = "INSERT INTO Platy_PollItem(pollId, title, ordering) VALUES("
                         . "{$pollId},'{$item[$i]}',{$ordering})";
                    $db->query($sql);
                    $ordering++;
                }
            }
            $this->_redirect('/Manage/Poll/list/');
        }
        else {
            $title = '';
            $summary = '';
            $startDate = h($_POST['startDate']);
            $endDate = h($_POST['endDate']);
            for ($i = 0; $i < 8; $i++) {
                $item[$i] = h($_POST['item'][$i]);
            }
        }
        
        ob_start();
        
        echo '<h2>投票の追加</h2>' . "\n";
        
        echo '<form method="post" name="f" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>タイトル</th>';
        echo '<td>';
        echo '<input type="text" name="title" size="80" value="' . $title . '" />';
        echo '</td></tr>' . "\n";
        echo '<tr><th>概要</th>';
        echo '<td>';
        echo '<textarea name="summary" rows="4" cols="50">';
        echo $summary;
        echo '</textarea>';
        echo '</td></tr>' . "\n";
        echo '<tr><th>選択肢</th>';
        echo '<td>' . "\n";
        for ($i = 0; $i < 8; $i++) {
            echo '(' . ($i+1) . ')';
            echo '<input type="text" name="item[]" size="80" value="' . $item[$i] . '" /><br />' . "\n";
        }
        echo '</td></th>';
        echo '<tr><th>投票開始日時</th>';
        echo '<td>';
        echo '<input type="text" name="startDate" size="24" value="' . $startDate . '" />';
        echo '<input type="button" value="..." onclick="dateinput(this.form.startDate)" />';
        echo '</td></tr>' . "\n";
        echo '<tr><th>投票終了日時</th>';
        echo '<td>';
        echo '<input type="text" name="endDate" size="24" value="' . $endDate . '" />';
        echo '<input type="button" value="..." onclick="dateinput(this.form.endDate)" />';
        echo '</td></tr>' . "\n";
        echo '<tr><th></th><td>';
        echo '<input type="submit" value="投票を追加する" /></td></tr>';
        echo '</table>' . "\n";
        echo '</form>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    /**
     * 投票の削除
     */
    public function deleteAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $pollId = intval($request->getParam('id'));
        
        $sql = "DELETE FROM Platy_Poll WHERE id={$pollId}";
        $db->query($sql);
        
        $sql = "DELETE FROM Platy_Pollitem WHERE pollId={$pollId}";
        $db->query($sql);
        
        $this->_redirect('/Manage/Poll/list/');
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
}
?>