<?php
/**
 * メニュー管理
 */
require_once 'Zend/Controller/Action.php';

class Manage_MenuController extends Zend_Controller_Action
{
    private $contents;
    
    public function preDispatch()
    {
        global $Me, $currentManage, $breadcrumb;
        
        if ($Me->isAllowed('Manage_Site') == false) {
            $this->_redirect('/Manage/Login/');
        }
        $currentManage = 'Menu';
        $breadcrumb->add('管理', BASE_URL . 'Manage/');
        $breadcrumb->add('メニュー', BASE_URL . 'Manage/Menu/');
    }
    
    public function indexAction()
    {
        //$this->listMenuAction();
        $this->setlistAction();
    }

    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * メニューセット一覧
     */
    public function setlistAction()
    {
        global $db;
        
        ob_start();
        
        echo '<h2>メニューセット一覧</h2>' . "\n";
        
        $sql = "SELECT id, name, summary FROM Platy_MenuSet";
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>name</th><th>summary</th><th>modules</th><th>folders</th><th>items</th><th>action</th>' . "\n";
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            //var_dump($row);
            
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['name'] . '</td>';
            echo '<td>' . $row['summary'] . '</td>';
            echo '<td>' . '</td>';
            echo '<td>' . '</td>';
            echo '<td>';
            $sql2 = "SELECT COUNT(*) FROM Platy_Menu WHERE menuSetId=" . $row['id'];
            $row2 = $db->fetchRow($sql2);
            echo $row2['COUNT(*)'];
            echo '</td>';
            
            echo '<td>';
            
            echo '<a href="' . BASE_URL . 'Manage/Menu/setedit/setid/' . $row['id'] . '">';
            echo '<img src="' . BASE_URL . 'media/system/action_edit.png' . '" alt="edit" />';
            echo '編集';
            echo '</a>';
            echo '&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Menu/setdelete/setid/' . $row['id'] . '">';
            echo '<img src="' . BASE_URL . 'media/system/action_delete.png' . '" alt="delete" />';
            echo '削除';
            echo '</a>';
            
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Menu/setadd/' . '">';
        echo 'メニューセットの追加';
        echo '</a>';
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * メニューセットの登録
     */
    public function setaddAction()
    {
        global $db, $config;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $name = h($_POST['name']);
            $summary = h($_POST['summary']);
            $sql = "INSERT INTO Platy_MenuSet(name, summary) VALUES("
                   . $db->quote($name) . ","
                   . $db->quote($summary) . ")";
            $db->query($sql);
            $this->_redirect('/Manage/Menu/setlist/');
        }
        else {
            $name = '';
            $summary = '';
        }
        
        ob_start();
        
        echo '<h2>メニューセットの追加</h2>' . "\n";
        
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><td>name</td>';
        echo '<td>';
        echo '<input type="text" name="name" value="' . $name . '">';
        echo '</td></tr>' . "\n";
        echo '<tr><td>summary</td>';
        echo '<td>';
        echo '<textarea name="summary">';
        echo $summary;
        echo '</textarea>';
        echo '</td></tr>';
        echo '<tr><td></td><td>';
        echo '<input type="submit" />' . "\n";
        echo '</td></tr>';
        echo '</table>';
        echo '</form>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * メニューセット編集
     * 
     */
    public function seteditAction()
    {
        
        global $db;
        
        $request = $this->getRequest();
        $setid = intval($request->getParam('setid'));
        
        $sql = "SELECT name FROM Platy_MenuSet WHERE id={$setid}";
        $row = $db->fetchRow($sql);
        
        ob_start();
        
        echo '<h2>メニューセット' . $row['name'] . 'のメニューアイテム一覧</h2>' . "\n";
        
        $sql = "SELECT id, bar, title, ordering, type, module_name, module_param, link_url, dmi_name FROM Platy_Menu WHERE menuSetId={$setid}";
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>bar</th><th>title</th><th>type</th><th>summary</th><th>ordering</th><th>action</th>' . "\n";
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            //var_dump($row);
            
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['bar'] . '</td>';
            echo '<td>' . $row['title'] . '</td>';
            echo '<td>' . $row['type'] . '</td>';
            echo '<td>';
            if ($row['type'] == 'module') {
                echo $row['module_name'] . "<br />";
                echo $row['module_param'];
            }
            else if ($row['type'] == 'link') {
                echo $row['link_url'];
            }
            else if ($row['type'] == 'dmi') {
                echo $row['dmi_name'];
            }
            echo '</td>';
            echo '<td>' . $row['ordering'] . '</td>';
            
            echo '<td>';
            
            echo '<a href="' . BASE_URL . 'Manage/Menu/edititem/id/' . $row['id'] . '/setid/' . $setid . '">';
            echo '<img src="' . BASE_URL . 'media/system/action_edit.png' . '" alt="edit" />';
            echo '編集';
            echo '</a>';
            echo '&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Menu/deleteitem/id/' . $row['id'] . '/setid/' . $setid . '">';
            echo '<img src="' . BASE_URL . 'media/system/action_delete.png' . '" alt="delete" />';
            echo '削除';
            echo '</a>';
            
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Menu/additem/setid/' . $setid . '">';
        echo 'メニューアイテムの追加';
        echo '</a>';
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
        
        
        
        
        
    }
    
    /**
     *
     */
    public function listmenuAction()
    {
        global $db;
        
        ob_start();
        
        // id/[id]
        $request = $this->getRequest();
        $bar = $request->getParam('bar');
        if ($bar == 'global' || $bar == 'header' || $bar == 'footer') {
            $where = "WHERE bar='{$bar}'";
        }
        else {
            $where = "";
        }
        
        $sql = "SELECT id, bar, type, title, module_name, module_param, link_url, ordering "
             . "FROM Platy_Menu "
             . $where;
        $rows = $db->fetchAll($sql);
        
        echo '<h2>メニュー一覧</h2>' . "\n";
        echo '<a href="' . BASE_URL . 'Manage/Menu/">all</a>' . "\n";
        echo '&nbsp;|&nbsp;';
        echo '<a href="' . BASE_URL . 'Manage/Menu/listMenu/bar/header">header</a>' . "\n";
        echo '&nbsp;|&nbsp;';
        echo '<a href="' . BASE_URL . 'Manage/Menu/listMenu/bar/global">global</a>' . "\n";
        echo '&nbsp;|&nbsp;';
        echo '<a href="' . BASE_URL . 'Manage/Menu/listMenu/bar/footer">footer</a>' . "\n";
        echo "<br />\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>bar</th><th>type</th><th>title</th><th>module_name</th><th>module_param</th><th>link_url</th><th>ordering</th><th>action</th>' . "\n";

        for($i = 0; $i < count($rows); $i++) {
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            echo '<td>' . $rows[$i]['id'] . '</td>' . "\n";
            echo '<td>' . $rows[$i]['bar'] . '</td>' . "\n";
            echo '<td>' . $rows[$i]['type'] . '</td>' . "\n";
            echo '<td>' . $rows[$i]['title'] . '</td>' . "\n";
            echo '<td>' . $rows[$i]['module_name'] . '</td>' . "\n";
            echo '<td>' . $rows[$i]['module_param'] . '</td>' . "\n";
            echo '<td>' . $rows[$i]['link_url'] . '</td>' . "\n";
            echo '<td>' . $rows[$i]['ordering'] . '</td>' . "\n";
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Menu/editItem/id/' . $rows[$i]['id'] . '">edit</a>';
            echo '&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Menu/deleteItem/id/' . $rows[$i]['id'] . '">delete</a>';
            echo '</td>' . "\n";
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Menu/addItem/setid/"' . $setid . '>メニュー項目を追加する</a>' . "<br />\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * メニュー項目の編集
     */
    public function edititemAction()
    {
        global $db, $config;
        
        ob_start();
        
        // id/[id]/setid/[setid]
        $request = $this->getRequest();
        $id = $request->getParam('id');
        $setid = $request->getParam('setid');
        
        $p = array();
        $p['submit_value'] = 'メニュー項目を更新する';
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            
            $p['bar'] = h($_POST['bar']);
            $p['type'] = h($_POST['type']);
            $p['title'] = h($_POST['title']);
            $p['module_name'] = h($_POST['module_name']);
            $p['module_param'] = h($_POST['module_param']);
            $p['link_url'] = h($_POST['link_url']);
            $p['dmi_name'] = h($_POST['dmi_name']);
            $p['ordering'] = intval($_POST['ordering']);
            
            $sql = "UPDATE Platy_Menu SET "
                 . "bar='{$p['bar']}', "
                 . "type='{$p['type']}', "
                 . "title='{$p['title']}', "
                 . "module_name='{$p['module_name']}', "
                 . "module_param='{$p['module_param']}', "
                 . "link_url='{$p['link_url']}', "
                 . "dmi_name='{$p['dmi_name']}', "
                 . "ordering={$p['ordering']} "
                 . "WHERE id={$id}";
            //echo $sql . "<br />\n";
            $db->query($sql);
            $this->_redirect('/Manage/Menu/setedit/setid/' . $setid);
        }
        else {
            $sql = "SELECT id, bar, type, title, module_name, module_param, link_url, dmi_name, ordering "
                 . "FROM Platy_Menu "
                 . "WHERE id={$id}";
            $row = $db->fetchRow($sql);
            $p['bar'] = $row['bar'];
            $p['type'] = $row['type'];
            $p['title'] = $row['title'];
            $p['module_name'] = $row['module_name'];
            $p['module_param'] = $row['module_param'];
            $p['link_url'] = $row['link_url'];
            $p['dmi_name'] = $row['dmi_name'];
            $p['ordering'] = $row['ordering'];
        }
        
        echo '<h2>メニュー項目の編集</h2>' . "\n";
        
        $this->form_item($p);
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * メニュー項目の追加
     */
    public function additemAction()
    {
        global $db, $config;
        
        // setid/[setid]
        $request = $this->getRequest();
        $setid = $request->getParam('setid');
        
        ob_start();
        
        $p = array();
        $p['submit_value'] = 'メニューアイテムを追加する';
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $p['bar'] = h($_POST['bar']);
            $p['ordering'] = intval($_POST['ordering']);
            $p['type'] = h($_POST['type']);
            $p['title'] = h($_POST['title']);
            $p['module_name'] = h($_POST['module_name']);
            $p['module_param'] = h($_POST['module_param']);
            $p['link_url'] = h($_POST['link_url']);
            $p['dmi_name'] = h($_POST['dmi_name']);
            if ($p['type'] == 'module') {
                $sql = "INSERT INTO Platy_Menu(bar, menuSetId, ordering, type, title, module_name, module_param) VALUES("
                     . "'{$p['bar']}', {$setid}, {$p['ordering']}, '{$p['type']}', '{$p['title']}', '{$p['module_name']}', '{$p['module_param']}')";
            }
            else if ($p['type'] == 'link') {
                $sql = "INSERT INTO Platy_Menu(bar, menuSetId, ordering, type, title, link_url) VALUES("
                     . "'{$p['bar']}', {$setid}, {$p['ordering']}, '{$p['type']}', '{$p['title']}', '{$p['link_url']}')";
            }
            else if ($p['type'] == 'dmi') {
                $sql = "INSERT INTO Platy_Menu(bar, menuSetId, ordering, type, title, dmi_name) VALUES("
                     . "'{$p['bar']}', {$setid}, {$p['ordering']}, '{$p['type']}', '{$p['title']}', '{$p['dmi_name']}')";
            }
            echo $sql . "<br />\n";
            $db->query($sql);
            $this->_redirect('/Manage/Menu/setedit/setid/' . $setid);
        }
        else {
            $p['ordering'] = 0;
            $p['type'] = '';
            $p['title'] = '';
            $p['module_name'] = '';
            $p['module_param'] = '';
            $p['link_url'] = '';
            $p['dmi_name'] = '';
        }
        
        echo '<h2>メニューアイテムの追加</h2>' . "\n";
        
        $this->form_item($p);
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * メニューアイテムフォームの表示
     * @param array $p フォームパラメータ配列
     */
    private function form_item($p)
    {
        global $db;
        
        echo '<form method="post" action="">' . "\n";
        
        echo '<table class="form_table">';
        echo '<tr><th>bar</th><td>';
        echo '<select name="bar">' . "\n";
        echo '<option value="header"';
        if ($p['bar'] == 'header') { echo ' selected="true"'; }
        echo '>header</option>' . "\n";
        echo '<option value="global"';
        if ($p['bar'] == 'global') { echo ' selected="true"'; }
        echo '>global</option>' . "\n";
        echo '<option value="footer"';
        if ($p['bar'] == 'footer') { echo ' selected="true"'; }
        echo '>footer</option>' . "\n";
        echo '</select>' . "<br />\n";
        echo '</td></tr>' . "\n";
        
        echo "<tr><th>ordering</th><td>\n";
        echo '<input type="text" name="ordering" value="' . $p['ordering'] . '" size="2" />' . "</td></tr>\n";
        
        echo "<tr><th>type</th><td>\n";
        echo '<select name="type">' . "\n";
        echo '<option value="module"';
        if ($p['type'] == 'module') { echo ' selected="true"'; }
        echo '>module</option>' . "\n";
        echo '<option value="link"';
        if ($p['type'] == 'link') { echo ' selected="true"'; }
        echo '>link</option>' . "\n";
        echo '<option value="dmi"';
        if ($p['type'] == 'dmi') { echo ' selected="true"'; }
        echo '>dmi</option>' . "\n";
        echo '</select>' . "</td></tr>\n";
        
        echo "<tr><th>title</th><td>\n";
        echo '<input type="text" name="title" size="60" value="' . $p['title'] . '" />' . "</td></tr>\n";
        
        echo "<tr><th>module</th><td>\n";
        echo 'module_name:';
        
        $sql = "SELECT id, name FROM Platy_Module";
        $rows = $db->fetchAll($sql);
        echo '<select name="module_name">' . "\n";
        foreach ($rows as $row) {
            echo '<option value="' . $row['name'];
            if ($row['name'] == $p['module_name']) {
                echo ' selected="true"';
            }
            echo '">' . $row['name'] . '</option>' . "\n";
        }
        echo '</select>' . "\n";
        
        echo 'module_param:';
        echo '<input type="text" name="module_param" size="60" value="' . $p['module_param'] . '" />' . "<br />\n";
        echo "</td></tr>" . "\n";
        
        echo "<tr><th>link</th><td>\n";
        echo 'link_url:';
        echo '<input type="text" name="link_url" size="60" value="' . $p['link_url'] . '" />' . "<br />\n";
        echo "</td></tr>" . "\n";
        
        echo "<tr><th>dmi</th><td>\n";
        echo 'dmi_name:';
        
        $sql = "SELECT id, name FROM Platy_DMI";
        $rows = $db->fetchAll($sql);
        echo '<select name="dmi_name">' . "\n";
        foreach ($rows as $row) {
            echo '<option value="' . $row['name'];
            if ($row['name'] == $p['module_name']) {
                echo ' selected="true"';
            }
            echo '">' . $row['name'] . '</option>' . "\n";
        }
        echo '</select>' . "\n";
        
        echo "</td></tr>" . "\n";
        
        echo "<tr><th></th><td>\n";
        echo '<input type="submit" value="' . $p['submit_value'] . '" />' . "\n";
        echo "</td></tr>" . "\n";
        echo "</table>" . "\n";
        
        echo '</form>' . "\n";
    }
    
    /**
     * メニュー項目の削除
     */
    public function deleteitemAction()
    {
        global $db, $config;
        
        // id/[id]/setid/[setid]
        $request = $this->getRequest();
        $id = $request->getParam('id');
        $setid = $request->getParam('setid');
        
        $sql = "DELETE FROM Platy_Menu WHERE id={$id}";
        $db->query($sql);
        
        $this->_redirect('/Manage/Menu/setedit/setid.' . $setid);
    }
    
    private function view()
    {
        global $breadcrumb;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $this->contents;
        $view->breadcrumb = $breadcrumb->getContents();
        $view->sidebar = $this->buildSidebar();
        echo $view->render('page.php');
    }
    
    public function buildSidebar()
    {
        ob_start();
        
        echo '<div class="widget">' . "\n";
        echo '<div class="title">メニュー</div>' . "\n";
        echo '<div class="main">' . "\n";
        
        echo '<ul>' . "\n";
        echo '<li><a href="' . BASE_URL . 'Manage/Menu/setlist/">メニューセット</a></li>' . "\n";
        echo '<li><a href="' . BASE_URL . 'Manage/Menu/listdmi/">DMI</a></li>' . "\n";
        echo '</ul>' . "\n";
        echo '</div>' . "\n";
        echo '</div>' . "<!-- /widget -->\n";
        
        $sidebar = ob_get_contents();
        ob_end_clean();
        
        return $sidebar;
    }
    
    /**
     * DMI一覧
     */
    public function listdmiAction()
    {
        global $db, $base, $breadcrumb;
        
        ob_start();
        
        $DMI_path = APP_PATH . 'models/DMI/';
        
        echo '<h2>DMIリスト</h2>' . "\n";
        echo '<h3>インストール済のDMI</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";
        $installed_DMI_name = array();
        $sql = "SELECT id, name FROM Platy_DMI";
        $rows = $db->fetchAll($sql);
        for ($i = 0; $i < count($rows); $i++) {
        
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            
            echo '<td>' . $rows[$i]['id'] . '</td>';
            echo '<td>' . $rows[$i]['name'] . '</td>';
            
            $DMI_name = $rows[$i]['name'];
            require_once($DMI_path . $DMI_name . '.php');
            $DMI_class_name = 'Platy_DMI_' . $DMI_name;
            $obj = new $DMI_class_name;
            
            echo '<td>' . $obj->getSummary() . '</td>';
            echo '<td>' . $obj->getVersion() . '</td>';
            echo '<td>' . $obj->getAuthor() . '</td>';
            
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Menu/uninstallDMI/name/' . $rows[$i]['name'] . '">';
            echo '<img src="' . BASE_URL . 'media/system/action_uninstall.png" alt="uninstall" />';
            echo '削除</a>';
            echo '</td>';
            echo "</tr>\n";
            $installed_DMI_name[] = $rows[$i]['name'];
        }
        echo '</table>' . "\n";
        
        echo '<h3>未インストールのDMI</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";
        
        $d = dir($DMI_path);
        $i = 0;
        while (($entry = $d->read()) != FALSE) {
            if (!is_dir($DMI_path . $entry)) {
                $DMI_filename = $entry;
                //echo $DMI_filename . "<br />\n";
                $pos = stripos($DMI_filename, '.php');
                $DMI_name = substr($DMI_filename, 0, $pos);
                if (!in_array($DMI_name, $installed_DMI_name)) {
                    
                    require_once($DMI_path . $DMI_name . '.php');
                    
                    if ($i % 2 == 0) { echo '<tr class="even">'; }
                    else { echo '<tr class="odd">'; }
                    
                    echo '<td>' . $DMI_name . '</td>';
                    
                    $DMI_class_name = 'Platy_DMI_' . $DMI_name;
                    $obj = new $DMI_class_name;
                    
                    echo '<td>' . $obj->getSummary() . '</td>';
                    echo '<td>' . $obj->getVersion() . '</td>';
                    echo '<td>' . $obj->getAuthor() . '</td>';

                    echo '<td>';
                    echo '<a href="' . BASE_URL . 'Manage/Menu/installDMI/name/' . $DMI_name . '">';
                    echo '<img src="' . BASE_URL . 'media/system/action_install.png" alt="install" />';
                    echo '追加</a>';
                    echo '</td>';
                    echo '</tr>' . "\n";
                    $i++;
                }
            }
        }
        echo '</table>' . "\n";
        $d->close();
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    public function installdmiAction()
    {
        global $db;
        
        ob_start();
        
        echo 'Manage_Menu:installdmiAction()' . "<br />\n";
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        require(APP_PATH . 'models/DMI/' . $name . '.php');
        $classname = 'Platy_DMI_' . $name;
        $obj = new $classname();
        if ($obj->install() == TRUE) {
            $sql = "INSERT INTO Platy_DMI(name) VALUES('{$name}')";
            echo $sql . "<br />\n";
            $db->query($sql);
            echo $name . 'の追加に成功しました。' . "<br />\n";
        }
        else {
            echo $name . 'の追加に失敗しました。' . "<br />\n";
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    public function uninstalldmiAction()
    {
        global $db;
        
        ob_start();
        
        echo 'Manage_Menu:uninstalldmiAction()' . "<br />\n";
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        require(APP_PATH . 'models/DMI/' . $name . '.php');
        $classname = 'Platy_DMI_' . $name;
        $obj = new $classname();
        if ($obj->uninstall() == TRUE) {
            $sql = "DELETE FROM Platy_DMI WHERE name='" . $name . "'";
            $db->query($sql);
            echo $name . 'の削除に成功しました。' . "<br />\n";
        }
        else {
            echo $name . 'の削除に失敗しました。' . "<br />\n";
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
}
?>