<?php
/**
 * システム  インストール
 */
require_once 'Zend/Controller/Action.php';

class Manage_InstallController extends Zend_Controller_Action
{
    public function indexAction()
    {
        $this->installAction();
    }
    
    /**
     * インストール
     */
    public function installAction()
    {
        global $db;
        $sql = array();
        $sql[] = 'CREATE TABLE Platy_Config ('
               . 'name          varchar(255),'
               . 'value         text);';
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_SITE_NAME', 'Platy');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_SITE_SLOGAN', 'Comfortable Compact CMS');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_SITE_LOGO', '0');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_SITE_LOGO_IMAGE', 'logo.png');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_META_KEYWORDS', 'meta_keywords');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_META_DESCRIPTION', 'meta_description');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_ADMIN_EMAIL', 'admin_email');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_THEME', 'default');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_GOOGLEMAPS_KEY', '');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_GOOGLEANALYTICS_CODE', '');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_MEMBER_REGISTRATION', '0');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_MEMBER_LOGIN', '0');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_CONTENT_AUTHOR', '1');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_CONTENT_DATE', '1');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_CONTENT_REVISION', '0');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_PRINT_PAGE', '1');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_FRIENDS_EMAIL', '0');";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('S_EDITOR', 'fckeditor');";
        $sql[] = 'CREATE TABLE Platy_ContentType ('
               . 'id            integer PRIMARY KEY,'
               . 'name          varchar(64) UNIQUE,'
               . 'title         varchar(255),'
               . 'created       datetime,'
               . 'modified      datetime,'
               . 'has_child     int DEFAULT 0,'
               . 'status        varchar(32));';
        $sql[] = 'CREATE TABLE Platy_Content_Node ('
               . 'id            integer UNIQUE,'
               . 'parentId      int,'
               . 'path          varchar(255) DEFAULT NULL,'
               . 'ordering      int DEFAULT 0);';
        $sql[] = 'CREATE TABLE Platy_Content_Base ('
               . 'id            integer PRIMARY KEY,'
               . 'type          varchar(64),'
               . 'name          varchar(255),'
               . 'title         varchar(255),'
               . 'summary       text,'
               . 'description   text,'
               . 'owner         int DEFAULT NULL,'
               . 'approver      int DEFAULT NULL,'
               . 'created       datetime,'
               . 'modified      datetime,'
               . 'startDate     datetime,'
               . 'endDate       datetime,'
               . 'status        varchar(32),'
               . 'submit_note   text,'
               . 'approve_note  text,'
               . 'rev           int DEFAULT 1,'
               . 'keyword       varchar(255))';
        $sql[] = 'CREATE TABLE Platy_Module ('
               . 'id            integer PRIMARY KEY,'
               . 'name          varchar(64),'
               . 'title         varchar(255),'
               . 'sidebarSetId  int DEFAULT 1,'
               . 'menuSetId     int DEFAULT 1,'
               . 'memberId      int DEFAULT 0,'
               . 'created       datetime,'
               . 'modified      datetime);';
        $sql[] = 'CREATE TABLE Platy_CVar ('
               . 'id            integer PRIMARY KEY,'
               . 'name          varchar(64),'
               . 'ordering      int DEFAULT 0,'
               . 'status        char(12) DEFAULT NULL,'
               . 'created       datetime,'
               . 'modified      datetime);';
        $sql[] = 'CREATE TABLE Platy_CExt ('
               . 'id            integer PRIMARY KEY,'
               . 'name          varchar(64),'
               . 'ordering      int DEFAULT 0,'
               . 'status        char(12) DEFAULT NULL,'
               . 'created       datetime,'
               . 'modified      datetime);';
        $sql[] = 'CREATE TABLE Platy_Widget ('
               . 'id            integer PRIMARY KEY,'
               . 'name          varchar(64),'
               . 'multi         int DEFAULT 0,'
               . 'created       datetime);';
        $sql[] = 'CREATE TABLE Platy_SidebarSet ('
               . 'id            integer PRIMARY KEY,'
               . 'name          varchar(64) DEFAULT NULL,'
               . 'summary       text);';
        $sql[] = "INSERT INTO Platy_SidebarSet(id, name, summary) VALUES(1, 'default', 'default SidebarSet');";
        $sql[] = 'CREATE TABLE Platy_Sidebar ('
               . 'id            integer PRIMARY KEY,'
               . 'sidebarSetId  integer DEFAULT NULL,'
               . 'ordering      int DEFAULT 0,'
               . 'widget        varchar(64),'
               . 'code          varchar(64),'
               . 'lr            int DEFAULT 1);';
        
        $sql[] = 'CREATE TABLE Platy_Member ('
               . 'id            integer PRIMARY KEY,'
               . 'username      varchar(128) UNIQUE,'
               . 'email         varchar(128),'
               . 'password      varchar(128),'
               . 'status        varchar(16),'
               . 'actkey        varchar(32),'
               . 'created       datetime,'
               . 'last_login    datetime);';
        $sql[] = 'CREATE TABLE Platy_Member_Profile ('
               . 'id            integer NOT NULL,'
               . 'fullname      varchar(64),'
               . 'postcode      varchar(20),'
               . 'country       integer DEFAULT NULL,'
               . 'state         varchar(64),'
               . 'city          varchar(128),'
               . 'street        varchar(128),'
               . 'phone         varchar(20),'
               . 'phone2        varchar(20),'
               . 'url           varchar(255),'
               . 'gender        int DEFAULT 0,'
               . 'birth         date,'
               . 'icon          varchar(64));';
        
        $hashed_admin_pw = sha1('admin');
        $sql[] = "INSERT INTO Platy_Member (id, username, email, password, status) "
               . "VALUES(1, 'admin', 'admin', '{$hashed_admin_pw}', 'active');";
        $hashed_reviewer_pw = sha1('reviewer');
        $sql[] = "INSERT INTO Platy_Member (id, username, email, password, status) "
               . "VALUES(2, 'reviewer', 'reviewer', '{$hashed_reviewer_pw}', 'active');";
        $hashed_editor_pw = sha1('editor');
        $sql[] = "INSERT INTO Platy_Member (id, username, email, password, status) "
               . "VALUES(3, 'editor', 'editor', '{$hashed_editor_pw}', 'active');";
        $sql[] = 'CREATE TABLE Platy_ACL_Role ('
               . 'id            integer PRIMARY KEY,'
               . 'name          varchar(64) UNIQUE,'
               . 'summary       varchar(255));';
        $sql[] = "INSERT INTO Platy_ACL_Role(id, name, summary) VALUES(1, 'Manager','サイト管理者');";
        $sql[] = "INSERT INTO Platy_ACL_Role(id, name, summary) VALUES(2, 'Reviewer','承認者');";
        $sql[] = "INSERT INTO Platy_ACL_Role(id, name, summary) VALUES(3, 'Editor', '編集者');";
        $sql[] = "INSERT INTO Platy_ACL_Role(id, name, summary) VALUES(4, 'Member', '登録ユーザ');";
        $sql[] = "INSERT INTO Platy_ACL_Role(id, name, summary) VALUES(5, 'Guest', 'ゲスト');";
        $sql[] = "CREATE TABLE Platy_ACL_Member_to_Role ("
               . "memberId      integer NOT NULL,"
               . "roleId        integer NOT NULL);";
        $sql[] = "INSERT INTO Platy_ACL_Member_to_Role(memberId, roleId) VALUES(1,1);";
        $sql[] = "INSERT INTO Platy_ACL_Member_to_Role(memberId, roleId) VALUES(2,2);";
        $sql[] = "INSERT INTO Platy_ACL_Member_to_Role(memberId, roleId) VALUES(3,3);";
        $sql[] = 'CREATE TABLE Platy_ACL_Privilege ('
               . 'id            integer PRIMARY KEY,'
               . 'name          varchar(64) UNIQUE,'
               . 'summary       varchar(255));';
        $sql[] = "INSERT INTO Platy_ACL_Privilege(id, name, summary) VALUES(1, 'Manage_Site', 'サイト管理');";
        $sql[] = "INSERT INTO Platy_ACL_Privilege(id, name, summary) VALUES(2, 'Manage_Contents', 'コンテンツの管理');";
        $sql[] = "INSERT INTO Platy_ACL_Privilege(id, name, summary) VALUES(3, 'Create_Contents', 'コンテンツの作成');";
        $sql[] = "INSERT INTO Platy_ACL_Privilege(id, name, summary) VALUES(4, 'Approve_Contents', 'コンテンツの承認');";
        $sql[] = "INSERT INTO Platy_ACL_Privilege(id, name, summary) VALUES(5, 'Access_Backend', '管理画面へのアクセス');";
        $sql[] = 'CREATE TABLE Platy_ACL_Role_to_Privilege ('
               . 'id            integer PRIMARY KEY,'
               . 'roleId        integer NOT NULL,'
               . 'privilegeId   integer NOT NULL);';
        $sql[] = "INSERT INTO Platy_ACL_Role_to_Privilege(roleId, privilegeId) VALUES(1, 1);";
        $sql[] = "INSERT INTO Platy_ACL_Role_to_Privilege(roleId, privilegeId) VALUES(1, 2);";
        $sql[] = "INSERT INTO Platy_ACL_Role_to_Privilege(roleId, privilegeId) VALUES(2, 4);";
        $sql[] = "INSERT INTO Platy_ACL_Role_to_Privilege(roleId, privilegeId) VALUES(3, 3);";
        $sql[] = "INSERT INTO Platy_ACL_Role_to_Privilege(roleId, privilegeId) VALUES(1, 5);";
        $sql[] = "INSERT INTO Platy_ACL_Role_to_Privilege(roleId, privilegeId) VALUES(2, 5);";
        $sql[] = "INSERT INTO Platy_ACL_Role_to_Privilege(roleId, privilegeId) VALUES(3, 5);";
        
        $sql[] = "CREATE TABLE Platy_MenuSet ("
               . "id            integer PRIMARY KEY,"
               . "name          varchar(64),"
               . "summary       text);";
        $sql[] = "INSERT INTO Platy_MenuSet(id, name, summary) VALUES(1, 'default', 'default MenuSet');";
        $sql[] = "CREATE TABLE Platy_Menu ("
               . "id            integer PRIMARY KEY,"
               . "menuSetId     integer DEFAULT NULL,"
               . "bar           varchar(64),"
               . "title         varchar(128),"
               . "ordering      int DEFAULT 0,"
               . "type          varchar(64),"
               . "module_name   varchar(128) DEFAULT NULL,"
               . "module_param  varchar(255) DEFAULT NULL,"
               . "link_url      varchar(255) DEFAULT NULL,"
               . "dmi_name      varchar(128) DEFAULT NULL);";
        $sql[] = "CREATE TABLE Platy_DMI ("
               . "id            integer PRIMARY KEY,"
               . "name          varchar(128) UNIQUE);";
        for ($i = 0; $i < count($sql); $i++) {
            try {
                echo 'sql=';
                $result = $db->query($sql[$i]);
                echo $sql[$i] . "<br />\n";
            }
            catch (Exception $e) {
                $profiler = $db->getProfiler();
                $query = $profiler->getLastQueryProfile();
                echo $query->getQuery();
                echo $e->getMessage();
                echo "エラーが発生しました。インストールを中止します。<br />\n";
                die();
            }
        }

        // CType:Docのインストール
        require_once(APP_PATH . 'models/CType/Doc.php');
        $obj = new Platy_CType_Doc();
        if ($obj->install() == false) {
            echo 'CType:Docのインストールに失敗しました。' . "<br />\n";
            die();
        }
        // CType:Folderのインストール
        require_once(APP_PATH . 'models/CType/Folder.php');
        $obj = new Platy_CType_Folder();
        if ($obj->install() == false) {
            echo 'CType:Folderのインストールに失敗しました。' . "<br />\n";
            die();
        }
        $sql = array();
        $now = date('Y-m-d H:i:s');
        $sql[] = "INSERT INTO Platy_ContentType(name) VALUES('Doc')";
        $sql[] = "INSERT INTO Platy_ContentType(name) VALUES('Folder')";
        // rootフォルダの登録
        $sql[] = "INSERT INTO Platy_Content_Base(id,type,name,owner,approver,created,modified,status) VALUES(1,'Folder','root',1,1,'{$now}','{$now}','public')";
        $sql[] = "INSERT INTO Platy_Content_Node(id,parentId) VALUES(1,0)";
        $sql[] = "INSERT INTO Platy_Content_Folder(id, view_mode, ordering_mode, sidebarSetId, menuSetId) VALUES(1, 'summary', 'ordering', 1, 1)";
        for ($i = 0; $i < count($sql); $i++) {
            try {
                echo 'sql=';
                $result = $db->query($sql[$i]);
                echo $sql[$i] . "<br />\n";
            }
            catch (Exception $e) {
                $profiler = $db->getProfiler();
                $query = $profiler->getLastQueryProfile();
                echo $query->getQuery();
                echo $e->getMessage();
                echo "エラーが発生しました。インストールを中止します。<br />\n";
                die();
            }
        }

    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
}
?>