<?php
require_once 'Zend/Controller/Action.php';

class Manage_IndexController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $Me;
        if ($Me->isAllowed('Access_Backend') == false) {
            $this->_redirect('/Manage/Login/');
        }
    }
    
    public function indexAction()
    {
        $items = array();
        $items[] = array(
                'url'     => 'Node/',
                'title'   => 'ノード',
                'summary' => 'コンテンツの追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/file-manager.png',
                );
        $items[] = array(
                'url'     => 'Ctype/',
                'title'   => 'コンテンツタイプ',
                'summary' => 'コンテンツタイプの追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/ksirtet.png',
                );
        $items[] = array(
                'url'     => 'Cext/',
                'title'   => 'コンテンツ拡張',
                'summary' => 'コンテンツ拡張の追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/ksplash.png',
                );
        $items[] = array(
                'url'     => 'Cvar/',
                'title'   => 'コンテンツ変数',
                'summary' => 'コンテンツ変数の追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/kcmfontinst.png',
                );
        $items[] = array(
                'url'     => 'Module/',
                'title'   => 'モジュール',
                'summary' => 'モジュールの追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/package_system.png',
                );
        $items[] = array(
                'url'     => 'Menu/',
                'title'   => 'メニュー',
                'summary' => 'メニューアイテムの追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/kmenuedit.png',
                );
        $items[] = array(
                'url'     => 'Widget/',
                'title'   => 'ウィジェット',
                'summary' => 'ウィジェットの追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/fifteenpieces.png',
                );
        $items[] = array(
                'url'     => 'Sidebar/',
                'title'   => 'サイドバー',
                'summary' => 'サイトバー項目の追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/icons.png',
                );
        $items[] = array(
                'url'     => 'Member/',
                'title'   => 'メンバー',
                'summary' => 'メンバーの追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/kuzer.png',
                );
        $items[] = array(
                'url'     => 'Role/',
                'title'   => 'ロール',
                'summary' => 'ロール・権限の追加、編集、削除をします',
                'icon'    => BASE_URL . 'media/system/kdmconfig.png',
                );
        $items[] = array(
                'url'     => 'Site/',
                'title'   => 'サイト情報',
                'summary' => 'サイトの設定をします',
                'icon'    => BASE_URL . 'media/system/knetconfig.png',
                );
        $items[] = array(
                'url'     => 'Db/',
                'title'   => 'データベース',
                'summary' => 'データベースのバックアップ、リストアをします',
                'icon'    => BASE_URL . 'media/system/database.png',
                );
        $items[] = array(
                'url'     => 'System/',
                'title'   => 'システム情報',
                'summary' => 'システム(フレームワーク,PHP)の情報を表示します',
                'icon'    => BASE_URL . 'media/system/penguin.png',
                );
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->items = $items;
        echo $view->render('controlpanel.php');
    }

    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
}
?>