<?php
/**
 * コンテンツタイプ管理
 */
require_once 'Zend/Controller/Action.php';

class Manage_CtypeController extends Zend_Controller_Action
{
    private $contents;
    
    public function preDispatch()
    {
        global $Me, $currentManage, $breadcrumb;
        
        if ($Me->isAllowed('Manage_Site') == false) {
            $this->_redirect('/Manage/Login/');
        }
        $currentManage = 'Ctype';
        $breadcrumb->add('管理', BASE_URL . 'Manage/');
        $breadcrumb->add('コンテンツタイプ', BASE_URL . 'Manage/Ctype/');
    }
    
    public function indexAction()
    {
        $this->listAction();
    }

    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * コンテンツタイプ一覧を表示する。
     */
    public function listAction()
    {
        global $db, $base;
        
        ob_start();
        
        echo '<h2>コンテンツタイプ管理</h2>' . "\n";
        
        echo '<h3>インストール済のコンテンツタイプ</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";
        $installed_ContentType_name = array();
        $sql = "SELECT id, name, created FROM Platy_ContentType";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            
            $ctype_name = $row['name'];
            require_once(APP_PATH . 'models/CType/' . $ctype_name . '.php');
            $class_name = 'Platy_CType_' . $ctype_name;
            $obj = new $class_name;
            
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['name'] . '</td>';
            echo '<td>' . $obj->getSummary() . '</td>';
            echo '<td>' . $obj->getVersion() . '</td>';
            echo '<td>' . $obj->getAuthor() . '</td>';

            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Ctype/uninstall/name/' . $row['name'] . '">';
            echo '<img src="' . BASE_URL . 'media/system/package_delete.png" alt="uninstall" />';
            echo 'アンインストール</a>';
            echo '</td>';
            echo "</tr>\n";
            $installed_ContentType_name[] = $row['name'];
        }
        echo '</table>' . "\n";
        
        echo '<h3>未インストールのコンテンツタイプ</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";

        $ContentType_path = APP_PATH . 'models/CType/';
        $d = dir($ContentType_path);
        $i = 0;
        while (($entry = $d->read()) != FALSE) {
            if (!is_dir($ContentType_path . $entry)) {
                $ctype_filename = $entry;
                //echo $ctype_filename . "<br />\n";
                $pos = stripos($ctype_filename, '.php');
                $ctype_name = substr($ctype_filename, 0, $pos);
                if (!in_array($ctype_name, $installed_ContentType_name)) {
                
                    if ($i % 2 == 0) { echo '<tr class="even">'; }
                    else { echo '<tr class="odd">'; }
                    
                    require_once(APP_PATH . 'models/CType/' . $ctype_name . '.php');
                    $class_name = 'Platy_CType_' . $ctype_name;
                    $obj = new $class_name;
                    
                    echo '<td>' . $ctype_name . '</td>';
                    echo '<td>' . $obj->getSummary() . '</td>';
                    echo '<td>' . $obj->getVersion() . '</td>';
                    echo '<td>' . $obj->getAuthor() . '</td>';
                    echo '<td>';
                    echo '<a href="' . BASE_URL . 'Manage/Ctype/install/name/' . $ctype_name . '">';
                    echo '<img src="' . BASE_URL . 'media/system/package_add.png" alt="install" />';
                    echo 'インストール</a>';
                    echo '</td>';
                    echo '</tr>' . "\n";
                    $i++;
                }
            }
        }
        $d->close();
        echo '</table>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * コンテンツタイプの設定
     */
    public function configAction()
    {
    }
    
    /**
     * コンテンツタイプのインストール
     */
    public function installAction()
    {
        global $db;
        
        ob_start();
        
        echo 'Manage_ContentType:installAction()' . "<br />\n";
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        $sql = "SELECT * FROM Platy_ContentType WHERE name='" . $name . "'";
        $row = $db->fetchRow($sql);
        if ($row != NULL) {
            echo $name . 'はインストール済みです。' . "<br />\n";
        }
        else {
            require(APP_PATH . 'models/CType/' . $name . '.php');
            $classname = 'Platy_CType_' . $name;
            $obj = new $classname();
            if ($obj->install() == TRUE) {
                $sql = "INSERT INTO Platy_ContentType(name) VALUES('" . $name . "')";
                echo $sql . "<br />\n";
                $db->query($sql);
                echo $name . 'のインストールに成功しました。' . "<br />\n";
            }
            else {
                echo $name . 'のインストールに失敗しました。' . "<br />\n";
            }
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * コンテンツタイプのアンインストール
     */
    public function uninstallAction()
    {
        global $db;
        
        ob_start();
        
        echo 'Manage_ContentType:uninstallAction()' . "<br />\n";
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        require(APP_PATH . 'models/CType/' . $name . '.php');
        $classname = 'Platy_CType_' . $name;
        $obj = new $classname();
        if ($obj->uninstall() == TRUE) {
            $sql = "DELETE FROM Platy_ContentType WHERE name='" . $name . "'";
            $db->query($sql);
            echo $name . 'のアンインストールに成功しました。' . "<br />\n";
        }
        else {
            echo $name . 'のアンインストールに失敗しました。' . "<br />\n";
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    private function view() 
    {
        global $breadcrumb;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->breadcrumb = $breadcrumb->getContents();
        $view->contents = $this->contents;
        echo $view->render('page.php');
    }
}
?>