<?php
/**
 * カレンダークラス
 */
class Platy_Calendar
{
    public $ymd = '';
    public $events = array();
    
    /**
     * コンストラクタ
     */
    function __construct($ymd)
    {
        $this->ymd = $ymd;
    }
    
    /**
     * 年月日の設定
     */
    function setDate($ymd)
    {
        $this->ymd = $ymd;
    }
    
    /**
     * 年月を返す
     */
    function getDate()
    {
        return $this->ymd;
    }
    
    /**
     * カレンダーの表示
     */
    public function show()
    {
        $ym = '';
        if (strlen($this->ymd) == 8) {
            $ym = substr($this->ymd, 0, 6);
        }
        else if (strlen($this->ymd) == 6) {
            $ym = $this->ymd;
        }
        else {
            $ym = date('Ym');
        }
        
        $y = substr($ym,0,4);
        $m = substr($ym,4,2);
        
        $month_first_week = date("w", mktime(0, 0, 0, $m, 1, $y));  // 月の1日の曜日
        $month_days = date('t', mktime(0, 0, 0, $m, 1, $y));        // 月の日数
        
        $cal_col = 0;
        echo '<table class="calendar" width="100%"><tr>' . "\n";
        echo '<th></th>' . "\n";
        echo '<th colspan="5">' . $y . '-' . $m . '</th>' . "\n";
        echo '<th></th></tr>' . "\n";
        echo '<tr><td>日</td><td>月</td><td>火</td><td>水</td><td>木</td><td>金</td><td>土</td></tr>' . "\n";
        for ($i = 0; $i < $month_first_week; $i++) {
            echo '<td>&nbsp;</td>';
            $cal_col++;
        }
        $tmp_ym = $ym;
        $today = date('Ymd');
        
        for ($i = 1; $i <= $month_days; $i++) {
            if ($cal_col == 0) { echo '<tr>'; }
            $tmp_ymd = $tmp_ym . sprintf("%02d", $i);
            if ($tmp_ymd == $today) {
                echo '<td class="today">' . $i . '</td>';
            }
            else {
                echo '<td>' . $i . '</td>';
            }
            $cal_col++;
            if ($cal_col == 7) {
                echo '</tr>' . "\n";
                $cal_col = 0;
            }
        }
        if ($cal_col > 0) {
            for ($i = $cal_col; $i < 7; $i++) {
                echo '<td>&nbsp;</td>';
            }
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
    }
    
    /**
     * イベントの登録
     */
    public function addEvent($ymd, $url, $title = '')
    {
        $this->events[] = array('ymd' => $ymd, 'url' => $url, 'title' => $title);
    }
}
?>