/**
 * prototype.js Ń^u؂ւ
 * http://a-h.parfe.jp/einfach/archives/2006/1012175043.html
 */
Event.observe(window, 'load', function(){
  var start = new TabMaker();
  start.create();
});

var TabMaker = Class.create()
TabMaker.prototype = {
  initialize: function() {
    this.tabLnegth = document.getElementsByClassName('tab').length;
  },
  create: function() {
    var menu = new TabIndex();
    for (var i = 0; i < this.tabLnegth; i++) {
      menu.appendTab(new Tab('Tab' + i, (i==0)));
    }
    menu.setTab();
  }
}

var Tab = Class.create();
Tab.prototype = {
  initialize: function(name, open) {
    this.name = name;
    this.page = name + 'Page';
    this.open = (open);
  },
  styleTab: function() {
    if (this.open)
      this.setStyle('visible', '', 'open');
    else
      this.setStyle('hidden', 'absolute', 'close');
    this.open = false;
  },
  setStyle: function(visibility, position, className){
    var page = $(this.page).style;
    var name = $(this.name);
    page.visibility = visibility;
    page.position = position;
    name.className = className;
  }
}

var TabIndex = Class.create();
TabIndex.prototype = {
  initialize : function() {
    this.last = 0;
    this.tabs = new Array();
  },
  getTabAt : function(index) {
    return this.tabs[index];
  },
  appendTab : function(tab) {
    this.tabs[this.last] = tab;
    document.getElementsByClassName('tab')[this.last].id = tab.name;
    document.getElementsByClassName('tabBox')[this.last].id = tab.page;
    this.last++;
    $(tab.name).onclick = function(){
      tab.open = true;
      this.setTab();
    }.bind(this);
  },
  getLength : function() {
    return this.last;
  },
  each : function(func) {
    for (var i = 0; i < this.getLength(); i++) {
      func(this.getTabAt(i));
    }
  },
  setTab: function() {
    this.each(function(tab) {
        tab.styleTab();
    });
  }
};