<?php
/**
 * Shop Cart表示
 */
require_once 'Platy/Widget.php';

require_once(APP_PATH . 'models/ShopCart.php');

class Platy_Widget_ShopCart extends Platy_Widget
{
    public function install() { return true; }
    public function uninstall() { return true; }
    
    public function getSummary()
    {
        return 'ショッピングカート表示';
    }
    
    public function view()
    {
        global $db, $MyCart;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        $a['title'] = 'ショッピングカート';
        
        ob_start();
        
        $items = $MyCart->items();
        //var_dump($MyCart);
        
        $total = 0;
        for ($i = 0; $i < count($items); $i++) {
            $val = $items[$i];
            echo '<a href="' . BASE_URL . 'Shop/detailproduct/id/' . $val['productId'] . '">';
            echo '<img src="' . BASE_URL . 'media/Product/Thumbnail/' . $val['image'] . '">';
            echo $val['title'] . "<br />\n";
            echo '</a>';
            
            echo Platy_Util::cnv_currency($val['price']);
            echo 'x';
            echo $val['qty'];
            echo '=';
            $subtotal = $val['price'] * $val['qty'];
            $total += $subtotal;
            echo Platy_Util::cnv_currency($subtotal);
            echo '<br />' . "\n";
        }
        echo '合計:' . Platy_Util::cnv_currency($total) . "<br />\n";
        
        echo '<a href="' . BASE_URL . 'Shop/order/' . '">';
        echo 'レジに進む';
        echo '</a>';
        
        $a['main'] = ob_get_contents();
        ob_end_clean();
        
        return $a;
    }
}
?>