<?php
/**
 * 最近のエントリ
 */
require_once 'Platy/Widget.php';

define(MAX_ENTRY, 5);   // 表示件数

class Platy_Widget_RecentEntry extends Platy_Widget
{
    public function install() { return true; }
    public function uninstall() { return true; }

    public function getSummary()
    {
        return '最近のエントリを表示する';
    }
    
    public function view()
    {
        global $db;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        $a['title'] = '最近のエントリ';
        
        ob_start();
        echo '<a href="' . BASE_URL . 'Syndication/RecentEntry/">';
        echo '<image src="' . BASE_URL . 'media/system/feed.png" alt="feed" />';
        echo '</a>';
        $a['icons'] = ob_get_contents();
        ob_end_clean();
        
        ob_start();
        $sql = "SELECT id FROM Platy_Content_Base WHERE type != 'Folder' ORDER BY modified DESC";
        $rows = $db->fetchAll($sql);
        $n = MAX_ENTRY;
        if (count($rows) < MAX_ENTRY) { $n = count($rows); }
        
        echo '<ul>';
        $i = 0;
        foreach ($rows as $row) {
            $id = $row['id'];
            $content = getContentFromNodeId($id);
            if (checkPeriod($content['startDate'], $content['endDate']) == true) {
                echo '<li>';
                echo '<a href="' . BASE_URL . $content['url'] . '">';
                echo $content['title'];
                echo '&nbsp;(' . $content['modified'] . ')';
                echo '</a>';
                echo '</li>' . "\n";
                $i++;
                if ($i >= MAX_ENTRY) {
                    break;
                }
            }
        }
        
        echo '</ul>';
        $a['main'] = ob_get_contents();
        ob_end_clean();
        
        return $a;
    }
}
?>