<?php
/**
 * ノード ナビゲージョン 基本タイプ
 * Plone のナビゲーションを参考
 */
require_once 'Platy/Widget.php';

class Platy_Widget_NodeNav extends Platy_Widget
{
    private $show_n;        // フォルダ内のコンテンツ数を表示するか？
    private $show_icon;     // コンテンツタイプのアイコンを表示するか？
    
    private $currentPath;
    private $currentName;
    
    function __construct() {
        $this->show_n = true;
        $this->show_icon = true;
        $this->currentPath = '';
        $this->currentName = '';
    }
    
    public function install() {
        global $db;
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('W_NODENAV_CNUM', '0')";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('W_NODENAV_ICON', '1')";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    public function uninstall() {
        global $db;
        $sql[] = "DELETE FROM Platy_Config WHERE name='W_NODENAV_CNUM'";
        $sql[] = "DELETE FROM Platy_Config WHERE name='W_NODENAV_ICON'";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    public function getSummary()
    {
        return '基本タイプのノードナビゲーション';
    }
    
    public function view()
    {
        global $db, $config;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        ob_start();
        
        $tmp = substr($_SERVER['REQUEST_URI'], strlen(BASE_URL)-1);
        for ($i = strlen($tmp) - 1; $i >= 0; $i--) {
            if (substr($tmp, $i, 1) == '/') {
                break;
            }
        }
        $this->currentPath = substr($tmp, 0, $i + 1);
        $this->currentName = substr($tmp, $i + 1, strlen($tmp));
        //echo 'currentPath:' . $this->currentPath . "<br />\n";
        //echo 'currnetName:' . $this->currentName . "<br />\n";
        
        $parentId = 1;
        $id = parentId;
        
        echo '<ul>';
        echo '<li>';
        echo '<a href="' . BASE_URL . '"';
        if ($this->currentPath == '/' && $this->currentName == '') {
            echo ' class="selected"';
        }
        echo '>';
        if ($config['W_NODENAV_ICON'] == 1) {
            echo '<img src="' . BASE_URL . 'media/system/house.png' . '" class="icon_small" alt="home" />';
        }
        echo 'ホーム';
        if ($config['W_NODENAV_CNUM'] == 1) {
            $sql = "SELECT COUNT(*) FROM Platy_Content_Node n, Platy_Content_Base b WHERE parentId=0 AND b.type!='Folder' AND n.id=b.id";
            $row = $db->fetchRow($sql);
            echo '(' . $row['COUNT(*)'] . ')';
        }
        echo '</a>';
        echo '</li>' . "\n";


        if ($this->currentPath == '/' && $this->currentName != '') {
            $sql = "SELECT b.name, b.title FROM Platy_Content_Base b, Platy_Content_Node n WHERE b.type != 'Folder' AND n.parentId=0 AND b.id=n.id ORDER BY n.ordering";
            $rows = $db->fetchAll($sql);
            foreach ($rows as $row) {
                echo '<li>';
                echo '<a href="' . BASE_URL . $row['name'] . '"';
                if ($this->currentName == $row['name']) {
                    echo ' class="selected"';
                }
                echo '>';
                echo '&nbsp;&nbsp;';
                echo $row['title'];
                echo '</a>';
                echo '</li>';
            }
        }

        $path_array = array();
        $id = $parentId;
        $depth = 0;
        $this->getChildFolder($path_array, $id, $depth);
        
        echo '</ul>';
        
        $a['main'] = ob_get_contents();
        ob_end_clean();
        
        $a['title'] = 'ナビゲーション';
        
        return $a;
    }
    
    /**
     * 
     */
    private function getChildFolder(&$path_array, $id, &$depth)
    {
        global $db, $config;
        
        //echo "getChildNode";
        //var_dump($path_array);
        //echo "id=" . $id . ',';
        //echo "depth=" . $depth;
        //echo "<br />\n";
        
        $sql = "SELECT n.id, b.type, b.name, b.title, b.modified, b.status FROM Platy_Content_Node n, Platy_Content_Base b WHERE parentId={$id} AND b.type='Folder' AND n.id=b.id ORDER BY ordering";
        //echo 'SQL1=' . $sql . "<br />\n";
        $rows = $db->fetchAll($sql);
        
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            //var_dump($row);
            $id = $row['id'];
            $type = $row['type'];
            $name = $row['name'];
            $title = $row['title'];
            $modified = $row['modified'];
            $status = $row['status'];
            
            echo '<li>';
            
            $path = '';
            foreach ($path_array as $p) { $path .= $p . '/'; }
            
            echo '<a href="' . BASE_URL . $path . $name . '/"';
            
            $path_and_name = '/' . $path . $name . '/';
            if ($this->currentPath == $path_and_name && $this->currentName == '') {
                echo ' class="selected"';
            }
            echo '>';
            
            for ($k = 0; $k < $depth; $k++) { echo '&nbsp;&nbsp;'; }
            if ($config['W_NODENAV_ICON'] == 1) {
                echo '<img src="' . BASE_URL . 'media/system/Folder.png' . '" class="icon_small" alt="folder" />';
            }
            echo $title;
            if ($config['W_NODENAV_CNUM'] == 1) {
                $sql2 = "SELECT COUNT(*) FROM Platy_Content_Node n, Platy_Content_Base b WHERE parentId={$id} AND b.type!='Folder' AND n.id=b.id";
                //echo 'SQL2=' . $sql2 . "<br />\n";
                $row2 = $db->fetchRow($sql2);
                echo '(' . $row2['COUNT(*)'] . ')';
            }
            echo '</a>';
            echo '</li>' . "\n";
            
            if ($this->currentPath == $path_and_name && $this->currentName != '') {
                $sql3 = "SELECT b.name, b.title FROM Platy_Content_Base b, Platy_Content_Node n WHERE b.type != 'Folder' AND n.parentId={$id} AND b.id=n.id ORDER BY n.ordering";
                //echo 'SQL3=' . $sql3 . "<br />\n";
                //echo 'path_and_name=' . $path_and_name . "<br />\n";
                $rows3 = $db->fetchAll($sql3);
                foreach ($rows3 as $row3) {
                    echo '<li>';
                    echo '<a href="' . $path_and_name . $row3['name'] . '"';
                    if ($this->currentName == $row3['name']) {
                        echo ' class="selected"';
                    }
                    echo '>';
                    for ($k = 0; $k < $depth + 1; $k++) { echo '&nbsp;&nbsp;'; }
                    echo $row3['title'];
                    echo '</a>';
                    echo '</li>';
                }
            }

            $parentId = $id;
            $depth++;
            
            //echo "push<br />\n";
            array_push($path_array, $name);
            $this->getChildFolder($path_array, $parentId, $depth);
        }
        //echo "pop<br />\n";
        $depth--;
        array_pop($path_array);
    }
    
    public function config()
    {
        global $db, $config;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $config['W_NODENAV_CNUM'] = intval($_POST['cnum']);
            $config['W_NODENAV_ICON'] = intval($_POST['icon']);
            $sql[] = "UPDATE Platy_Config set value='" . $config['W_NODENAV_CNUM'] . "' WHERE name='W_NODENAV_CNUM'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['W_NODENAV_ICON'] . "' WHERE name='W_NODENAV_ICON'";
            for ($i = 0; $i < count($sql); $i++) {
                $db->query($sql[$i]);
            }
        }
        
        echo '<h2>NodeNav設定</h2>' . "\n";

        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        
        echo '<tr><th>フォルダ内コンテンツ数の表示</th><td>';
        echo '<input type="radio" name="cnum" VALUE="1"';
        if ($config['W_NODENAV_CNUM'] == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="cnum" VALUE="0"';
        if ($config['W_NODENAV_CNUM'] == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo '</td></tr>' . "\n";
        
        echo '<tr><th>アイコンの表示</th><td>';
        echo '<input type="radio" name="icon" VALUE="1"';
        if ($config['W_NODENAV_ICON'] == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="icon" VALUE="0"';
        if ($config['W_NODENAV_ICON'] == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo '</td></tr>' . "\n";
        
        echo '<tr><th></th><td>';
        echo '<input type="submit" value="設定を更新する" />';
        echo '</td></tr>' . "\n";
        
        echo '</table>' . "\n";
        echo '</form>' . "\n";
    }
}
?>