<?php
/**
 * Poll(投票) モジュール
 */
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';
require_once 'Platy/Module.php';
require_once 'Platy/SystemDB.php';
require_once 'Platy/Form.php';

class Platy_Module_Poll extends Platy_Module
{
    public function install()
    {
        global $db;
        $sql[] = "INSERT INTO Platy_Config(name,value) VALUES('M_POLL_INTERVAL_VOTING_BAN', '300');";
        $sql[] = "INSERT INTO Platy_Config(name,value) VALUES('M_POLL_GRAPHTYPE', 'BAR');";
        $sql[] = "CREATE TABLE Platy_Poll ("
               . "id                integer PRIMARY KEY,"
               . "title             varchar(255),"
               . "summary           text,"
               . "ordering          int DEFAULT 0,"
               . "created           datetime,"
               . "modified          datetime,"
               . "startDate         datetime,"
               . "endDate           datetime,"
               . "owner             int DEFAULT NULL);";
        $sql[] = "CREATE TABLE Platy_PollItem ("
               . "id                integer PRIMARY KEY,"
               . "pollId            integer NOT NULL,"
               . "title             varchar(255),"
               . "ordering          int DEFAULT 0,"
               . "votes             int DEFAULT 0);";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        // メニューアイテム追加
        $item = array('bar'=>'global', 'type'=>'module', 'title'=>'投票', 'module_name'=>'Poll', 'module_param' => '');
        addToMenu($item);
        
        return true;
    }
    
    public function uninstall()
    {
        global $db;
        $sql[] = "DELETE FROM Platy_Config WHERE name='M_POLL_INTERVAL_VOTING_BAN';";
        $sql[] = "DELETE FROM Platy_Config WHERE name='M_POLL_GRAPHTYPE';";
        $sql[] = "DROP TABLE Platy_Poll";
        $sql[] = "DROP TABLE Platy_PollItem";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    public function getName()
    {
        return 'Poll';
    }
    
    public function getTitle()
    {
        return '投票';
    }
    
    public function getSummary()
    {
        return '投票';
    }
    
    public function getAuthor()
    {
        return 'altkraft';
    }
}
?>