<?php
/**
 * Folder コンテンツタイプ
 */
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';
require_once 'Platy/CType.php';
require_once 'Platy/SystemDB.php';
require_once 'Platy/Form.php';

class DbContentFolder extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Content_Folder';
    }
}

class Platy_CType_Folder extends Platy_CType
{
    public $view_mode;
    public $ordering_mode;
    public $sidebarSetId;
    public $menuSetId;
    
    function __construct($id = 0) {
        global $db;
        
        parent::__construct($id);
        
        $this->view_mode = '';
        $this->ordering_mode = '';
        $this->sidebarSetId = 0;
        $this->menuSetId = 0;
        
        if ($id > 0) {
            $table = new DbContentFolder();
            $row = $table->fetchRow('id = ' . $id);
            $this->view_mode = $row->view_mode;
            $this->ordering_mode = $row->ordering_mode;
            $this->sidebarSetId = $row->sidebarSetId;
            $this->menuSetId = $row->menuSetId;
        }
    }
    
    public function install()
    {
        global $db;
        $sql = "CREATE TABLE Platy_Content_Folder ("
             . "id              integer PRIMARY KEY,"
             . "folder_mode     varchar(64) DEFAULT '',"
             . "view_mode       varchar(64) DEFAULT '',"
             . "ordering_mode   varchar(64) DEFAULT '',"
             . "sidebarSetId    integer DEFAULT 0,"
             . "menuSetId       integer DEFAULT 0"
             . ");";
        $result = $db->query($sql);
        return true;
    }
    
    public function uninstall()
    {
        global $db;
        $sql = "DROP TABLE Platy_Content_Folder";
        $result = $db->query($sql);
        return true;
    }
    
    private function validate(&$errors)
    {
        $errors = array();
        $title = $_POST['title'];
        if ($title == '') {
            $errors[] = "タイトルが未入力です";
        }
        if (!count($errors)) {
            return true;
        }
        return false;
    }
    
    private function showForm($p)
    {
        global $db;
?>
<form method="post" action="">
<table class="form_table">
<tr><th>name</th>
<td><input type="text" name="name" size="80" value="<?php echo $p['name'] ?>" /></td></tr>
<tr><th>タイトル</th>
<td><input type="text" name="title" size="80" value="<?php echo $p['title'] ?>" /></td></tr>
<tr><th>概要</th>
<td><?php Platy_Form::editor('summary', $p['summary']) ?></td></tr>
<tr><th>ステータス</th><td>
<?php Platy_Form::Manage_ContentStatus($this->id, $p['status']) ?>
</td></tr>
<tr><th>表示モード</th><td>
<select name="view_mode">
<option value="">親フォルダの設定を引き継ぐ</option>
<option value="summary">summary</option>
<option value="thumbnail">thumbnail</option>
</select>
</td></tr>

<tr><th>フォルダ内コンテンツの並び順</th><td>
<select name="ordering_mode">
<option value="">親フォルダの設定を引き継ぐ</option>
<option value="ordering">指定した並び順(ASC)</option>
<option value="time">更新日時順(ASC)</option>
<option value="time_desc">更新日時順(DESC)</option>
</select>
</td></tr>

<tr><th>sidebarSetId</th><td>
<select name="sidebarSetId">
<option value="0">親フォルダの設定を引き継ぐ</option>
<?php
$sql = "SELECT id, name FROM Platy_SidebarSet";
$rows = $db->fetchAll($sql);
foreach ($rows as $row) {
    echo '<option value="' . $row['id'] . '">' . $row['id'] . ':' . $row['name'] . '</option>' . "\n";
}
?>
</select>
</td></tr>
<tr><th>menuSetId</th><td>
<select name="menuSetId">
<option value="0">親フォルダの設定を引き継ぐ</option>
<?php
$sql = "SELECT id, name FROM Platy_MenuSet";
$rows = $db->fetchAll($sql);
foreach ($rows as $row) {
    echo '<option value="' . $row['id'] . '">' . $row['id'] . ':' . $row['name'] . '</option>' . "\n";
}
?>
</select>
</td></tr>

<tr><th></th><td>
<input type="hidden" name="ContentType" value="Folder" />
<input type="submit" name="submit_content" />
</td></th></table>
</form>
<?php
    }
    
    public function add()
    {
        $p['name'] = '';
        $p['title'] = '';
        $p['summary'] = '';
        
        echo '<h3>add Folder</h3>' . "\n";
        $this->showForm($p);
    }
    
    public function saveAdd($parentId)
    {
        global $db, $Me;
        
        $p['name'] = h($_POST['name']);
        $p['title'] = h($_POST['title']);
        //$p['summary'] = h($_POST['summary']);
        $p['summary'] = $_POST['summary'];
        $p['status'] = h($_POST['status']);
        $p['created'] = date('Y-m-d H:i:s');
        $p['modified'] = $p['created'];
        $p['view_mode'] = h($_POST['view_mode']);
        $p['ordering_mode'] = h($_POST['ordering_mode']);
        $p['sidebarSetId'] = intval($_POST['sidebarSetId']);
        $p['menuSetId'] = intval($_POST['menuSetId']);
        
        $errors = array();
        if ($this->validate($errors) == true) {
        
            $db->beginTransaction();
            
            try {
                // add to Content_Base
                $table = new DbContentBase();
                $data = array(
                    'name'    => $p['name'],
                    'type'    => 'Folder',
                    'title'   => $p['title'],
                    'summary' => $p['summary'],
                    'created' => $p['created'],
                    'modified' => $p['modified'],
                    'owner' => $Me->id,
                    'status' => $p['status']
                );
                //var_dump($data);
                $table->insert($data);
                
                $id = $db->lastInsertId();
                
                // もし$name==''ならば、$nameを{$id}に変更する
                if ($p['name'] == '') {
                    $c_name = $id;
                    $data = array('name' => $c_name);
                    $where = $table->getAdapter()->quoteInto('id = ?', $id);
                    $table->update($data, $where);
                }
                
                // add to Folder
                $table = new DbContentFolder();
                $data = array(
                    'id'            => $id,
                    'view_mode'     => $p['view_mode'],
                    'ordering_mode' => $p['ordering_mode'],
                    'sidebarSetId'  => $p['sidebarSetId'],
                    'menuSetId'     => $p['menuSetId']
                );
                var_dump($data);
                $table->insert($data);
                
                // add to Node
                $row = array (
                    'id'         => $id,
                    'parentId'   => $parentId
                );
                $table = 'Platy_Content_Node';
                $rows_affected = $db->insert($table, $row);
                
                $db->commit();
            }
            catch (Exception $e) {
                
                $profiler = $db->getProfiler();
                $query = $profiler->getLastQueryProfile();
                echo $query->getQuery();
                echo $e->getMessage();
                $db->rollBack();
            }
            return true;
        }
        else {
            echo '<h3>add Folder</h3>' . "\n";
            $error_msg = '';
            if (count($errors)) {
                $error_msg .= "<ul>\n";
                for ($i = 0; $i < count($errors); $i++) {
                    $error_msg .= '<li>' . $errors[$i] . '</li>' . "\n";
                }
                $error_msg .= "</ul>\n";
                MsgBox($error_msg, "", "WARNING");
            }
            $this->showForm($p);
        }
    }
    
    public function edit($nodeId)
    {
        $p['name'] = $this->name;
        $p['title'] = $this->title;
        $p['summary'] = $this->summary;
        $p['created'] = $this->created;
        $p['modified'] = $this->modified;
        
        $p['status'] = $this->status;
        $p['created'] = $this->created;
        $p['modified'] = $this->modified;
        $p['view_mode'] = $this->view_mode;
        $p['ordering_mode'] = $this->ordering_mode;
        $p['sidebarSetId'] = $this->sidebarSetId;
        $p['menuSetId'] = $this->menuSetId;
        
        echo '<h3>edit Folder</h3>' . "\n";
        $this->showForm($p);
    }
    
    public function saveEdit($nodeId)
    {
        global $db;
        
        $p['name'] = h($_POST['name']);
        $p['title'] = h($_POST['title']);
        //$p['summary'] = h($_POST['summary']);
        $p['summary'] = $_POST['summary'];
        $p['status'] = h($_POST['status']);
        $p['modified'] = date('Y-m-d H:i:s');
        
        $p['view_mode'] = h($_POST['view_mode']);
        $p['ordering_mode'] = h($_POST['ordering_mode']);
        $p['sidebarSetId'] = intval($_POST['sidebarSetId']);
        $p['menuSetId'] = intval($_POST['menuSetId']);
        
        $errors = array();
        if ($this->validate($errors) == true) {

            $db->beginTransaction();

            try {
                // update Content
                $table = new DbContentBase();
                
                if ($name == '') {
                    $name = $this->id;
                }
                
                $data = array(
                    'name'    => $p['name'],
                    'title'   => $p['title'],
                    'summary' => $p['summary'],
                    'modified' => $p['modified'],
                    'status' => $p['status']
                );
                //var_dump($data);
                $where = $table->getAdapter()->quoteInto('id = ?', $this->id);
                $table->update($data, $where);
                
                // update Folder
                $table = new DbContentFolder();
                $data = array(
                    'view_mode'     => $p['view_mode'],
                    'ordering_mode' => $p['ordering_mode'],
                    'sidebarSetId'  => $p['sidebarSetId'],
                    'menuSetId'     => $p['menuSetId']
                );
                //var_dump($data);
                $where = $table->getAdapter()->quoteInto('id = ?', $this->id);
                $table->update($data, $where);
                
                $db->commit();
            }
            catch (Exception $e) {
                echo $e->getMessage();
                $db->rollBack();
            }
            return true;
        }
        else {
            echo '<h3>edit Folder</h3>' . "\n";
            $error_msg = '';
            if (count($errors)) {
                $error_msg .= "<ul>\n";
                for ($i = 0; $i < count($errors); $i++) {
                    $error_msg .= '<li>' . $errors[$i] . '</li>' . "\n";
                }
                $error_msg .= "</ul>\n";
                MsgBox($error_msg, "", "WARNING");
            }
            $this->showForm($p);
        }
    }
    
    public function delete($id)
    {
        global $db;
        if (1) {
            $sql = "DELETE FROM Platy_Content_Folder WHERE id={$this->id}";
            $db->query($sql);
        }
        return true;
    }
    
    public function view() {
        global $manager;
        
        $a = array('pre'=>'', 'post'=>'', 'title'=> '', 'icons'=>'', 'main'=>'', 'header'=>'', 'footer'=>'');
        
        $link = getURLFromId($this->id);
        
        $a['title'] = '<a href="' . $link . '/">' . $this->title .'</a>';
        
        return $a;
    }
    
    public function browse() {
        global $manager, $config;
        
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>id</th><td>';
        echo $this->id;
        echo '</td></tr>' . "\n";
        echo '<tr><th>name</th><td>';
        echo $this->name;
        echo '</td></tr>' . "\n";
        echo '<tr><th>title</th><td>';
        echo $this->title;
        echo '</td></tr>' . "\n";
        echo '<tr><th>summary</th><td>';
        echo $this->summary;
        echo '</td></tr>' . "\n";
        echo '<tr><th>description</th><td>';
        echo $this->description;
        echo '</td></tr>' . "\n";
        echo '<tr><th>created</th><td>';
        echo $this->created;
        echo '</td></tr>' . "\n";
        echo '<tr><th>modified</th><td>';
        echo $this->modified;
        echo '</td></tr>' . "\n";
        echo '<tr><th>owner</th><td>';
        echo Platy_Util::getUsername($this->owner);
        echo '</td></tr>' . "\n";
        echo '<tr><th>status</th><td>';
        echo $this->status;
        echo '</td></tr>' . "\n";
        echo '</table>' . "\n";
        
        echo '<p><a href="javascript:history.back()">前のページにもどる</a></p>' . "\n";
    }
}
?>