<?php
/**
 * サイトマップ モジュール (dtree対応版)
 * 
 */
require_once 'Zend/Controller/Action.php';

class SitemapController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $manager, $breadcrumb;
        
        $manager->module = 'Sitemap';
        $breadcrumb->add('ホーム', BASE_URL);
        $breadcrumb->add('サイトマップ', BASE_URL . 'Sitemap/');
    }
    
    public function indexAction()
    {
        global $config, $breadcrumb, $db, $js_helper, $css_helper;
        
        $js_helper->addFile(BASE_URL . 'libs/dtree/dtree.js');
        $css_helper->addFile(BASE_URL . 'libs/dtree/dtree.css');
        
        ob_start();
        
        //echo 'SitemapController:indexAction';
        
        echo '<h2>サイトマップ</h2>' . "\n";
        
        echo '<div class="dtree">' . "\n";
        
        echo '<p><a href="javascript: d.openAll();">open all</a> | <a href="javascript: d.closeAll();">close all</a></p>' . "\n";
        
        echo '<script type="text/javascript">' . "\n";
        echo '<!--' . "\n";
        
        echo "d = new dTree('d');" . "\n";
        echo "d.setImgUrl('" . BASE_URL . 'libs/dtree/img/' . "');" . "\n";
        echo "d.add(0,-1,'" . $config['S_SITE_NAME'] . "');" . "\n";
        //echo "d.add(1,0,'Node 1','example01.html');" . "\n";
        //echo "d.add(2,0,'Node 2','example01.html');" . "\n";
        //echo "d.add(3,1,'Node 1.1','example01.html');" . "\n";
        
        $this->r();
        
        if ($config['M_SITEMAP_MODULE']) {
            // モジュール表示
            //echo "Modules<br />\n";
            $sql = "SELECT name, title FROM Platy_Module";
            $rows = $db->fetchAll($sql);
            
            $pid = 0;
            $id = 100000;
            for ($i = 0; $i < count($rows); $i++) {
                $row = $rows[$i];
                //echo '<a href="' . BASE_URL . $row['name'] . '/">';
                //echo $row['title'];
                //echo '</a><br />' . "\n";
                $title = $row['title'];
                $url = BASE_URL . $row['name'] . "/";
                echo "d.add(" . $id . "," . $pid . ",'" . $title . "','" . $url . "');" . "\n";
                $id++;
            }
            
        }
        
        echo 'document.write(d);' . "\n";
        echo 'd.openAll();' . "\n";
        
        echo '//-->' . "\n";
        echo '</script>' . "\n";
        echo '</div><!-- /dtree -->' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        //echo $contents;

        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->contents = $contents;
        $view->config = $config;
        $view->breadcrumb = $breadcrumb->getContents();
        $view->sidebar = buildSidebar();
        $view->js_files = $js_helper->listFiles();
        $view->css_files = $css_helper->listFiles();
        echo $view->render('page.php');
    }
    
    /**
     * Google Sitemap
     */
    public function googlesitmapAction()
    {
        $cache_time = 3600;     // キャッシュ時間(秒)
        
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * 
     */
    private function getChildNode(&$path_array, $id, &$depth)
    {
        global $db;
        
        //echo "getChildNode";
        //var_dump($path_array);
        //echo "id=" . $id . ',';
        //echo "depth=" . $depth;
        //echo "<br />\n";
        
        $sql = "SELECT n.id, b.type, b.name, b.title, b.modified, b.status, b.startDate, b.endDate FROM Platy_Content_Node n, Platy_Content_Base b WHERE n.id=b.id AND parentId={$id} AND b.status='public' ORDER BY ordering";
        $rows = $db->fetchAll($sql);
        
        $pid = $id;
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            $id = $row['id'];
            $type = $row['type'];
            $name = $row['name'];
            $title = $row['title'];
            $modified = $row['modified'];
            $status = $row['status'];
            $startDate = $row['startDate'];
            $endDate = $row['endDate'];
            if (Platy_Util::checkPeriod($startDate, $endDate) == false) {
                continue;
            }
            
            if ($type == 'Folder') {
                //for ($k = 0; $k < $depth; $k++) { echo '&nbsp;&nbsp;&nbsp;&nbsp;'; }
                
                $path = '';
                foreach ($path_array as $p) { $path .= $p . '/'; }
                $path_name = $path . $name . '/';
                $path_name = substr($path_name, 5);
                //echo '<a href="' . BASE_URL . $path_name . '">';
                //echo $title;
                //echo '</a>';
                //echo "<br />\n";
                $url = BASE_URL . $path_name;
                
                if ($pid == 1) { $pid = 0; }
                if ($id != 1) {
                    echo "d.add(" . $id . "," . $pid . ",'" . $title . "','" . $url . "');" . "\n";
                }
                $parentId = $id;
                $depth++;
                
                //echo "push<br />\n";
                array_push($path_array, $name);
                $this->getChildNode($path_array, $parentId, $depth);
            }
            else {  // not Folder
                //for ($k = 0; $k < $depth; $k++) { echo '&nbsp;&nbsp;&nbsp;&nbsp;'; }
                
                $path = '';
                foreach ($path_array as $p) { $path .= ($p . '/'); }
                $path_name = $path . $name;
                $path_name = substr($path_name, 5);
                //echo '<a href="' . BASE_URL . $path_name . '">';
                //echo $title;
                //echo '</a>';
                //echo "<br />\n";
                $url = BASE_URL . $path_name;
                
                if ($pid == 1) { $pid = 0; }
                echo "d.add(" . $id . "," . $pid . ",'" . $title . "','" . $url . "');" . "\n";
            }
        }
        //echo "pop<br />\n";
        $depth--;
        array_pop($path_array);
    }
    
    /**
     * 再帰表示
     */
    public function r()
    {
        $path_array = array();
        $id = 0;
        $depth = 0;
        $this->getChildNode($path_array, $id, $depth);
    }
}
?>