<?php
/**
 * 不動産検索 モジュール
 * 
 */
require_once 'Platy/Form.php';
require_once 'Platy/Util.php';

require_once 'Zend/Controller/Action.php';
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';

class DbRealestateItem extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Realestate_Item';
    }
}

class RealestateController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $manage, $breadcrumb;
        
        $manage->module = 'Realestate';
        $breadcrumb->add('ホーム', BASE_URL);
        $breadcrumb->add('不動産情報', BASE_URL . 'Realestate/');
    }
    
    public function indexAction()
    {
        $this->_redirect('Realestate/search/');
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * 物件の検索
     */
    public function searchAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>物件の検索</h2>' . "\n";
        echo '<a href="' . BASE_URL . 'Realestate/listLease/' . '">賃貸物件</a>' . "<br />\n";
        echo '<a href="' . BASE_URL . 'Realestate/listSelling/' . '">販売物件</a>' . "<br />\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH .'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('module.php');
    }
    
    /**
     * 賃貸物件一覧
     */
    public function listLeaseAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>賃貸物件一覧</h2>' . "\n";
        
        $sql = "SELECT id, category, name, address, station, bus, price"
             . ", kanri, shikikin, reikin, senyu_menseki"
             . ", madori, madori_desc, completion, structure, rooms, kaiken"
             . ", muki, parking, condition, equipment, note"
             . ", kenpei, youseki, shikichi_menseki, tatemono_menseki"
             . ", img_madori, img_gaikan"
             . ", created, modified, status"
             . " FROM Platy_Realestate_Item"
             . " WHERE category = 1 OR category = 2 "
             . "ORDER BY modified DESC";
        
        $rows = $db->fetchAll($sql);
        
        echo '<table class="list_table">';
        echo '<th>id</th><th>名称</th><th>住所</th><th>賃料/共益費</th><th>敷金/礼金</th><th>間取/占有面積</th><th></th>';

        foreach ($rows as $row) {
            //var_dump($row);
            
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['name'] . '</td>';
            echo '<td>' . $row['address'] . '</td>';
            echo '<td>' . Platy_Util::cnv_currency($row['price']) . '/' . Platy_Util::cnv_currency($row['kanri']) . '</td>';
            echo '<td>' . $row['shikikin'] . 'ヶ月/' . $row['reikin'] . 'ヶ月</td>';
            echo '<td>' . $row['madori'] . '/' . $row['senyu_menseki'] . '㎡</td>';

            echo '<td>';
            echo '<a href="' . BASE_URL . 'Realestate/detail/id/' . $row['id'] . '">詳細</a>' . '</td>';
            echo '</tr>';

            //echo $row['id'] . $row['category'] . $row['name'] . "<br />\n";
            //echo '<img src="' . BASE_URL . 'media/Realestate/' . $row['img_madori'] . '">';
        }
        echo '</table>';
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH .'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('module.php');
    }
    
    /**
     * 販売物件一覧
     */
    public function listSellingAction()
    {
    }
    
    /**
     * 物件詳細
     */
    public function detailAction()
    {
        global $db, $config;
        
        // id/[id]
        $request = $this->getRequest();
        $id = $request->getParam('id');
        
        ob_start();
        
        $sql = "SELECT id, category, name, address, station, bus, price"
             . ", kanri, shikikin, reikin, senyu_menseki"
             . ", madori, madori_desc, completion, structure, rooms, kaiken"
             . ", muki, parking, condition, equipment, note"
             . ", kenpei, youseki, shikichi_menseki, tatemono_menseki"
             . ", img_madori, img_gaikan"
             . ", created, modified, status"
             . " FROM Platy_Realestate_Item"
             . " WHERE id ={$id}";
        $row = $db->fetchRow($sql);
        echo '<table width="100%">';
        echo '<tr><td width="200px" valign="top">';
        echo "概観図<br />";
        echo '<img src="' . BASE_URL . 'media/Realestate/' . $row['img_gaikan'] . '">' . "<br />\n";
        echo "間取り図<br />";
        echo '<img src="' . BASE_URL . 'media/Realestate/' . $row['img_madori'] . '">' . "<br />\n";
        echo '</td><td valign="top">';
        
        echo '<table class="form_table">';
        echo '<tr><th>Id:</th><td>' . $row['id'] . '</td></tr>';
        echo '<tr><th>名称:</th><td>' . $row['name'] . '</td></tr>';
        echo '<tr><th>住所:</th><td>' . $row['address'] . '</td></tr>';
        echo '<tr><th>交通:</th><td>' . $row['station'] . '<br />' . $row['bus'] . '</td></tr>';

        echo '<tr><th>賃料/共益費:</th><td>' . Platy_Util::cnv_currency($row['price']) . '/' . Platy_Util::cnv_currency($row['kanri']) . '</td></tr>';
        echo '<tr><th>敷金/礼金:</th><td>' . $row['shikikin'] . 'ヶ月 /' . $row['reikin'] . 'ヶ月</td></tr>';
        echo '<tr><th>間取り:</th><td>' . $row['madori'] . '<br />' . $row['madori_desc'] . '</td></tr>';
        echo '<tr><th>築年月:</th><td>' . $row['completion'] . '</td></tr>';
        echo '<tr><th>構造:</th><td>' . $row['structure'] . '</td></tr>';
        echo '<tr><th>向き:</th><td>' . $row['muki'] . '</td></tr>';
        echo '<tr><th>階建:</th><td>' . $row['kaiken'] . '</td></tr>';
        echo '<tr><th>駐車場:</th><td>' . $row['parking'] . '</td></tr>';
        echo '<tr><th>条件:</th><td>' . $row['condition'] . '</td></tr>';
        echo '<tr><th>設備:</th><td>' . $row['equipment'] . '</td></tr>';
        echo '<tr><th>その他:</th><td>' . $row['note'] . '</td></tr>';

        echo '</table>';
        
        echo '</td></tr></table>';
        
        echo '<a href="javascript:history.back()">前へ戻る</a>' . "<br />\n";
        
        //var_dump($row);

        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH .'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('module.php');
    }
}
?>