<?php
/**
 * システム情報
 */
require_once 'Zend/Controller/Action.php';
require_once 'Zend/Version.php';

require_once 'Platy/Version.php';

class Manage_SystemController extends Zend_Controller_Action
{
    private $contents;
    
    public function preDispatch()
    {
        global $Me, $currentManage, $breadcrumb;
        
        if ($Me->isAllowed('Access_Backend') == false) {
            $this->_redirect('/Manage/Login/');
        }
        $currentManage = 'System';
        $breadcrumb->add('管理', BASE_URL . 'Manage/');
        $breadcrumb->add('システム情報', BASE_URL . 'Manage/System/');
    }
    
    public function indexAction()
    {
        global $db, $config;
        
        $ok_icon = '<img src="' . BASE_URL . 'media/system/agt_action_success.png">';
        $ng_icon = '<img src="' . BASE_URL . 'media/system/exclamation.png">';
        
        ob_start();
        
        echo '<h2>システム情報</h2>' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>PHP</th><td>';
        echo phpversion();
        echo '</td></tr>' . "\n";
        echo '<tr><th>Zend Framework</th><td>';
        echo Zend_Version::VERSION;
        echo '</td></tr>' . "\n";
        echo '<tr><th>Platy</th><td>';
        echo Platy_Version::VERSION;
        echo '</td></tr>' . "\n";
        
        echo '<tr><th>apache modules</th><td>';
        // Apacheモジュール
        $apache_modules = apache_get_modules();
        //print_r($apache_modules);
        
        // mod_rewrite
        if (in_array('mod_rewrite', $apache_modules)) { echo $ok_icon; } else { echo $ng_icon; }
        echo 'mod_rewrite' . "<br />\n";
        
        echo '</td></tr>' . "\n";
        
        echo '<tr><th>PHP extensions</th><td>';
        // PHP拡張モジュール
        $extensions = get_loaded_extensions();
        //print_r($extensions);
        
        // mbstring
        if (in_array('mbstring', $extensions)) { echo $ok_icon; } else { echo $ng_icon; }
        echo 'mbstring' . "<br />\n";

        // PDO
        if (in_array('PDO', $extensions)) { echo $ok_icon; } else { echo $ng_icon; }
        echo 'PDO' . "<br />\n";

        // SQLite
        if (in_array('SQLite', $extensions)) { echo $ok_icon; } else { echo $ng_icon; }
        echo 'SQLite' . "<br />\n";

        // pdo_sqlite
        if (in_array('pdo_sqlite', $extensions)) { echo $ok_icon; } else { echo $ng_icon; }
        echo 'pdo_sqlite' . "<br />\n";

        echo '</td></tr>';
        echo '</table>' . "\n";
        
        echo '<h2>PHP情報</h2>' . "\n";
        
        echo '<iframe src="' . BASE_URL . 'Manage/System/phpinfo/' . '" height="400px" width="100%">' . "\n";
        echo '</iframe>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    public function phpinfoAction()
    {
        phpinfo();
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * 表示
     */
    private function view()
    {
        global $breadcrumb;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $this->contents;
        $view->breadcrumb = $breadcrumb->getContents();
        //$view->sidebar = $this->buildSidebar();
        echo $view->render('page.php');
    }
}
?>