<?php
/**
 * 不動産モジュールの管理
 */
require_once 'Platy/Form.php';
require_once 'Platy/Util.php';

require_once 'Zend/Controller/Action.php';
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';

class DbRealestateItem extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Realestate_Item';
    }
}

class Manage_RealestateController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $Me;
        if ($Me->isAdmin() == false) {
            $this->_redirect('/Manage/Login/');
        }
    }
    
    public function indexAction()
    {
        $this->listItemAction();
    }
    
    /**
     * 物件一覧
     */
    public function listItemAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>物件一覧</h2>' . "\n";
        
        echo '<form method="post" action="' . BASE_URL . 'Manage/Realestate/addItem/">' . "<br />\n";
        echo '<select name="category">' . "\n";
        echo '<option value="1">アパート</option>' . "\n";
        echo '<option value="2">賃貸マンション</option>' . "\n";
        echo '<option value="11">新築一戸建て</option>' . "\n";
        echo '<option value="12">中古一戸建て</option>' . "\n";
        echo '</select>' . "\n";
        echo '<input type="submit" value="物件を追加する" />' . "\n";
        echo '</form>' . "\n";
        
        $sql = "SELECT id, category, name, address, modified FROM Platy_Realestate_Item";
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">' . "\n";
        echo '<tr><th>id</th><th>カテゴリ</th><th>名称</th><th>住所</th><th>更新日時</th><th>action</th></tr>' . "\n";
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>';
            $category = $row['category'];
            switch ($category) {
            case 1:
                echo 'アパート';
                break;
            case 2:
                echo '賃貸マンション';
                break;
            case 11:
                echo '新築一戸建て';
                break;
            case 12:
                echo '中古一戸建て';
                break;
            }
            echo '</td>';
            echo '<td>' . $row['name'] . '</td>';
            echo '<td>' . $row['address'] . '</td>';
            echo '<td>' . $row['modified'] . '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Realestate/editItem/id/' . $row['id'] . '">edit</a>';
            echo '<a href="' . BASE_URL . 'Manage/Realestate/deleteItem/id/' . $row['id'] . '">delete</a>';
            echo '</td>';
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    /**
     * 物件入力のチェック
     */
    public function validateRealestateItem()
    {
        return true;
    }
    
    /**
     * 物件の登録
     */
    public function addItemAction()
    {
        global $db, $config;
        
        $category = intval($_POST['category']);

        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['submit_item'])) {
            
            $name = h($_POST['name']);
            $address = h($_POST['address']);
            $station = h($_POST['station']);
            $bus = h($_POST['bus']);
            $price = intval($_POST['price']);
            if ($category == 1 || $category == 2) {
                $kanri = intval($_POST['kanri']);
                $shikikin = floatval($_POST['shikikin']);
                $reikin = floatval($_POST['reikin']);
                $senyu_menseki = floatval($_POST['senyu_menseki']);
            }
            $madori = h($_POST['madori']);
            $madori_desc = h($_POST['madori_desc']);
            $completion = h($_POST['completion']);
            $structure = h($_POST['structure']);
            $rooms = intval($_POST['rooms']);
            $kaiken = h($_POST['kaiken']);
            $muki = h($_POST['muki']);
            $parking = h($_POST['parking']);
            $condition = h($_POST['condition']);
            $equipment = h($_POST['equipment']);
            $note = h($_POST['note']);
            if ($category == 11 || $category == 12) {
                $kenpei = intval($_POST['kenpei']);
                $youseki = intval($_POST['youseki']);
                $shikichi_menseki = floatval($_POST['shikichi_menseki']);
                $tatemono_menseki = floatval($_POST['tatemono_menseki']);
            }
            $modified = date('Y-m-d H:i:s');
            
            // 画像アップロード
            $uploaddir = BASE_PATH . 'media/Realestate/';
            $uploadfile = $uploaddir . basename($_FILES['madori']['name']);
            if (move_uploaded_file($_FILES['madori']['tmp_name'], $uploadfile)) {
                echo "File is valid, and was successfully uploaded.\n";
            } else {
                echo "Possible file upload attack!\n";
            }
            $uploadfile = $uploaddir . basename($_FILES['gaikan']['name']);
            if (move_uploaded_file($_FILES['gaikan']['tmp_name'], $uploadfile)) {
                echo "File is valid, and was successfully uploaded.\n";
            } else {
                echo "Possible file upload attack!\n";
            }
            $img_madori = basename($_FILES['madori']['name']);
            $img_gaikan = basename($_FILES['gaikan']['name']);
            
            if ($this->validateRealestateItem() == true) {
                $table = new DbRealestateItem();
                $data['category'] = $category;
                $data['name'] =  $name;
                $data['address'] = $address;
                $data['station'] = $station;
                $data['bus'] = $bus;
                $data['price'] = $price;
                if ($category == 1 || $category == 2) {
                    $data['kanri'] = $kanri;
                    $data['shikikin'] = $shikikin;
                    $data['reikin'] = $reikin;
                    $data['senyu_menseki'] = $senyu_menseki;
                }
                $data['madori'] = $madori;
                $data['madori_desc'] = $madori_desc;
                $data['completion'] = $completion;
                $data['structure'] = $structure;
                $data['rooms'] = $rooms;
                $data['kaiken'] = $kaiken;
                $data['muki'] = $muki;
                $data['parking'] = $parking;
                $data['condition'] = $condition;
                $data['equipment'] = $equipment;
                $data['note'] = $note;
                $data['img_madori'] = $img_madori;
                $data['img_gaikan'] = $img_gaikan;
                if ($category == 11 || $category == 12) {
                    $data['kenpei'] = $kenpei;
                    $data['youseki'] = $youseki;
                    $data['shikichi_menseki'] = $shikichi_menseki;
                    $data['tatemono_menseki'] = $tatemono_menseki;
                }
                $created = date('Y-m-d H:i:s');
                $modified = $created;
                
                $table->insert($data);
                
                $this->_redirect('/Manage/Realestate/listItem/');
            }
        }
        else {
            
        }
        
        ob_start();
        
        echo '<h2>物件登録</h2>' . "\n";
?>
<form method="post" action="" enctype="multipart/form-data">
<table class="form_table">
<tr><th>カテゴリ:</th><td>
<?php
switch ($category) {
case 1: echo 'アパート'; break;
case 2: echo '賃貸マンション'; break;
case 11: echo '新築一戸建て'; break;
case 12: echo '中古一戸建て'; break;
}
?>
</td></tr>
<tr><th>物件名称:</th><td>
<input type="text" name="name" value="<?php echo $name ?>" size="80"/></td></tr>
<tr><th>所在地:</th><td>
<input type="text" name="address" value="<?php echo $address ?>" size="80"/></td></tr>
<tr><th>沿線/最寄り駅:</th><td>
<input type="text" name="station" value="<?php echo $station ?>" size="80"/></td></tr>
<tr><th>バス/徒歩:</th><td>
<input type="text" name="bus" value="<?php echo $bus ?>" size="80"/></td></tr>
<?php if ($category == 1 || $categoty == 2) { ?>
<tr><th></th><td>
賃料:<input type="text" name="price" value="<?php echo $price ?>" size="20"/>&nbsp;
管理・共益費:<input type="text" name="kanri" value="<?php echo $kanri ?>" size="20"/></td></tr>
<tr><th></th><td>
敷金:<input type="text" name="shikikin" value="<?php echo $shikikin ?>" size="20"/>&nbsp;
礼金:<input type="text" name="reikin" value="<?php echo $reikin ?>" size="20"/></td></tr>
<tr><th>占有面積:</th><td>
<input type="text" name="senyu_menseki" value="<?php echo $senyu_menseki ?>" size="20"/></td></tr>
<?php } ?>
<?php if ($category == 11 || $category == 12) { ?>
<tr><th>価格</th><td>
<input type="text" name="price" value="<?php echo $price ?>" size="20"/></td></tr>
<?php } ?>

<tr><th>築年月</th><td>
<input type="text" name="completion" value="<?php echo $completion ?>" size="20"/></td></tr>

<tr><th></th><td>
階建/階:<input type="text" name="kaiken" value="<?php echo $kaiken ?>" size="20"/>&nbsp;
部屋向き:<input type="text" name="muki" value="<?php echo $muki ?>" size="20"/></td></tr>

<tr><th>構造:</th><td>
<input type="text" name="structure" value="<?php echo $structure ?>" size="60"/></td></tr>

<tr><th></th><td>
間取り:<input type="text" name="madori" value="<?php echo $madori ?>" size="60"/><br />
間取り詳細:<input type="text" name="madori_desc" value="<?php echo $madori_desc ?>" size="60"/></td></tr>

<tr><th>駐車場:</th><td>
<input type="text" name="parking" value="<?php echo $parking ?>" size="80"/></td></tr>

<tr><th>条件等:</th><td>
<textarea name="condition" rows="2" cols="60"><?php echo $condition ?></textarea></td></tr>
<tr><th>設備:</th><td>
<textarea name="equipment" rows="2" cols="60"><?php echo $equipment ?></textarea></td></tr>
<tr><th>その他:</th><td>
<textarea name="note" rows="2" cols="60"><?php echo $note ?></textarea></td></tr>

<tr><th>間取り図:</th><td>
<input type="file" name="madori" value="<?php echo $img_madori ?>" size="80"/></td></tr>
<tr><th>概観図:</th><td>
<input type="file" name="gaikan" value="<?php echo $img_gaikan ?>" size="80"/></td></tr>

<?php if ($category == 11 || $category == 12) { ?>
<tr><th></th><td>
建ぺい率:<input type="text" name="kenpei" value="<?php echo $kenpei ?>" size="20"/>&nbsp;
容積率:<input type="text" name="youseki" value="<?php echo $youseki ?>" size="20"/></td></tr>
<tr><th></th><td>
敷地面積:<input type="text" name="shikichi_menseki" value="<?php echo $shikichi_menseki ?>" size="20"/>&nbsp;
建物面積:<input type="text" name="tatemono_menseki" value="<?php echo $tatemono_menseki ?>" size="20"/></td></tr>
<?php } ?>
<tr><th></th><td>
<input type="hidden" name="category" value="<? echo $category ?>" />
<input type="hidden" name="submit_item" value="1" />
<input type="submit" value="物件を登録する" /></td></tr>
</table>
</form>

<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    /**
     * 物件の編集
     */
    public function editItemAction()
    {
        global $db, $config;
        
        // id/[id]
        $request = $this->getRequest();
        $id = $request->getParam('id');

        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['submit_item'])) {

            $name = h($_POST['name']);
            $address = h($_POST['address']);
            $station = h($_POST['station']);
            $bus = h($_POST['bus']);
            $price = intval($_POST['price']);
            if ($category == 1 || $category == 2) {
                $kanri = intval($_POST['kanri']);
                $shikikin = floatval($_POST['shikikin']);
                $reikin = floatval($_POST['reikin']);
                $senyu_menseki = floatval($_POST['senyu_menseki']);
            }
            $madori = h($_POST['madori']);
            $madori_desc = h($_POST['madori_desc']);
            $completion = h($_POST['completion']);
            $structure = h($_POST['structure']);
            $rooms = intval($_POST['rooms']);
            $kaiken = h($_POST['kaiken']);
            $muki = h($_POST['muki']);
            $parking = h($_POST['parking']);
            $condition = h($_POST['condition']);
            $equipment = h($_POST['equipment']);
            $note = h($_POST['note']);
            if ($category == 11 || $category == 12) {
                $kenpei = intval($_POST['kenpei']);
                $youseki = intval($_POST['youseki']);
                $shikichi_menseki = floatval($_POST['shikichi_menseki']);
                $tatemono_menseki = floatval($_POST['tatemono_menseki']);
            }
            $modified = date('Y-m-d H:i:s');
            
            // 画像アップロード
            $uploaddir = BASE_PATH . 'media/Realestate/';
            if (strlen($_FILES['madori']['name'])) {
                // すでに画像が設定されている場合は、それを削除する
                // TODO
                $uploadfile = $uploaddir . basename($_FILES['madori']['name']);
                if (move_uploaded_file($_FILES['madori']['tmp_name'], $uploadfile)) {
                    echo "File is valid, and was successfully uploaded.\n";
                } else {
                    echo "Possible file upload attack!\n";
                }
            }
            if (strlen($_FILES['gaikan']['name'])) {
                // すでに画像が設定されている場合は、それを削除する
                // TODO
                $uploadfile = $uploaddir . basename($_FILES['gaikan']['name']);
                if (move_uploaded_file($_FILES['gaikan']['tmp_name'], $uploadfile)) {
                    echo "File is valid, and was successfully uploaded.\n";
                } else {
                    echo "Possible file upload attack!\n";
                }
            }
            $img_madori = basename($_FILES['madori']['name']);
            $img_gaikan = basename($_FILES['gaikan']['name']);
            //echo $img_madori;
            //echo $img_gaikan;
            
            if ($this->validateRealestateItem() == true) {
                $table = new DbRealestateItem();
                //$data['category'] = $category;
                $data['name'] =  $name;
                $data['address'] = $address;
                $data['station'] = $station;
                $data['bus'] = $bus;
                $data['price'] = $price;
                if ($category == 1 || $category == 2) {
                    $data['kanri'] = $kanri;
                    $data['shikikin'] = $shikikin;
                    $data['reikin'] = $reikin;
                    $data['senyu_menseki'] = $senyu_menseki;
                }
                $data['madori'] = $madori;
                $data['madori_desc'] = $madori_desc;
                $data['completion'] = $completion;
                $data['structure'] = $structure;
                $data['rooms'] = $rooms;
                $data['kaiken'] = $kaiken;
                $data['muki'] = $muki;
                $data['parking'] = $parking;
                $data['condition'] = $condition;
                $data['equipment'] = $equipment;
                $data['note'] = $note;
                if (strlen($img_madori)) {
                    echo 'aaaa';
                    $data['img_madori'] = $img_madori;
                }
                if (strlen($img_gaiken)) {
                    $data['img_gaikan'] = $img_gaikan;
                }
                if ($category == 11 || $category == 12) {
                    $data['kenpei'] = $kenpei;
                    $data['youseki'] = $youseki;
                    $data['shikichi_menseki'] = $shikichi_menseki;
                    $data['tatemono_menseki'] = $tatemono_menseki;
                }
                $modified = date('Y-m-d H:i:s');
                
                $where = $table->getAdapter()->quoteInto('id = ?', $id);
                $table->update($data, $where);
                
                //$this->_redirect('/Manage/Realestate/listItem/');
            }
        }
        else {
            $sql = "SELECT category, name, address, station, bus, price"
                 . ", kanri, shikikin, reikin, senyu_menseki"
                 . ", madori, madori_desc, completion, structure, rooms, kaiken"
                 . ", muki, parking, condition, equipment, note"
                 . ", kenpei, youseki, shikichi_menseki, tatemono_menseki"
                 . ", img_madori, img_gaikan"
                 . ", modified, status"
                 . " FROM Platy_Realestate_Item WHERE id={$id}";
            $row = $db->fetchRow($sql);
            //var_dump($row);
            $category = $row['category'];
            $name = $row['name'];
            $address = $row['address'];
            $station = $row['station'];
            $bus = $row['bus'];
            $price = $row['price'];
            if ($category == 1 || $category == 2) {
                $kanri = $row['kanri'];
                $shikikin = $row['shikikin'];
                $reikin = $row['reikin'];
                $senyu_menseki = $row['senyu_menseki'];
            }
            $madori = $row['madori'];
            $madori_desc = $row['madori_desc'];
            $completion = $row['completion'];
            $structure = $row['structure'];
            $rooms = $row['rooms'];
            $kaiken = $row['kaiken'];
            $muki = $row['muki'];
            $parking = $row['parking'];
            $condition = $row['condition'];
            $equipment = $row['equipment'];
            $note = $row['note'];
            $img_madori = $row['img_madori'];
            $img_gaikan = $row['img_gaikan'];
            if ($category == 11 || $category == 12) {
                $kenpei = $row['kenpei'];
                $youseki = $row['youseki'];
                $shikichi_menseki = $row['shikichi_menseki'];
                $tatemono_menseki = $row['tatemono_menseki'];
            }
            $modified = $row['modified'];
        }
        ob_start();
        
        echo '<h2>物件編集</h2>' . "\n";
?>
<form method="post" action="" enctype="multipart/form-data">
<table class="form_table">
<tr><th>カテゴリ:</th><td>
<?php
switch ($category) {
case 1: echo 'アパート'; break;
case 2: echo '賃貸マンション'; break;
case 11: echo '新築一戸建て'; break;
case 12: echo '中古一戸建て'; break;
}
?>
</td></tr>
<tr><th>物件名称:</th><td>
<input type="text" name="name" value="<?php echo $name ?>" size="80"/></td></tr>
<tr><th>所在地:</th><td>
<input type="text" name="address" value="<?php echo $address ?>" size="80"/></td></tr>
<tr><th>沿線/最寄り駅:</th><td>
<input type="text" name="station" value="<?php echo $station ?>" size="80"/></td></tr>
<tr><th>バス/徒歩:</th><td>
<input type="text" name="bus" value="<?php echo $bus ?>" size="80"/></td></tr>
<?php if ($category == 1 || $categoty == 2) { ?>
<tr><th></th><td>
賃料:<input type="text" name="price" value="<?php echo $price ?>" size="20"/>&nbsp;
管理・共益費:<input type="text" name="kanri" value="<?php echo $kanri ?>" size="20"/></td></tr>
<tr><th></th><td>
敷金:<input type="text" name="shikikin" value="<?php echo $shikikin ?>" size="20"/>&nbsp;
礼金:<input type="text" name="reikin" value="<?php echo $reikin ?>" size="20"/></td></tr>
<tr><th>占有面積:</th><td>
<input type="text" name="senyu_menseki" value="<?php echo $senyu_menseki ?>" size="20"/></td></tr>
<?php } ?>
<?php if ($category == 11 || $category == 12) { ?>
<tr><th>価格</th><td>
<input type="text" name="price" value="<?php echo $price ?>" size="20"/></td></tr>
<?php } ?>

<tr><th>築年月</th><td>
<input type="text" name="completion" value="<?php echo $completion ?>" size="20"/></td></tr>

<tr><th></th><td>
階建/階:<input type="text" name="kaiken" value="<?php echo $kaiken ?>" size="20"/>&nbsp;
部屋向き:<input type="text" name="muki" value="<?php echo $muki ?>" size="20"/></td></tr>

<tr><th>構造:</th><td>
<input type="text" name="structure" value="<?php echo $structure ?>" size="60"/></td></tr>

<tr><th></th><td>
間取り:<input type="text" name="madori" value="<?php echo $madori ?>" size="60"/><br />
間取り詳細:<input type="text" name="madori_desc" value="<?php echo $madori_desc ?>" size="60"/></td></tr>

<tr><th>駐車場:</th><td>
<input type="text" name="parking" value="<?php echo $parking ?>" size="80"/></td></tr>

<tr><th>条件等:</th><td>
<textarea name="condition" rows="2" cols="60"><?php echo $condition ?></textarea></td></tr>
<tr><th>設備:</th><td>
<textarea name="equipment" rows="2" cols="60"><?php echo $equipment ?></textarea></td></tr>
<tr><th>その他:</th><td>
<textarea name="note" rows="2" cols="60"><?php echo $note ?></textarea></td></tr>

<tr><th>間取り図:</th><td>
<img src="<?php echo BASE_URL . 'media/Realestate/' . $img_madori ?>" /><br />
<input type="file" name="madori" value="<?php echo $img_madori ?>" size="80"/></td></tr>
<tr><th>概観図:</th><td>
<img src="<?php echo BASE_URL . 'media/Realestate/' . $img_gaikan ?>" /><br />
<input type="file" name="gaikan" value="<?php echo $img_gaikan ?>" size="80"/></td></tr>

<?php if ($category == 11 || $category == 12) { ?>
<tr><th></th><td>
建ぺい率:<input type="text" name="kenpei" value="<?php echo $kenpei ?>" size="20"/>&nbsp;
容積率:<input type="text" name="youseki" value="<?php echo $youseki ?>" size="20"/></td></tr>
<tr><th></th><td>
敷地面積:<input type="text" name="shikichi_menseki" value="<?php echo $shikichi_menseki ?>" size="20"/>&nbsp;
建物面積:<input type="text" name="tatemono_menseki" value="<?php echo $tatemono_menseki ?>" size="20"/></td></tr>
<?php } ?>
<tr><th></th><td>
<input type="hidden" name="category" value="<? echo $category ?>" />
<input type="hidden" name="submit_item" value="1" />
<input type="submit" value="物件を更新する" /></td></tr>
</table>
</form>
<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    /**
     * 物件の削除
     */
    public function deleteItemAction()
    {
        global $db, $config;
        
        // id/[id]
        $request = $this->getRequest();
        $id = $request->getParam('id');
        
        $sql = "DELETE FROM Platy_Realestate_Item WHERE id={$id}";
        $db->query($sql);
        
        $this->_redirect('/Manage/Realestate/listItem/');
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * エリア一覧
     */
    public function listAreaAction()
    {
        global $db, $config;
        
        $sql = "SELECT id, name FROM Platy_Realestate_Area";
        $rows = $db->fetchAll($sql);
        
        ob_start();
        
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>name</th>' . "\n";
        for ($i = 0; $i < count($rows); $i++) {
            echo '<tr>';
            echo '<td>' . $rows[$i]['id'] . '</td>';
            echo '<td>' . $rows[$i]['name'] . '</td>';
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    /**
     * エリアの追加
     */
    public function addAreaAction()
    {
        global $db, $config;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $name = $_POST['name'];
            $sql = "INSERT INTO Platy_Realestate_Area(name) VALUES('{$name}')";
            $db->query($sql);
            $this->_redirect('/Manage/Realestate/listArea/');
        }
        
        ob_start();
        
        echo '<h2>エリアの追加</h2>' . "\n";
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>エリア名称:</th>';
        echo '<td>';
        echo '<input type="text" name="name" value="'.  $name . '" size="80" />' . "\n";
        echo '</td>';
        echo '</tr>';
        echo '<tr><th></th><td>';
        echo '<input type="submit" value="エリアを追加する" />' . "\n";
        echo '</table>' . "\n";
        echo '</form>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    /**
     * エリアの編集
     */
    public function editAreaAction()
    {
        global $db, $config;
        
        // id/[id]
        $request = $this->getRequest();
        $id = $request->getParam('id');

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $name = $_POST['name'];
            //$sql = "INSERT INTO Platy_Realestate_Area(name) VALUES('{$name}')";
            //$db->query($sql);
            $this->_redirect('/Manage/Realestate/listArea/');
        }
        else {
            $sql = "SELECT name FROM Platy_Realestate_Area WHERE id={$id}";
            $row = $db->fetchRow($sql);
            $name = $row['name'];
        }
        
        ob_start();
        
        echo '<h2>エリアの編集</h2>' . "\n";
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>エリア名称:</th>';
        echo '<td>';
        echo '<input type="text" name="name" value="'.  $name . '" size="80" />' . "\n";
        echo '</td>';
        echo '</tr>';
        echo '<tr><th></th><td>';
        echo '<input type="submit" value="エリアを更新する" />' . "\n";
        echo '</table>' . "\n";
        echo '</form>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    /**
     * エリアの削除
     */
    public function deleteAreaAction()
    {
        global $db, $config;
        
        // id/[id]
        $request = $this->getRequest();
        $id = $request->getParam('id');
        
        $sql = "DELETE FROM Platy_Realestate_Area WHERE id={$id}";
        $db->query($sql);
        $sql = "DELETE FROM Platy_Realestate_Item_To_Area WHERE areaId={$id}";
        $db->query($sql);
        $this->_redirect('/Manage/Realestate/listArea/');
    }
    
    /**
     * 管理会社の設定
     */
    public function editProvider()
    {
        global $db, $config;
        
        $id = 1;
        
        ob_start();

        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
}
?>