<?php
/**
 * Forum 管理
 */
require_once 'Zend/Controller/Action.php';
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';

class DbForumCategory extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Forum_Category';
    }
}

class DbForumForum extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Forum_Forum';
    }
}

class DbForumTopic extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Forum_Topic';
    }
}

class DbForumPost extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Forum_Post';
    }
}

class Manage_ForumController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $Me;
        if ($Me->isAdmin() == false) {
            $this->_redirect('/Manage/Login/');
        }
    }
    
    public function indexAction()
    {
        $this->_redirect('/Manage/Forum/listCategory/');
    }
    
    /**
     * カテゴリ一覧
     */
    public function listCategoryAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>カテゴリ一覧</h2>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        $sql = "SELECT id, title FROM Platy_Forum_Category";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['title'] . '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Forum/deleteCategory/id/' . $row['id'] . '">';
            echo '削除';
            echo '</a>';
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Forum/addCategory/">';
        echo 'カテゴリの追加';
        echo '</a>';
    
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('forum.php');
    }
    
    /**
     * カテゴリの追加
     */
    public function addCategoryAction()
    {
        global $db, $config, $Me;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $title = h($_POST['title']);
            $memberId = $Me->id;
            $created = date('Y-m-d H:i:s');
            $modified = $created;
            $sql = "INSERT INTO Platy_Forum_Category(title, memberId, created, modified) VALUES("
                 . "'{$title}',{$memberId},'{$created}','{$modified}')";
            $db->query($sql);
            $this->_redirect('/Manage/Forum/listCategory/');
        }
        else {
            $title = '';
        }
        
        ob_start();
?>

<h2>カテゴリの追加</h2>
<form method="post" action="">
<table class="form_table">
<tr><th>title:</th><td>
<input type="text" name="title" value="<?php echo $title ?>" size="60" /></td></tr>
<tr><th></th><td>
<input type="submit" /></td></tr>
</table>
</form>

<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('forum.php');
    }
    
    /**
     * カテゴリの削除
     */
    public function deleteCategoryAction()
    {
        
    }
    
    /**
     * フォーラム一覧
     */
    public function listForumAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>フォーラム一覧</h2>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        $sql = "SELECT id, title, description, catId FROM Platy_Forum_Forum";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['title'] . '</td>';
            echo '<td>' . $row['catId'] . '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Forum/deleteForum/id/' . $row['id'] . '">';
            echo '削除';
            echo '</a>';
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Forum/addForum/">';
        echo 'フォーラムの追加';
        echo '</a>';
    
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('forum.php');
    }
    
    /**
     * フォーラムの追加
     */
    public function addForumAction()
    {
        global $db, $config, $Me;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $title = h($_POST['title']);
            $description = h($_POST['description']);
            $memberId = $Me->id;
            $catId = intval($_POST['catId']);
            $created = date('Y-m-d H:i:s');
            $modified = $created;
            $sql = "INSERT INTO Platy_Forum_Forum(title, description, memberId, catId, created, modified) VALUES("
                 . "'{$title}','{$description}',{$memberId},{$catId},'{$created}','{$modified}')";
            $db->query($sql);
            $this->_redirect('/Manage/Forum/listForum/');
        }
        else {
            $title = '';
            $description = '';
        }
        
        ob_start();
?>

<h2>フォーラムの追加</h2>
<form method="post" action="">
<table class="form_table">
<tr><th>title:</th><td>
<input type="text" name="title" value="<?php echo $title ?>" size="60" /></td></tr>
<tr><th>description:</th><td>
<textarea name="description" cols="60" rows="4"><?php echo $description ?></textarea></td></tr>
<tr><th>カテゴリ:</th><td>
<?php $this->cbo_Category($catId) ?>
</td></tr>
<tr><th></th><td>
<input type="submit" /></td></tr>
</table>
</form>

<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('forum.php');
    }
    
    /**
     * フォーラムの削除
     */
    public function deleteForumAction()
    {
    }
    
    /**
     * カテゴリ ドロップダウンリスト
     */
    private function cbo_Category($default = "")
    {
        global $db, $config;
        
        $sql = "SELECT id, title FROM Platy_Forum_Category";
        $rows = $db->fetchAll($sql);
        echo '<select name="catId">' . "\n";
        foreach ($rows as $row) {
            echo '<option value="' . $row['id'] . '"';
            if ($default == $row['id']) {
                echo ' selected="true"';
            }
            echo '>';
            echo $row['title'];
            echo '</option>' . "\n";
        }
        echo '</select>' . "\n";
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
}
?>