<?php
/**
 * CVar 管理
 */
require_once 'Zend/Controller/Action.php';

class Manage_CvarController extends Zend_Controller_Action
{
    private $contents;
    
    public function preDispatch()
    {
        global $Me, $currentManage, $breadcrumb;
        
        if ($Me->isAllowed('Manage_Site') == false) {
            $this->_redirect('/Manage/Login/');
        }
        $currentManage = 'CVar';
        $breadcrumb->add('管理', BASE_URL . 'Manage/');
        $breadcrumb->add('コンテンツ変数', BASE_URL . 'Manage/CVar/');
    }
    
    public function indexAction()
    {
        $this->listAction();
    }

    public function noRouteAction()
    {
        echo "noRouteAction";
    }
    
    /**
     * 変数一覧を表示する。
     */
    public function listAction()
    {
        global $db, $base;
        
        ob_start();
        
        $CVar_path = APP_PATH . 'models/CVar/';

        echo '<h3>インストール済の変数</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";
        $installed_CVar_name = array();
        $sql = "SELECT id, name FROM  Platy_CVar";
        $rows = $db->fetchAll($sql);
        for ($i = 0; $i < count($rows); $i++) {
        
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            
            echo '<td>' . $rows[$i]['id'] . '</td>';
            echo '<td>' . $rows[$i]['name'] . '</td>';
            
            $CVar_name = $rows[$i]['name'];
            require_once($CVar_path . $CVar_name . '.php');
            $CVar_class_name = 'Platy_CVar_' . $CVar_name;
            $obj = new $CVar_class_name;
            
            echo '<td>';
            echo $obj->getSummary();
            echo '</td>';
            
            echo '<td>';
            echo $obj->getVersion();
            echo '</td>';
            
            echo '<td>';
            echo $obj->getAuthor();
            echo '</td>';
            
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/CVar/uninstall/name/' . $rows[$i]['name'] . '">';
            echo '<img src="' . BASE_URL . 'media/system/package_delete.png" alt="uninstall" />';
            echo 'アンインストール</a>';
            echo '</td>';
            echo "</tr>\n";
            $installed_CVar_name[] = $rows[$i]['name'];
        }
        echo '</table>' . "\n";
        
        echo '<h3>未インストールの変数</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";

        $d = dir($CVar_path);
        $i = 0;
        while (($entry = $d->read()) != FALSE) {
            if (!is_dir($CVar_path . $entry)) {
                $CVar_filename = $entry;
                //echo $CVar_filename . "<br />\n";
                $pos = stripos($CVar_filename, '.php');
                $CVar_name = substr($CVar_filename, 0, $pos);
                if (!in_array($CVar_name, $installed_CVar_name)) {
                    
                    require_once($CVar_path . $CVar_name . '.php');
                    
                    if ($i % 2 == 0) { echo '<tr class="even">'; }
                    else { echo '<tr class="odd">'; }
                    
                    echo '<td>' . $CVar_name . '</td>';
                    
                    $CVar_class_name = 'Platy_CVar_' . $CVar_name;
                    $obj = new $CVar_class_name;
                    
                    echo '<td>';
                    echo $obj->getSummary();
                    echo '</td>';
                    
                    echo '<td>';
                    echo $obj->getVersion();
                    echo '</td>';

                    echo '<td>';
                    echo $obj->getAuthor();
                    echo '</td>';

                    echo '<td>';
                    echo '<a href="' . BASE_URL . 'Manage/CVar/install/name/' . $CVar_name . '">';
                    echo '<img src="' . BASE_URL . 'media/system/package_add.png" alt="install" />';
                    echo 'インストール</a>';
                    echo '</td>';
                    echo '</tr>' . "\n";
                    $i++;
                }
            }
        }
        echo '</table>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * 設定
     */
    public function configAction()
    {
    }
    
    /**
     * インストール
     */
    public function installAction()
    {
        global $db;
        
        ob_start();
        
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        require(APP_PATH . 'models/CVar/' . $name . '.php');
        $classname = 'Platy_CVar_' . $name;
        $obj = new $classname();
        if ($obj->install() == TRUE) {
            $sql = "INSERT INTO Platy_CVar(name) VALUES('{$name}')";
            echo $sql . "<br />\n";
            $db->query($sql);
            echo $name . 'のインストールに成功しました。' . "<br />\n";
        }
        else {
            echo $name . 'のインストールに失敗しました。' . "<br />\n";
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * アンインストール
     */
    public function uninstallAction()
    {
        global $db;
        
        ob_start();
        
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        require(APP_PATH . 'models/CVar/' . $name . '.php');
        $classname = 'Platy_CVar_' . $name;
        $obj = new $classname();
        if ($obj->uninstall() == TRUE) {
            $sql = "DELETE FROM Platy_CVar WHERE name='" . $name . "'";
            $db->query($sql);
            echo $name . 'のアンインストールに成功しました。' . "<br />\n";
        }
        else {
            echo $name . 'のアンインストールに失敗しました。' . "<br />\n";
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    private function view()
    {
        global $breadcrumb;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $this->contents;
        $view->breadcrumb = $breadcrumb->getContents();
        echo $view->render('page.php');
    }
}
?>