<?php
/**
 * Contactモジュールの管理
 */
require_once 'Zend/Controller/Action.php';

class Manage_BbsController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $Me;
        if ($Me->isAdmin() == false) {
            $this->_redirect('/Manage/Login/');
        }
    }
    
    public function indexAction()
    {
        $this->configAction();
    }
    
    public function configAction()
    {
        global $db, $config;
        
        ob_start();
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $intro = h($_POST['intro']);
            $admin_email = h($_POST['admin_email']);
            
        }
        else {
            $intro = $config['M_CONTACT_INTRO'];
            $admin_email = $config['M_CONTACT_ADMIN_EMAIL'];
        }
        
        echo '<h2>お問い合わせの設定</h2>' . "\n";
        echo '<form method="post" action="">' . "<br />\n";
        echo "Eメールアドレス:<br />\n";
        echo '<input type="text" name="admin_email" value="' . $admin_email . '" size="60" />';
        echo "<br />\n";
        echo "INTRO:<br />\n";
        echo '<textarea name="intro" rows="4" cols="60">';
        echo $intro;
        echo '</textarea>' . "<br />\n";
        echo '<input type="submit" />' . "\n";
        echo '</form>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('page.php');
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
}
?>