<?php
/**
 * ユーティリティクラス
 */
class Platy_Util {

    /**
     * ランダムなキーを生成する
     * @param  int $len キーの長さ (デフォルト:16)
     * @return string   生成したキー
     */
    public static function generateKey($len = 16) {
        $pwelemstr = 'abcdefghkmnpqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ2345679';
        $pwelem = preg_split('//', $pwelemstr, 0, PREG_SPLIT_NO_EMPTY);
        $password = '';
        for ($i = 0; $i < $len; $i++) {
            // パスワード文字列を生成
            $password .= $pwelem[array_rand($pwelem, 1)];
        }
        return $password;
    }
    
    /**
     * 公開期間判定
     * @param string $start 公開開始日時(YYYY-MM-DD HH:MM:SS)
     * @param string $end   公開終了日時(YYYY-MM-DD HH:MM:SS)
     * @return bool 公開期間中ならばtrue,そうでなければfalseを返す
     */
    public static function checkPeriod($start, $end) {
        $start_uts = mktime(0, 0, 0, 1, 1, 1970);
        if (strlen($start) > 0) {
            $a = explode(' ', $start);
            $b = explode('-', $a[0]);
            $c = explode(':', $a[1]);
            $year = intval($b[0]);
            $month = intval($b[1]);
            $day = intval($b[2]);
            $hour = intval($c[0]);
            $min = intval($c[1]);
            $sec = intval($c[2]);
            $start_uts = mktime($hour, $min, $sec, $month, $day, $year);
        }
        $end_uts = mktime(0, 0, 0, 12, 31, 2037);
        if (strlen($end) > 0) {
            $a = explode(' ', $end);
            $b = explode('-', $a[0]);
            $c = explode(':', $a[1]);
            $year = intval($b[0]);
            $month = intval($b[1]);
            $day = intval($b[2]);
            $hour = intval($c[0]);
            $min = intval($c[1]);
            $sec = intval($c[2]);
            $end_uts = mktime($hour, $min, $sec, $month, $day, $year);
        }
        $now_uts = mktime();
        
        //echo sprintf("checkPeriod:%s - %s<br />\n", $start, $end);
        //echo sprintf("checkPeriod:%d %d - %d<br />\n", $now_uts, $start_uts, $end_uts);
        
        if ($start_uts <= $now_uts && $now_uts <= $end_uts) {
            return true;
        }
        return false;
    }
    
    /**
     * ページナビゲーション表示
     * @param int    $perPage   1ページあたりの表示数
     * @param int    $start     現在の表示位置
     * @param int    $total     総数
     * @param string $url       URL
     */
    static public function Pager($perPage, $start, $total, $url = '') {
        //echo $perPage . '|' . $start . '|' . $total . '|' . $url . "<br />\n";
        $pages = ceil($total / $perPage);
        if ($pages > 1) {
            echo '<p class="page_nav">';
            echo 'Pages:';
            for ($i = 0; $i < $pages; $i++) {
                if ($start >= $i*$perPage && $start < (($i+1)*$perPage)) {
                    echo ($i+1) . "\n";
                }
                else {
                    echo '<a href="' . $url . 'start=' . $i*$perPage . '">' . ($i+1) . '</a>' . "\n";
                }
            }
            echo '</p>' . "\n";
        }
    }
    
    /**
     * (タグ)クラウド表示
     * @param array $wordScores  tag,url,count
     */
    static public function buildCloud($wordScores, $link = '', $minSize=90, $maxSize=350) {
        $max = 0; $min = 10000;
        for ($i = 0; $i < count($wordScores); $i++) {
            if ($max < $wordScores[$i]['count']) {
                $max = $wordScores[$i]['count'];
            }
            else if ($min > $wordScores[$i]['count']) {
                $min = $wordScores[$i]['count'];
            }
        }
        for ($i = 0; $i < count($wordScores); $i++) {
            echo '<a href="' . $link . $wordScores[$i]['url'] . '">';
            echo '<span';
            echo ' style="font-size:' . (int)($wordScores[$i]['count'] / $max * $maxSize) . '%;';
            echo '">';
            echo $wordScores[$i]['tag'];
            echo '(' . $wordScores[$i]['count'] . ')';
            echo '</span>';
            echo '</a>';
            if ($i != count($wordScores) - 1) {
                echo "&nbsp;*&nbsp;";
            }
            echo "\n";
        }
    }
    
    /**
     * ユーザ名を返す
     * @param int $memberId メンバーId
     * @return string ユーザ名
     */
    static public function getUsername($memberId) {
        global $db;
        if ($memberId == NULL) { return ''; }
        $sql = "SELECT username FROM Platy_Member WHERE id={$memberId}";
        $row = $db->fetchRow($sql);
        return $row['username'];
    }
    
    /**
     * 数値を通貨形式に変換 (例）10000→10,000円
     * 「PHPによるスーパーサンプル」より引用
     */
    public function cnv_currency($number, $unit = '円') {
        if (!isset($number)) { return ''; }
        $string = number_format(intval($number)) . $unit;
        return $string;
    }
    
    /**
     * ディレクトリを返す
     * @param string $path パス
     * @return array ディレクトリ名のリスト配列
     */
    public function getDir($path)
    {
        $ret = array();
        $d = dir($path);
        $i = 0;
        while (($entry = $d->read()) != FALSE) {
            if (is_dir($path . $entry) && $entry != '.' && $entry != '..') {
                $ret[] = $entry;
            }
        }
        $d->close();
        if (count($ret) >= 1) {
            return $ret;
        }
        return NULL;
    }
    
    /**
     * lock
     * @param string $lock_name
     * @param int $wait 最大待ち時間(秒)
     * @return int ロックハンドル。失敗した場合はFALSEを返す
     */
    static public function lock($lock_name, $wait = 10)
    {
        $lock_filename = BASE_PATH . 'private/' . $lock_name;
        if (file_exists($lock_filename) == false) {
            $fp = fopen($lock_filename, "w");
            if ($fp == false) { return FALSE; }
            fclose($fp);
        }
        if (is_writable($lock_filename) == FALSE) {
            return FALSE;
        }
        for ($i = 0; $i < $wait; $i++) {
            $fp = @fopen($lock_filename, "w");
            if ($fp != FALSE) {
                flock($fp, LOCK_EX);
                return $fp;
            }
            sleep(1);
        }
        return FALSE;
    }
    
    /**
     * unlock
     * @param int $fp ロックハンドル
     */
    static public function unlock($fp)
    {
        flock($fp, LOCK_UN);
        fclose($fp);
    }
    
    /**
     *
     */
    static public function getWeek($day, $pre = '', $post = '')
    {
        $ret = '';
        $time = strtotime($day);
        $d = getdate($time);
        
        $wday = array('日', '月', '火', '水', '木', '金', '土');
        $ret = $pre . $wday[$d['wday']] . $post;
        return $ret;
    }
}
?>