#!/usr/bin/perl
# $Id: mt-plugin-start.pl 2 2007-07-18 03:03:44Z cheebow $
#
# MTPlugin-Starter
#
# Based on plugin-start.pl(Plagger).
#
# Copyright 2007 by M-Logic, Inc.
#
# This is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself. 

use strict;
use warnings;

use Config;
use FindBin;
use ExtUtils::MakeMaker;
use File::Basename;
use File::Path;
use YAML;
use Template;

use vars qw( $VERSION );
$VERSION = '0.50';

use Getopt::Long;
my %opts = (help  =>  0);
GetOptions(
    \%opts,
    'name|n:s',
    'doc|d',
    'object|o',
    'config|c',
    'task|s',
    'transform|r',
    'tags|t',
    'filter|f',
    'hook|k',
    'help|h',
    'version|v',
);

usage() if $opts{help};
version() if $opts{version};
my $module = $opts{name} or usage();

my $cfg_name = '.mt-plugin.yml';
my $cfg_file;
if (($^O eq 'MSWin32') and $ENV{APPDATA}) {
    $cfg_file = "$ENV{APPDATA}/M-Logic/MTPlugin-Starter/$cfg_name";
} else {
    $cfg_file = ($ENV{HOME}) ?  "$ENV{HOME}/$cfg_name"
              :                 "$cfg_name"
              ;
}
my $cfg_dir = File::Basename::dirname($cfg_file);
File::Path::mkpath($cfg_dir, 1, 0777) unless (-e $cfg_dir);

my $config = eval { YAML::LoadFile($cfg_file) } || {};

my $save;
$config->{author} ||= do {
    $save++;
    prompt("Your name: ");
};
$config->{link} ||= do {
    $save++;
    prompt("Your site URL: ");
};
$config->{link} .= '/' if $config->{link} !~ m!/$!;

write_plugin_files($module, $config->{author}, $config->{link});

YAML::DumpFile($cfg_file, $config) if $save;

sub usage {
    my$myname = $0;
    $myname =~ s|(.*/)?||;

    print STDERR <<END;
Usage: perl $myname -n <PluginName> [Options]
     % perl $myname -n TestPlugin
     % perl $myname -n TestPlugin -t -c

     -d, --doc       : Link for document
     -o, --object    : Object classes
     -c, --config    : Plugin settings
     -s, --task      : Schedule tasks
     -r, --transform : Transformer
     -t, --tags      : Tags
     -f, --filter    : Global filter
     -k, --hook      : hook
     -h, --help      : help
     -v, --version   : version
    
END

    exit;
}

sub version {
    my$myname = $0;
    $myname =~ s|(.*/)?||;

    print "MTPlugin-Starter $VERSION";

    exit;
}

sub write_plugin_files {
    my($module, $author, $link) = @_;

    # $module   = "FooBar"
    # $file     = "foo_bar"
    (my $file = $module) =~ s!([a-z0-9])([A-Z])!$1_$2!g;
    $file =~ s!^_!!g;
    $file = lc $file;
    
    my $upper = uc $file;
    
    my $template = YAML::Load(join '', <DATA>);
    my $vars = {
        module => $module,
        author => $author,
        link   => $link,
        file   => $file,
        upper  => $upper,
        vc_id  => '$' . 'Id' . '$',
    };

    foreach my $key ( keys %opts ) {
        $vars->{$key} = $opts{$key};
    }

    my $module_path = "$module/plugins/$module/";
    my $lib_path = $module_path . "lib/$module/";
    my $doc_path = "$module/docs/";
    my $php_path = "$module/php/plugins/";
    write_file("$module_path/mt-$file.pl", $template->{plugin}, $vars);
    write_file("$lib_path/L10N.pm", $template->{l10n}, $vars);
    write_file("$lib_path/L10N/en_us.pm", $template->{en_us}, $vars);
    write_file("$lib_path/L10N/ja.pm", $template->{ja}, $vars);
    if ($opts{object}) {
        write_file("$lib_path/Object.pm", $template->{object}, $vars) ;
    }
    if ($opts{filter}) {
        write_file("$php_path/modifier.$file.php", $template->{php_filter}, $vars) ;
    }
    if ($opts{tags}) {
        write_file("$php_path/block.MTContainerTag.php", $template->{php_container_tag}, $vars) ;
        write_file("$php_path/block.MTIfTag.php", $template->{php_if_tag}, $vars) ;
        write_file("$php_path/function.MTTag.php", $template->{php_var_tag}, $vars) ;
    }
    write_file("$doc_path/mt-$file.html", $template->{doc}, $vars);
    write_file("$doc_path/mtdocs.css", $template->{css}, $vars);
}

sub write_file {
    my($path, $template, $vars) = @_;

    if (-e $path) {
        my $ans = prompt("$path exists. Override? [yN] ", 'n');
        return if $ans !~ /[Yy]/;
    }

    my $dir = File::Basename::dirname($path);
    unless (-e $dir) {
        warn "Creating directory $dir\n";
        File::Path::mkpath($dir, 1, 0777);
    }

    my $tt = Template->new(TRIM =>1,);
    $tt->process(\$template, $vars, \my $content);

    warn "Creating $path\n";
    open my $out, ">", $path or die "$path: $!";
    print $out $content;
    close $out;

    return $path;
}

__DATA__
plugin: |
  # [% vc_id %]
  
  package MT::Plugin::[% module %];
  
  use strict;
  use MT::Template::Context;
  use MT::Plugin;
  @MT::Plugin::[% module %]::ISA = qw(MT::Plugin);
  
  use vars qw($PLUGIN_NAME $VERSION);
  $PLUGIN_NAME = '[% module %]';
  $VERSION = '0.50';
  
  use MT;
  my $plugin = new MT::Plugin::[% module %]({
      name => $PLUGIN_NAME,
      version => $VERSION,
      description => "<MT_TRANS phrase='description of [% module %]'>",
  [%- IF doc %]
      doc_link => '[% link %]mt-plugins/mt-[% file %]/docs/mt-[% file %].html',
  [%- END %]
      author_name => '[% author %]',
      author_link => '[% link %]',
      l10n_class => '[% module %]::L10N',
  [%- IF object %]
      schema_version => 0.01,
      object_classes => [ '[% module %]::Object', ],
  [%- END -%]
  [%- IF config %]
      config_template => \&config_template,
      # blog_config_template => \&blog_config_template,
      # system_config_template => \&system_config_template,
      settings => new MT::PluginSettings([
          ['[% file %]_pref', { Default => 1 }],
      ]),
  [%- END %]
  });
  
  MT->add_plugin($plugin);
  [%- IF task %]
  
  #----- Task
  MT->add_task({
      key => '[% module %]',
      name => '[% module %]',
      frequency => 1 * 60 * 60,   # no more than every 1 hours
      code => sub {
          $plugin->do_[% file %];
      } 
  });
  [%- END -%]
  [%- IF transform %]
  
  #----- Transformer
  MT->add_callback('MT::App::CMS::AppTemplateSource.***', 9, $plugin, \&hdlr_source);
  MT->add_callback('MT::App::CMS::AppTemplateOutput.***', 9, $plugin, \&hdlr_output);
  MT->add_callback('MT::App::CMS::AppTemplateParam.***', 9, $plugin, \&hdlr_parama);

  #----- Transformer(MT4)
  MT->add_callback('template_source.***', 9, $plugin, \&hdlr_mt4_source);
  MT->add_callback('template_output.***', 9, $plugin, \&hdlr_mt4_output);
  MT->add_callback('template_param.***', 9, $plugin, \&hdlr_mt4_parama);
  [%- END -%]
  [%- IF tags %]
  
  #----- Tags
  MT::Template::Context->add_container_tag('ContainerTag' => sub{&hdlr_container;});
  MT::Template::Context->add_tag('Tag' => sub{&hdlr_tag;});
  MT::Template::Context->add_conditional_tag('IfTag' => sub{&hdlr_if;});
  [%- END -%]
  [%- IF filter %]
  
  #----- Global filter
  MT::Template::Context->add_global_filter([% file %] => \&[% file %] );
  [%- END -%]
  [%- IF hook %]
  
  #----- Hook
  MT->add_callback('CMSPre**.**', 9, $plugin, \&CMSPre**_**);
  MT->add_callback('CMSPost**.**', 9, $plugin, \&CMSPost**_**);
  MT->add_callback("BuildPage", 9, $plugin, \&cb_build_page);
  [%- END %]
  
  
  sub instance { $plugin; }
  
  sub doLog {
      my ($msg) = @_; 
      return unless defined($msg);

      use MT::Log;
      my $log = MT::Log->new;
      $log->message($msg) ;
      $log->save or die $log->errstr;
  }
  [%- IF config %]
  
  sub config_template {
      my $tmpl = <<'EOT';
      <div class="setting">
      <div class="label">
      <label for="[% file %]_pref"><MT_TRANS phrase="[% module %] pref:"></label>
      </div>
      <div class="field">
      <p>
      <input type="text" name="[% file %]_pref" id="[% file %]_pref" value="<TMPL_VAR NAME=[% upper %]_PREF ESCAPE=HTML>" />
      </p>
      <p><MT_TRANS phrase="[% module %] pref"></p>
      </div> 
      </div>
  EOT
  }
  
  sub [% file %]_pref {
      my $plugin = shift;
      my ($blog_id) = @_;
      my %plugin_param;
  
      $plugin->load_config(\%plugin_param, 'blog:'.$blog_id);
      my $key = $plugin_param{[% file %]_pref};
      unless ($key) {
          $plugin->load_config(\%plugin_param, 'system');
          $key = $plugin_param{[% file %]_pref};
      }
      $key;
  }
  [%- END -%]
  [%- IF task %]
  
  #----- Task
  sub do_[% file %] {
      my $plugin = shift;
      my $app = shift;  # MT::App::CMS;
      
      1
  }
  [%- END -%]
  [%- IF transform %]
  
  #----- Transformer
  sub hdlr_source {
      my ($eh, $app, $tmpl_ref) = @_;
  
      1;
  }
  
  sub hdlr_output {
      my ($eh, $app, $tmpl_str_ref, $param, $tmpl) = @_;
  
      1;
  }
  
  sub hdlr_parama {
      my ($eh, $app, $param, $tmpl) = @_;
  
      1;
  }

  #----- Transformer(MT4)
  sub hdlr_mt4_source {
      my ($eh, $app, $tmpl_ref) = @_;
  
      1;
  }
  
  sub hdlr_mt4_output {
      my ($eh, $app, $tmpl_str_ref, $param, $tmpl) = @_;
  
      1;
  }
  
  sub hdlr_mt4_parama {
      my ($eh, $app, $param, $tmpl) = @_;
  
      1;
  }
  [%- END -%]
  [%- IF tags %]
  
  #----- Tags
  sub hdlr_container {
      my ($ctx, $args, $cond) = @_;
      my $builder = $ctx->stash('builder');
      my $tokens = $ctx->stash('tokens');
  
      defined(my $out = $builder->build($ctx, $tokens, $cond))
          || return $ctx->error($ctx->errstr);
  
      return $out;
  }
  
  sub hdlr_tag {
      my ($ctx, $args) = @_;
  
      1;
  }
  
  sub hdlr_if {
      my ($ctx, $args, $cond) = @_;
  
      1;
  }
  [%- END -%]
  [%- IF filter %]
  
  #----- Global filter
  sub [% file %] {
      my ($text, $arg, $ctx) = @_;
      $arg or return $text;
  
      $text;
  }
  [%- END -%]
  [%- IF hook %]
  
  #----- Hook
  sub CMSPre**_** {
      my ($cb, $app, $obj, $original) = @_;
  
      1;
  }
  
  sub CMSPost**_** {
      my ($cb, $app, $obj) = @_;
  
      1;
  }
  
  sub cb_build_page {
      my ($eh, %args) = @_;
      my $content_ref = $args{Content};
  
      1;
  }
  [%- END %]
  
  1;

l10n: |
  # [% vc_id %]
  
  package [% module %]::L10N;
  
  use strict;
  use base 'MT::Plugin::L10N';
  
  1;

en_us: |
  # [% vc_id %]
  
  package [% module %]::L10N::en_us;
  
  use strict;
  use base '[% module %]::L10N';
  use vars qw( %Lexicon );
  
  %Lexicon = (
  );
  
  1;

ja: |
  # [% vc_id %]
  
  package [% module %]::L10N::ja;
  
  use strict;
  use base '[% module %]::L10N::en_us';
  use vars qw( %Lexicon );
  
  ## The following is the translation table.
  
  %Lexicon = (
      'description of [% module %]' => '[% module %]の説明',
  );
  
  1;

doc: |
  <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
  <html>
  <head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <title>[% module %]プラグイン</title>
  <link href="mtdocs.css" rel="stylesheet" type="text/css">
  </head>
  
  <body>
  <h1>[% module %]プラグイン</h1>
  
  <h2>はじめに</h2>
  <p>
  </p>
  
  <h2>インストール</h2>
  <p>
  </p>
  
  <h2>使い方</h2>
  <p>
  </p>
  
  <h2>更新履歴</h2>
  <ul>
    <li>[200*-**-**：v0.50]</li>
      <ul>
        <li>最初のリリース</li>
      </ul>
  </ul>
  
  <h2>このプラグインの利用、及び著作権や保証について</h2>
  
  <p>
  このプラグインの著作権は[% author %]が所有しています。著作権者の許可なく本プラグインを使用、改変、再配布することはできません。
  </p>
  
  <h2>連絡先</h2>
  
  <p>作者：<a href="[% link %]">[% author %]</a></p>
  
  </body>
  </html>

css: |
  body {
  	margin-right: 20px;
  	margin-left: 20px;
  }
  
  p {
  	margin-right: 5px;
  	margin-left: 5px;
  }
  
  h1 {
  	border-bottom-width: 0;
  }
  
  h2 {
  	font-size: medium;
  	padding-left: 5px;
  	padding-top: 3px;
  	padding-bottom: 3px;
  	border-top: 1px solid #039;
  	border-bottom: 1px solid #039;
  	border-left: 10px solid #039;
  }
  
  h3 {
  	font-size: medium;
  	padding-left: 5px;
  	padding-top: 3px;
  	padding-bottom: 3px;
  	border-bottom: 1px solid #aaa;
  	border-left: 10px solid #aaa;
  }
  
  dt {
  	font-weight: bold;
  	margin-top: 15px;
  	margin-bottom: 5px;
  }
  
  dd {
  	margin-top: 5px;
  	margin-bottom: 5px;
  }
  
  strong {
  	font-weight: bold;
  }
  
  .sample {
  	margin-right: 15px;
  	margin-left: 15px;
  	background: #E6E6FF;
  	padding: 5px;
  }

object: |
  # [% vc_id %]
  
  package [% module %]::Object;
  use warnings;
  use strict;
  use Carp;
  
  use MT::Object;
  @[% module %]::Object::ISA = qw( MT::Object );
  
  __PACKAGE__->install_properties ({
      column_defs => {
          'id' => 'integer not null auto_increment',
      },
      indexes => {
      },
      datasource => '[% file %]',
      #audit => 1,
      primary_key => 'id',
  });
  
  1;
  
  __END__

php_filter: |
  <?php
  function smarty_modifier_[% file %]($text) {
      return $text;
  }
  ?>

php_container_tag: |
  <?php
  function smarty_block_MTContainerTag($args, $content, &$ctx, &$repeat) {
      $localvars = array('_items', '_items_counter', 'item');
      if(!isset($content)) {
          $ctx->localize($localvars);
          // load items here...
          $items = array();
          $ctx->stash('_items', $items);
          $counter = 0;
      }
      else {
          $items = $ctx->stash('_items');
          $counter = $ctx->stash('_items_counter);
      }
      if($counter < count($items)) {
          $item = $items[$counter];
          $ctx->stash('item', $item);
          $ctx->stash('_items_counter', $counter + 1);
          $repeat = true;
      }
      else {
          $ctx->restore($localvars);
          $repeat = false;
      }
      return $content;
  }
  ?>

php_var_tag: |
  <?php
  function smarty_function_MTTag($args, &$ctx) {
      return '';
  }
  ?>

php_if_tag: |
  <?php
  function smarty_block_MTIfTag($args, $content, &$ctx, &$repeat) {
      if(!isset($content)) {
          // set condition here...
          $condition = false;
          return $ctx->_hdlr_if($args, $content, $ctx, $repeat, $condition);
      }
      else {
          return $ctx->_hdlr_if($args, $content, $ctx, $repeat);
      }
  }
  ?>
