/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import gnu.inet.http.Authenticator;
import gnu.inet.http.ByteArrayRequestBodyWriter;
import gnu.inet.http.ByteArrayResponseBodyReader;
import gnu.inet.http.Credentials;
import gnu.inet.http.HTTPConnection;
import gnu.inet.http.Headers;
import gnu.inet.http.Request;
import gnu.inet.http.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HTTPURLConnection
extends HttpURLConnection {
    private static final Map connectionPool = new LinkedHashMap();
    private HTTPConnection connection;
    private String proxyHostname;
    private int proxyPort;
    private String agent;
    private boolean keepAlive;
    private int maxConnections;
    private Request request;
    private Headers requestHeaders = new Headers();
    private ByteArrayOutputStream requestSink;
    private boolean requestMethodSetExplicitly;
    private Response response;
    private ByteArrayInputStream responseSink;
    private ByteArrayInputStream errorSink;

    public HTTPURLConnection(URL url) {
        super(url);
        AccessController.doPrivileged(new GetHTTPPropertiesAction());
    }

    @Override
    public void connect() throws IOException {
        boolean retry;
        int ci;
        if (this.connected) {
            return;
        }
        String protocol = this.url.getProtocol();
        boolean secure = "https".equals(protocol);
        String host = this.url.getHost();
        int port = this.url.getPort();
        if (port < 0) {
            port = secure ? 443 : 80;
        }
        String file = this.url.getFile();
        String username = this.url.getUserInfo();
        String password = null;
        if (username != null && (ci = username.indexOf(58)) != -1) {
            password = username.substring(ci + 1);
            username = username.substring(0, ci);
        }
        final Credentials creds = username == null ? null : new Credentials(username, password);
        do {
            retry = false;
            if (this.connection == null) {
                this.connection = this.getConnection(host, port, secure);
            }
            if (this.proxyHostname != null) {
                if (this.proxyPort < 0) {
                    this.proxyPort = secure ? 443 : 80;
                }
                this.connection.setProxy(this.proxyHostname, this.proxyPort);
            }
            this.request = this.connection.newRequest(this.method, file);
            if (!this.keepAlive) {
                this.request.setHeader("Connection", "close");
            }
            if (this.agent != null) {
                this.request.setHeader("User-Agent", this.agent);
            }
            this.request.getHeaders().putAll((Map)this.requestHeaders);
            if (this.requestSink != null) {
                byte[] content = this.requestSink.toByteArray();
                ByteArrayRequestBodyWriter writer = new ByteArrayRequestBodyWriter(content);
                this.request.setRequestBodyWriter(writer);
            }
            ByteArrayResponseBodyReader reader = new ByteArrayResponseBodyReader();
            this.request.setResponseBodyReader(reader);
            if (creds != null) {
                this.request.setAuthenticator(new Authenticator(){

                    @Override
                    public Credentials getCredentials(String realm, int attempts) {
                        return attempts < 2 ? creds : null;
                    }
                });
            }
            this.response = this.request.dispatch();
            if (this.response.getCodeClass() == 3 && this.getInstanceFollowRedirects()) {
                int ci2;
                int end;
                String location = this.response.getHeader("Location");
                if (location == null) continue;
                String connectionUri = this.connection.getURI();
                int start = connectionUri.length();
                if (location.startsWith(connectionUri) && location.charAt(start) == '/') {
                    file = location.substring(start);
                    retry = true;
                    continue;
                }
                if (location.startsWith("http:")) {
                    this.connection.close();
                    this.connection = null;
                    secure = false;
                    start = 7;
                    end = location.indexOf(47, start);
                    host = location.substring(start, end);
                    ci2 = host.lastIndexOf(58);
                    if (ci2 != -1) {
                        port = Integer.parseInt(host.substring(ci2 + 1));
                        host = host.substring(0, ci2);
                    } else {
                        port = 80;
                    }
                    file = location.substring(end);
                    retry = true;
                    continue;
                }
                if (location.startsWith("https:")) {
                    this.connection.close();
                    this.connection = null;
                    secure = true;
                    start = 8;
                    end = location.indexOf(47, start);
                    host = location.substring(start, end);
                    ci2 = host.lastIndexOf(58);
                    if (ci2 != -1) {
                        port = Integer.parseInt(host.substring(ci2 + 1));
                        host = host.substring(0, ci2);
                    } else {
                        port = 443;
                    }
                    file = location.substring(end);
                    retry = true;
                    continue;
                }
                if (location.length() <= 0) continue;
                if (location.charAt(0) == '/') {
                    file = location;
                } else {
                    int lsi = file.lastIndexOf(47);
                    file = lsi == -1 ? "/" : file.substring(0, lsi + 1);
                    file = file + location;
                }
                retry = true;
                continue;
            }
            this.responseSink = new ByteArrayInputStream(reader.toByteArray());
            if (this.response.getCode() != 404) continue;
            this.errorSink = this.responseSink;
            throw new FileNotFoundException(this.url.toString());
        } while (retry);
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HTTPConnection getConnection(String host, int port, boolean secure) throws IOException {
        HTTPConnection connection;
        if (this.keepAlive) {
            StringBuffer buf = new StringBuffer(secure ? "https://" : "http://");
            buf.append(host);
            buf.append(':');
            buf.append(port);
            String key = buf.toString();
            Map map = connectionPool;
            synchronized (map) {
                connection = (HTTPConnection)connectionPool.get(key);
                if (connection == null) {
                    connection = new HTTPConnection(host, port, secure);
                    if (connectionPool.size() == this.maxConnections) {
                        Object lru = connectionPool.keySet().iterator().next();
                        connectionPool.remove(lru);
                    }
                    connectionPool.put(key, connection);
                }
            }
        } else {
            connection = new HTTPConnection(host, port, secure);
        }
        return connection;
    }

    @Override
    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean usingProxy() {
        return this.proxyHostname != null;
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        int len = (method = method.toUpperCase()).length();
        if (len == 0) {
            throw new ProtocolException("Empty method name");
        }
        for (int i = 0; i < len; ++i) {
            char c = method.charAt(i);
            if (c >= 'A' && c <= 'Z') continue;
            throw new ProtocolException("Illegal character '" + c + "' at index " + i);
        }
        this.method = method;
        this.requestMethodSetExplicitly = true;
    }

    @Override
    public String getRequestProperty(String key) {
        return this.requestHeaders.getValue(key);
    }

    public Map getRequestProperties() {
        return this.requestHeaders;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.requestHeaders.put(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        String old = this.requestHeaders.getValue(key);
        if (old == null) {
            this.requestHeaders.put(key, value);
        } else {
            this.requestHeaders.put(key, old + "," + value);
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        if (!this.doOutput) {
            throw new ProtocolException("doOutput is false");
        }
        if (!this.requestMethodSetExplicitly) {
            this.method = "POST";
        }
        if (this.requestSink == null) {
            this.requestSink = new ByteArrayOutputStream();
        }
        return this.requestSink;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("doInput is false");
        }
        return this.responseSink;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorSink;
    }

    public Map getHeaderFields() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return null;
            }
        }
        Headers headers = this.response.getHeaders();
        LinkedHashMap<String, List<String>> ret = new LinkedHashMap<String, List<String>>();
        ret.put("", Collections.singletonList(this.getStatusLine(this.response)));
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            ret.put(key, Collections.singletonList(value));
        }
        return ret;
    }

    String getStatusLine(Response response) {
        return "HTTP/" + response.getMajorVersion() + "." + response.getMinorVersion() + " " + response.getCode() + " " + response.getMessage();
    }

    @Override
    public String getHeaderField(int index) {
        Map.Entry entry;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (index == 0) {
            return this.getStatusLine(this.response);
        }
        Iterator i = this.response.getHeaders().entrySet().iterator();
        int count = 1;
        do {
            if (!i.hasNext()) {
                return null;
            }
            entry = (Map.Entry)i.next();
        } while (++count <= index);
        return (String)entry.getValue();
    }

    @Override
    public String getHeaderFieldKey(int index) {
        Map.Entry entry;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (index == 0) {
            return null;
        }
        Iterator i = this.response.getHeaders().entrySet().iterator();
        int count = 1;
        do {
            if (!i.hasNext()) {
                return null;
            }
            entry = (Map.Entry)i.next();
        } while (++count <= index);
        return (String)entry.getKey();
    }

    @Override
    public String getHeaderField(String name) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.response.getHeader(name);
    }

    @Override
    public long getHeaderFieldDate(String name, long def) {
        Date date;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return def;
            }
        }
        return (date = this.response.getDateHeader(name)) == null ? def : date.getTime();
    }

    @Override
    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    @Override
    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getMessage();
    }

    class GetHTTPPropertiesAction
    implements PrivilegedAction {
        GetHTTPPropertiesAction() {
        }

        public Object run() {
            HTTPURLConnection.this.proxyHostname = System.getProperty("http.proxyHost");
            if (HTTPURLConnection.this.proxyHostname != null && HTTPURLConnection.this.proxyHostname.length() > 0) {
                String port = System.getProperty("http.proxyPort");
                if (port != null && port.length() > 0) {
                    HTTPURLConnection.this.proxyPort = Integer.parseInt(port);
                } else {
                    HTTPURLConnection.this.proxyHostname = null;
                    HTTPURLConnection.this.proxyPort = -1;
                }
            }
            HTTPURLConnection.this.agent = System.getProperty("http.agent");
            String ka = System.getProperty("http.keepAlive");
            HTTPURLConnection.this.keepAlive = ka == null || !"false".equals(ka);
            String mc = System.getProperty("http.maxConnections");
            HTTPURLConnection.this.maxConnections = mc != null && mc.length() > 0 ? Math.max(Integer.parseInt(mc), 1) : 5;
            return null;
        }
    }
}

