/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import jp.gr.java_conf.dangan.util.lha.LhaFile;
import jp.gr.java_conf.dangan.util.lha.LhaInputStream;
import jp.sf.orangesignal.csv.Csv;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.LhaEntryFilter;
import jp.sf.orangesignal.csv.ZipEntryFilter;
import jp.sf.orangesignal.csv.filters.BeanFilter;
import jp.sf.orangesignal.csv.handlers.AbstractCsvListHandler;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;
import jp.sf.orangesignal.csv.handlers.BeanOrder;
import jp.sf.orangesignal.csv.manager.CsvLoader;

public abstract class CsvLoaderSupport<T, H extends BeanListHandlerSupport<T, H>, L extends CsvLoaderSupport<T, H, L>>
implements CsvLoader<T> {
    private CsvConfig cfg;
    private H handler;

    protected CsvLoaderSupport(CsvConfig cfg, H handler) {
        if (cfg == null) {
            throw new IllegalArgumentException("CsvConfig must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("CsvListHandler must not be null");
        }
        this.cfg = cfg;
        this.handler = handler;
    }

    protected H getCsvListHandler() {
        return this.handler;
    }

    public L filter(BeanFilter filter) {
        ((BeanListHandlerSupport)this.getCsvListHandler()).filter(filter);
        return (L)this;
    }

    public L order(BeanOrder ... orders) {
        ((BeanListHandlerSupport)this.getCsvListHandler()).order(orders);
        return (L)this;
    }

    public L offset(int offset) {
        ((AbstractCsvListHandler)this.getCsvListHandler()).setOffset(offset);
        return (L)this;
    }

    public L limit(int limit) {
        ((AbstractCsvListHandler)this.getCsvListHandler()).setLimit(limit);
        return (L)this;
    }

    @Override
    public List<T> from(Reader reader) throws IOException {
        return (List)Csv.load(reader, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(InputStream in, String encoding) throws IOException {
        return (List)Csv.load(in, encoding, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(InputStream in) throws IOException {
        return (List)Csv.load(in, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(File file, String encoding) throws IOException {
        return (List)Csv.load(file, encoding, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(File file) throws IOException {
        return (List)Csv.load(file, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(LhaInputStream in, String encoding, LhaEntryFilter filter) throws IOException {
        return Csv.load(in, encoding, this.cfg, this.getCsvListHandler(), filter);
    }

    @Override
    public List<T> from(LhaInputStream in, String encoding) throws IOException {
        return Csv.load(in, encoding, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(LhaInputStream in, LhaEntryFilter filter) throws IOException {
        return Csv.load(in, this.cfg, this.getCsvListHandler(), filter);
    }

    @Override
    public List<T> from(LhaInputStream in) throws IOException {
        return Csv.load(in, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(LhaFile lhaFile, String encoding, LhaEntryFilter filter) throws IOException {
        return Csv.load(lhaFile, encoding, this.cfg, this.getCsvListHandler(), filter);
    }

    @Override
    public List<T> from(LhaFile lhaFile, String encoding) throws IOException {
        return Csv.load(lhaFile, encoding, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(LhaFile lhaFile, LhaEntryFilter filter) throws IOException {
        return Csv.load(lhaFile, this.cfg, this.getCsvListHandler(), filter);
    }

    @Override
    public List<T> from(LhaFile lhaFile) throws IOException {
        return Csv.load(lhaFile, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(ZipInputStream in, String encoding, ZipEntryFilter filter) throws IOException {
        return Csv.load(in, encoding, this.cfg, this.getCsvListHandler(), filter);
    }

    @Override
    public List<T> from(ZipInputStream in, String encoding) throws IOException {
        return Csv.load(in, encoding, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(ZipInputStream in, ZipEntryFilter filter) throws IOException {
        return Csv.load(in, this.cfg, this.getCsvListHandler(), filter);
    }

    @Override
    public List<T> from(ZipInputStream in) throws IOException {
        return Csv.load(in, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(ZipFile zipFile, String encoding, ZipEntryFilter filter) throws IOException {
        return Csv.load(zipFile, encoding, this.cfg, this.getCsvListHandler(), filter);
    }

    @Override
    public List<T> from(ZipFile zipFile, String encoding) throws IOException {
        return Csv.load(zipFile, encoding, this.cfg, this.getCsvListHandler());
    }

    @Override
    public List<T> from(ZipFile zipFile, ZipEntryFilter filter) throws IOException {
        return Csv.load(zipFile, this.cfg, this.getCsvListHandler(), filter);
    }

    @Override
    public List<T> from(ZipFile zipFile) throws IOException {
        return Csv.load(zipFile, this.cfg, this.getCsvListHandler());
    }
}

