/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import net.sf.jasperreports.components.headertoolbar.actions.AbstractVerifiableTableAction;
import net.sf.jasperreports.components.headertoolbar.actions.MoveColumnCommand;
import net.sf.jasperreports.components.headertoolbar.actions.MoveColumnData;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;

public class MoveColumnAction
extends AbstractVerifiableTableAction {
    public void setMoveColumnData(MoveColumnData moveColumnData) {
        this.columnData = moveColumnData;
    }

    public MoveColumnData getMoveColumnData() {
        return (MoveColumnData)this.columnData;
    }

    public String getName() {
        return "move_column_action";
    }

    @Override
    public void performAction() throws ActionException {
        try {
            this.getCommandStack().execute(new ResetInCacheCommand(new MoveColumnCommand(this.table, this.getMoveColumnData()), this.getJasperReportsContext(), this.getReportContext(), this.targetUri));
        }
        catch (CommandException e) {
            throw new ActionException(e.getMessage());
        }
    }

    @Override
    public void verify() throws ActionException {
        MoveColumnData colData = this.getMoveColumnData();
        if (colData.getColumnToMoveNewIndex() > TableUtil.getAllColumns(this.table).size() - 1) {
            this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.move.column.invalid.position", colData.getColumnToMoveNewIndex());
        }
    }
}

