/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * R[he[u𑀍@\񋟂B<br><br>
 * {@link CmCodeDto}pāADBJavavOԂŃR[hLB<br>
 */
public class CmCodeDao extends BaseDao {
	
	// e[uyуL[
	/**
	 *  R[he[uB<br>
	 */
	public static final String TABLE  = "CM_CODE";
	
	/**
	 *  R[he[uAL[1B<br>
	 */
	public static final String KEY_01 = "T_ID";
	
	/**
	 *  R[he[uAL[2B<br>
	 */
	public static final String KEY_02 = "T_CODE";
	
	// 
	/**
	 *  R[he[uA(R[hID)B<br>
	 */
	public static final String COL_T_ID        = "T_ID";
	
	/**
	 *  R[he[uA(R[h)B<br>
	 */
	public static final String COL_T_CODE      = "T_CODE";
	
	/**
	 *  R[he[uA()B<br>
	 */
	public static final String COL_T_NAME      = "T_NAME";
	
	/**
	 *  R[he[uA(\)B<br>
	 */
	public static final String COL_VIEW_INDEX  = "VIEW_INDEX";
	
	/**
	 *  R[he[uA(폜tO)B<br>
	 */
	public static final String COL_DELETE_FLAG = "DELETE_FLAG";
	
	/**
	 * RXgN^B<br>
	 */
	public CmCodeDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * RXgN^B<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public CmCodeDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		this();
		initDao(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return Xg
	 * @throws SQLException
	 */
	private List<CmCodeDto> mappingAll() throws SQLException {
		List<CmCodeDto> all = new ArrayList<CmCodeDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTOList)(findAllTIdp)
	 * @return Xg
	 * @throws SQLException
	 */
	private List<CmCodeDto> mappingAllTId() throws SQLException {
		List<CmCodeDto> all = new ArrayList<CmCodeDto>();
		while (rs.next()) {
			CmCodeDto dto = new CmCodeDto();
			dto.setTId(rs.getString(COL_T_ID));
			all.add(dto);
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private CmCodeDto mapping() throws SQLException {
		CmCodeDto dto = new CmCodeDto();
		dto.setTId(rs.getString(COL_T_ID));
		dto.setTCode(rs.getString(COL_T_CODE));
		dto.setTName(rs.getString(COL_T_NAME));
		dto.setViewIndex(rs.getInt(COL_VIEW_INDEX));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾B<br>
	 * @return (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCodeDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmCodeDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾(T_ID̃Xg)B<br>
	 * @return (DTOList)
	 * @throws SQLException
	 */
	public List<CmCodeDto> findAllTId() throws SQLException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT DISTINCT ");
			sb.append(COL_T_ID + " ");
			sb.append("FROM ");
			sb.append(TABLE + " ");
			prepareStatement(sb.toString());
			executeQuery();
			List<CmCodeDto> all = mappingAllTId();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B<br>
	 * @param tId   R[h敪(L[)
	 * @param tCode R[h(L[)
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCodeDto findForKey(String tId, String tCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, tId);
			setParam(index++, tCode);
			executeQuery();
			CmCodeDto CmCodeDto = null;
			if (rs.next()) {
				CmCodeDto = mapping();
			}
			return CmCodeDto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * L[ɂsbN擾B<br>
	 * @param tId   R[h敪(L[)
	 * @param tCode R[h(L[)
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCodeDto findForUpdate(String tId, String tCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, tId);
			setParam(index++, tCode);
			executeQuery();
			CmCodeDto CmCodeDto = null;
			if (rs.next()) {
				CmCodeDto = mapping();
			}
			return CmCodeDto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * ɂf[^擾B<br>
	 * @param tId        R[h敪(L[)
	 * @return (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCodeDto> findForCondition(String tId) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_T_ID);
		sb.append(" = ? AND ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + "ORDER BY " + COL_VIEW_INDEX + ", " + COL_T_ID);
			setParam(index++, tId);
			setParam(index++, MospConst.DELETE_FLAG_OFF);
			executeQuery();
			List<CmCodeDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(p)B<br>
	 * @param tId        R[h敪(L[)
	 * @param tCode      R[h(L[)
	 * @param tName      R[h(L[)
	 * @param deleteFlag 폜tO(L[)
	 * @return (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCodeDto> findForSearch(
			String tId,
			String tCode,
			String tName,
			String deleteFlag
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		if (!tId.equals("")) {
			sb.append(COL_T_ID);
			sb.append(" = ? AND ");
		}
		if (!tCode.equals("")) {
			sb.append(COL_T_CODE);
			sb.append(" LIKE ? ");
			sb.append("AND ");
		}
		sb.append(COL_T_NAME);
		sb.append(" LIKE ? ");
		if (!deleteFlag.equals("")) {
			sb.append("AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (!tId.equals("")) {
				setParam(index++, tId);
			}
			if (!tCode.equals("")) {
				setParam(index++, tCode + "%");
			}
			setParam(index++, "%" + tName + "%");
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			List<CmCodeDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}B<br>
	 * @param dto }ΏDTO
	 * @return }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmCodeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XVB<br>
	 * @param dto XVΏDTO
	 * @return XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmCodeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getTId());
			setParam(index++, dto.getTCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * p[^ݒ
	 * @param dto      XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmCodeDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getTId());
		setParam(index++, dto.getTCode());
		setParam(index++, dto.getTName());
		setParam(index++, dto.getViewIndex());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
}
