/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.util.Calendar;
import java.util.Date;

/**
 * ÓmFɗLpȃ\bh񋟂B<br><br>
 */
public final class ValidateUtility {
	
	/**
	 * K{mFB<br>
	 * @param value mFΏ
	 * @return true/false
	 */
	public static boolean chkRequired(String value) {
		if (value == null || value.equals("")) {
			return false;
		}
		return true;
	}
	
	/**
	 * K\ɂ镶p^[mFB<br>
	 * @param regex K\
	 * @param value mFΏ
	 * @return true/false
	 */
	public static boolean chkRegex(String regex, String value) {
		if (value.matches(regex)) {
			return true;
		}
		return false;
	}
	
	/**
	 * l(double)mFB<br>
	 * @param value mFΏ
	 * @return true/false
	 */
	public static boolean chkNumeric(String value) {
		try {
			Double.parseDouble(value);
			return true;
		} catch (IllegalArgumentException e) {
			return false;
		}
	}
	
	/**
	 * tÓmFB<br>
	 * @param year   N
	 * @param month  (0`11)
	 * @param day    
	 * @throws MospException
	 */
	public static boolean chkDate(int year, int month, int day) {
		Calendar calendar = Calendar.getInstance();
		calendar.setLenient(false);
		calendar.set(year, month, day);
		try {
			calendar.getTime();
			return true;
		} catch (IllegalArgumentException e) {
			return false;
		}
	}
	
	/**
	 * ԑÓmFB<br>
	 * @param hour   
	 * @param minute 
	 * @param second b
	 * @throws MospException
	 */
	public static boolean chkTime(int hour, int minute, int second) {
		Calendar calendar = Calendar.getInstance();
		calendar.setLenient(false);
		calendar.set(1970, 0, 1, hour, minute, second);
		try {
			calendar.getTime();
			return true;
		} catch (IllegalArgumentException e) {
			return false;
		}
	}
	
	/**
	 * ԑÓmFB<br>
	 * @param date      mFΏۓ
	 * @param startDate Jn
	 * @param endDate   I
	 * @throws MospException
	 */
	public static boolean chkTerm(Date date, Date startDate, Date endDate) {
		if (startDate.compareTo(date) > 0 || endDate.compareTo(date) < 0) {
			return false;
		}
		return true;
	}
	
}
