/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

import jp.mosp.se.SeUtility;

/**
 * MosPAvP[VJŗLpȃ\bh񋟂B<br><br>
 */
public final class MospUtility {

	/**
	 * mosp.jaro[W擾B<br>
	 * @return mosp.japo[W
	 */
	public static String getMospJarVersion() {
		return MospConst.MOSP_JAR_VERSION;
	}

	/**
	 * NXCX^X擾B<br>
	 * @param ctl ݒt@C
	 * @param key ݒt@Cɓo^ĂL[
	 * @return L[ɑΉNX̃CX^X
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 * @throws MosPException
	 */
	public static Object getInstance(
			Properties ctl, String key
	) throws IllegalAccessException, InstantiationException, MospException {
		return getInstance(ctl.getProperty(key));
	}

	/**
	 * NXCX^X擾B<br>
	 * @param className NX
	 * @return ΉNX̃CX^X
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 * @throws MosPException
	 */
	public static Object getInstance(
			String className
	) throws IllegalAccessException, InstantiationException, MospException {
		Object obj = null;
		if (className == null) {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		try {
			obj = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
		} catch (ClassNotFoundException e) {
			throw new MospException(MospConst.EX_CTL_INVALID);
		}
		return obj;
	}

	/**
	 * ݒt@CǍB<br>
	 * @param path ݒt@CpX(΃pX)
	 * @return ݒt@C 
	 * @throws IOException
	 */
	public static Properties getResource(String path) throws IOException {
		Properties pr = new Properties();
		FileInputStream is = new FileInputStream(path);
		pr.loadFromXML(is);
		is.close();
		return pr;
	}

	/**
	 * ݒt@CǍ(ǉ)B<br><br>
	 * pathŎw肳fBNgt@CtargetŏIt@CǂݍށB<br>
	 * AAt@Ct@CtargetŎn܂t@C͑ΏۊOƂB<br>
	 * ǂݍ܂t@ĆAt@C̏B<br>
	 * ̍ہAʃt@Cɓݒ肪ꍇ́A
	 * ɓǂ܂ꂽt@C̐ݒ肪LƂȂB<br>
	 * @param pr     ǉΏۃvpeBIuWFNg
	 * @param path   ݒt@C[gpX(΃pX)
	 * @param target Ώە
	 * @throws IOException
	 */
	public static void addResources(Properties pr, String path, String target) throws IOException {
		String[] files = new File(path).list();
		List<String> list = new ArrayList<String>();
		for (int i = 0; i < files.length; i++) {
			String name = files[i];
			if (name.endsWith(target) && !name.startsWith(target)) {
				list.add(files[i]);
			}
		}
		Collections.sort(list);
		for (int i = 0; i < list.size(); i++) {
			FileInputStream is = new FileInputStream(path + list.get(i));
			pr.loadFromXML(is);
			is.close();
		}
	}

	/**
	 * bZ[W擾B<br>
	 * @param msg     bZ[Wꗗ
	 * @param msgCode bZ[WR[h
	 * @param rep     u(ꍇ̓J}؂)
	 * @return bZ[W
	 * @throws MospException
	 */
	public static String getMessage(Properties msg, String msgCode, String rep) throws MospException {
		String strMsg = msg.getProperty(msgCode);
		if (strMsg == null) {
			throw new MospException(MospConst.EX_NO_MESSAGE);
		}
		return replace(strMsg, rep);
	}

	/**
	 * bZ[W̕usB<br>
	 * @param message 
	 * @param rep     u(ꍇ̓J}؂)
	 * @return bZ[W
	 * @throws MospException
	 */
	public static String replace(String message, String rep) {
		if (message == null) {
			return null;
		}
		String[] aryRep = rep.split(MospConst.DATA_SEPARATOR);
		String replaced = message;
		for (int i = 0; i < aryRep.length; i++ ) {
			replaced = replaced.replaceAll("%" + String.valueOf(i + 1) + "%", aryRep[i]);
		}
		return replaced;
	}
	
	/**
	 * V[PXsB<br>
	 * @param hasMospSeJar mosp-se.jarL
	 * @param stored       ۑĂProcSeq
	 * @return V[PX
	 */
	public static String generateProcSeq(boolean hasMospSeJar, String stored) {
		if (hasMospSeJar) {
			return SeUtility.generateProcSeq();
		}
		String procSeq = "0";
		if (stored != null && ValidateUtility.chkNumeric(stored)) {
			procSeq = String.valueOf(Integer.parseInt(stored) + 1);
		}
		return procSeq;
	}
	
	/**
	 * Í(s)B<br>
	 * @param value Ώە
	 * @return Í
	 * @throws NoSuchAlgorithmException
	 */
	public static String getDigest(String value) throws NoSuchAlgorithmException {
		StringBuffer digest = new StringBuffer();
		MessageDigest md = MessageDigest.getInstance("MD5");
		byte[] bytes = value.getBytes();
		md.update(bytes);
		bytes = md.digest();
		for (int i = 0; i < bytes.length; i++) {
			int b = bytes[i];
			if (b < 0) {
				b += 256;
			}
			if (b < 16) {
				digest.append("0");
			}
			digest.append(Integer.toString(b, 16));
		}
		return digest.toString();
	}


	/**
	 * Í(mosp-se.jarp)B<br>
	 * @param value        Ώە
	 * @param hasMospSeJar mosp-se.jarL
	 * @return Í
	 * @throws NoSuchAlgorithmException
	 */
	public static String encrypt(
			String value, boolean hasMospSeJar
	) throws NoSuchAlgorithmException {
		if (hasMospSeJar) {
			return SeUtility.encrypt(value);
		}
		return value;
	}


	/**
	 * ݒt@CJavaScriptt@CϊB<br>
	 * @param ppt ݒt@C
	 * @param path o̓t@CpX
	 * @param name IuWFNg
	 * @throws FileNotFoundException
	 * @throws UnsupportedEncodingException
	 * @throws IOException
	 */
	public static void convProperties(
			Properties ppt,
			String     path,
			String     name
	) throws FileNotFoundException, UnsupportedEncodingException, IOException {
		FileOutputStream fos = new FileOutputStream(path, false);
		OutputStreamWriter osw = new OutputStreamWriter(fos, "Windows-31J");
		StringBuffer sb = new StringBuffer();
		sb.append("var ");
		sb.append(name);
		sb.append(" = new Object();");
		sb.append(MospConst.LINE_SEPARATOR);
		for (Enumeration<?> e = ppt.propertyNames(); e.hasMoreElements() ;) {
			String key = e.nextElement().toString();
			sb.append(name);
			sb.append("[\"");
			sb.append(key);
			sb.append("\"] = \"");
			sb.append(ppt.getProperty(key));
			sb.append("\";");
			sb.append(MospConst.LINE_SEPARATOR);
		}
		osw.write(sb.toString());
		osw.close();
		fos.close();
	}

	/**
	 * t擾B<br>
	 * @param strDate t
	 * @return t(Date)
	 */
	public static Date getDate(String strDate) throws MospException {
		try{
			DateFormat df = DateFormat.getDateInstance();
			return df.parse(strDate);
		} catch(ParseException e) {
			throw new MospException(MospConst.EX_DATE_INVALID);
		}
	}

	/**
	 * OX^bNg[X擾B<br>
	 * @param ex OIuWFNg
	 * @return OX^bNg[X
	 */
	public static String getStackTrace(Throwable ex) {
		StringWriter sw = new StringWriter();
		PrintWriter  pw = new PrintWriter(sw);
		ex.printStackTrace(pw);
		String msg = sw.toString();
		msg = msg.replaceAll(MospConst.LINE_SEPARATOR, "");
		return msg;
	}

	/**
	 * ASPݒ擾擾B<br>
	 * @param cfg ݒt@C
	 * @return ASPݒ
	 * @throws MospException
	 */
	public static int getAspFlag(Properties cfg) throws MospException {
		try {
			return Integer.parseInt(cfg.getProperty(MospConst.PPT_ASP_FLAG));
		} catch(NumberFormatException e) {
			throw new MospException(MospConst.EX_ASP_PROPERTIES);
		}
	}

	// MosPɊ֌W̖[eBeB[

	/**
	 * t擾B<br>
	 * @param date 
	 * @param format 
	 * @return ԕ(HH:MM)
	 */
	public static String getDateString(Date date, String format) {
		if (date == null) {
			return "";
		}
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		return sdf.format(date);
	}

	/**
	 * N擾B<br>
	 * @param date t
	 */
	public static int getYear(Date date) {
		return getCalendarValue(date, Calendar.YEAR);
	}

	/**
	 * 擾B<br>
	 * @param date t
	 */
	public static int getMonth(Date date) {
		return getCalendarValue(date, Calendar.MONTH) + 1;
	}

	/**
	 * 擾B<br>
	 * @param date t
	 */
	public static int getDay(Date date) {
		return getCalendarValue(date, Calendar.DATE);
	}

	/**
	 * Ԏ擾B<br>
	 * @param date t
	 */
	public static int getHour(Date date) {
		return getCalendarValue(date, Calendar.HOUR_OF_DAY);
	}

	/**
	 * 擾B<br>
	 * @param date t
	 */
	public static int getMinute(Date date) {
		return getCalendarValue(date, Calendar.MINUTE);
	}

	/**
	 * J_[ɂf[^擾B<br>
	 * @param date  t
	 * @param field tB[h
	 */
	public static int getCalendarValue(Date date, int field) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		return calendar.get(field);
	}

	/**
	 * NB<br>
	 * @param date   t
	 * @param amount N
	 * @return t
	 */
	public static  Date addYear(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.YEAR, amount);
		return cal.getTime();
	}

	/**
	 * B<br>
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public static  Date addMonth(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.MONTH, amount);
		return cal.getTime();
	}

	/**
	 * B<br>
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public static  Date addDay(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, amount);
		return cal.getTime();
	}

	/**
	 * VXet擾B<br>
	 * @return VXet
	 */
	public static Date getSystemDate() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * ۂߏ(ľܓ)B<br>
	 * @param value Ώےl
	 * @param scale Ώۈʒu(_ȉF0Ő)
	 * @param mode  @
	 * @throws Exception 
	 */
	public static double round(double value, int scale, int mode) {
		BigDecimal bd = new BigDecimal(value);
		return bd.setScale(scale, mode).doubleValue();
	}

}
