/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * Oo͂ɗLpȃ\bh񋟂B<br><br>
 * Oo͏ėpOAG[Ȍo͓sB<br>
 */
public final class LogUtility {
	
	/**
	 * K[擾B<br>
	 * cfg̐ݒpāAOo͂̏sB<br>
	 * @param cfg AvP[Vݒ
	 * @return AvP[Vݒ𔽉fK[
	 * @throws IOException
	 */
	private static Logger getLogger(Properties cfg) throws IOException {
		// Logger̐
		Logger logger = Logger.getLogger(cfg.getProperty(MospConst.PPT_LOG_NAME));
		if (logger.getHandlers().length == 0) {
			// Loggerݒ肳ĂȂꍇ
			FileHandler fh = new FileHandler(
					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + cfg.getProperty(MospConst.PPT_LOG_PATTERN),
					Integer.parseInt(cfg.getProperty(MospConst.PPT_LOG_SIZE)),
					Integer.parseInt(cfg.getProperty(MospConst.PPT_LOG_COUNT)),
					true
			);
			// Formatterݒ
			fh.setFormatter(new LogFormatClass(cfg.getProperty(MospConst.PPT_LOG_SEPARATOR)));
			// Ȍo͐ǉ
			logger.addHandler(fh);
			//Ȍo̓xݒ
			setLevel(cfg);
		}
		return logger;
	}
	
	/**
	 * G[OóB<br>
	 * ^CG[̃O(X^bNg[X)o͂B
	 * @param ex O
	 * @param request NGXg
	 */
	public static void outputErrorLog(
			Throwable          ex     ,
			HttpServletRequest request
	) {
		try {
			String msg = MospUtility.getStackTrace(ex);
			// Oo
			log(request, 6, MospConst.LOG_ERROR, msg);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	

	/**
	 * OóB<br>
	 * requestɊ܂܂pāAOo͂B
	 * @param request NGXg
	 * @param level Ox(0:FINEST`6:SEVERE)
	 * @param logType O^Cv(MospConst.LOG_...)
	 * @param message ObZ[W
	 */
	public static void log(
			HttpServletRequest request,
			int level,
			String logType,
			String message
	) {
		try {
			// ݒt@C̎擾
			Properties cfg = (Properties)request.getAttribute(MospConst.ATT_CFG);
			// ̎擾
			CmAspUserDto aspUser = (CmAspUserDto)request.getAttribute(MospConst.ATT_ASPUSER);
			CmUserDto user = (CmUserDto)request.getAttribute(MospConst.ATT_USER);
			String strAspUser = aspUser != null ? aspUser.getAspUserId() : "";
			String strUser = user != null ? user.getUserId() : "";
			String strCmd  = (String)request.getAttribute(MospConst.ATT_CMD);
			// Oo
			log(cfg, strAspUser, strUser, strCmd, level, logType, message);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	/**
	 * OóB<br>
	 * ėpOo͋@\񋟂B<br>
	 * @param cfg AvP[Vݒ
	 * @param strAspUser ASP[U[R[h
	 * @param strUser [U[R[h
	 * @param strCmd R}h
	 * @param level Ox(0:FINEST`6:SEVERE)
	 * @param logType O^Cv(MospConst.LOG_...)
	 * @param message ObZ[W
	 */
	public static void log(
			Properties cfg,
			String strAspUser,
			String strUser,
			String strCmd,
			int level,
			String logType,
			String message
	) {
		try {
			// K[擾
			Logger logger = getLogger(cfg);
			// ObZ[W쐬
			StringBuffer msg = new StringBuffer();
			msg.append(logType);
			msg.append(cfg.getProperty(MospConst.PPT_LOG_SEPARATOR));
			msg.append(strAspUser);
			msg.append(cfg.getProperty(MospConst.PPT_LOG_SEPARATOR));
			msg.append(strUser);
			msg.append(cfg.getProperty(MospConst.PPT_LOG_SEPARATOR));
			msg.append(strCmd);
			msg.append(cfg.getProperty(MospConst.PPT_LOG_SEPARATOR));
			msg.append(message);
			// Ox̐ݒ
			Level lvl = null;
			switch (level) {
				case 0:
					lvl = Level.FINEST;
					break;
				case 1:
					lvl = Level.FINER;
					break;
				case 2:
					lvl = Level.FINE;
					break;
				case 3:
					lvl = Level.CONFIG;
					break;
				case 4:
					lvl = Level.INFO;
					break;
				case 5:
					lvl = Level.WARNING;
					break;
				case 6:
					lvl = Level.SEVERE;
				break;
				default:
					lvl = Level.SEVERE;
			}
			// Oo
			logger.log(lvl, msg.toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Oo̓xݒB<br>
	 * cfgɐݒ肳Ă郍K[ɑ΂āAOo̓xݒ肷B
	 * @param cfg MosPAvP[Vݒ
	 */
	public static void setLevel(Properties cfg) {
		// Logger̐
		Logger logger = Logger.getLogger(cfg.getProperty(MospConst.PPT_LOG_NAME));
		//Ȍo̓xݒ
		String lvl = cfg.getProperty(MospConst.PPT_LOG_LEVEL);
		if (lvl.equals("ALL")) {
			logger.setLevel(Level.ALL);
		} else if (lvl.equals("FINER")) {
			logger.setLevel(Level.FINER);
		} else if (lvl.equals("FINE")) {
			logger.setLevel(Level.FINE);
		} else if (lvl.equals("CONFIG")) {
			logger.setLevel(Level.CONFIG);
		} else if (lvl.equals("INFO")) {
			logger.setLevel(Level.INFO);
		} else if (lvl.equals("WARNING")) {
			logger.setLevel(Level.WARNING);
		} else if (lvl.equals("SEVERE")) {
			logger.setLevel(Level.SEVERE);
		} else {
			logger.setLevel(Level.ALL);
		}
	}


}
